#ifndef __MAXHASH_H__
#define __MAXHASH_H__

//###########################################################################
// hash-table template class (taken straight from pview)
// modified:
//   -1 is reserved for "empty key value" instead of 0
//   start with hash table size of 10 instead of 100
//   add "clean" member to clear out keys, but not free the list
#if USE_HASHING

static int exponentialPrimes[] =
	{2, 3, 7, 13, 31, 61, 127, 251, 509, 1021, 2039, 4093, 8191, 16381, 32749,
		65521, 131071, 262139, 524287, 1048573, 2097143};

#define N_PRIMES (sizeof(exponentialPrimes) / sizeof(int))

static int findPrimeForSize(int size)
	{
	for (int i = 0; i < N_PRIMES; i++)
		{
		if (exponentialPrimes[i] > size)
			return exponentialPrimes[i];
		}

	return size + 1;
	}

#define UNUSED_KEY -1

template <class K, class V> class MyHashTable
	{
	protected:

	struct Association
		{
		K key;
		V value;
		};

	Association *ht;
	int htSize;
	int nElements;

	int FindPosition(K key)
		{
		int index;
		K indexedObject;

		index = ((DWORD) key) % htSize;
		while (((indexedObject = ht[index].key) != UNUSED_KEY) && (key != indexedObject))
			{
			index++;
			if (index >= htSize)
				index = 0;
			}
		return index;
		}

	void GrowTo(int newSize)
		{
		Association *oldHt = ht;
		int oldSize = htSize;

		ht = new Association[newSize];
		memset(ht, 0, newSize * sizeof(Association));
		for (int x = 0; x < newSize; x++ )						// init to -1's (unused slot)
			ht[x].key = UNUSED_KEY;
		htSize = newSize;

		if (oldHt != NULL)
			{
			for (int i = 0; i < oldSize; i++)
				{
				if (oldHt[i].key != UNUSED_KEY)
					AddAssociation(oldHt[i].key, oldHt[i].value);
				}
			delete[] oldHt;
			}
		}

	public:

	MyHashTable(int size = 10)
		{
		ht = NULL;
		Initialize(size);
		}

	~MyHashTable()
		{
		if (ht != NULL)
			delete[] ht;
		}

	void Clear()
		{
		if (ht != NULL)
			delete[] ht;
		ht = NULL;
		htSize = 0;
		nElements = 0;
		}

	void Clean()
		{
		memset(ht, 0, htSize * sizeof(Association));
		for (int x = 0; x < htSize; x++ )						// init to -1's (unused slot)
			ht[x].key = -1;
		nElements = 0;											// 4/13/01 11:37am --MQM-- oops, need this!
		}

	void Initialize(int size = 100)
		{
		Clear();
		GrowTo(findPrimeForSize(size * 4));
		}

	int AddAssociation(K key, V &value)
		{
		int index;

		if (nElements >= (htSize / 2))
			GrowTo(findPrimeForSize(htSize * 2 + 8));

		index = FindPosition(key);
		if (ht[index].key == UNUSED_KEY)
			{
			ht[index].key = key;
			ht[index].value = value;
			nElements++;
			return -1 - index;
			}

		return index;
		}

	int GetIndex(K key)
		{
		int index = FindPosition(key);
		if (ht[index].key != UNUSED_KEY)
			return index;
		else
			return -1;
		}

	V& operator[](const int i) const
		{
		return ht[i].value; 
		}

	bool GetNextAssociation(int &hashIndex, K* keyP, V* valueP)
		{
		for (int i = hashIndex; i < htSize; i++)
			{
			if (ht[i].key != UNUSED_KEY)
				{
				hashIndex = i + 1;
				*keyP = ht[i].key;
				*valueP = ht[i].value;
				return true;
				}
			}

		return false;
		}

	inline int Count(void)
		{
		return nElements;
		}
 	};

#endif
//###########################################################################

#endif
