// linkoptions.cpp : implementation file
//

#include "stdafx.h"
#include "..\next.h"
#include "linkoptions.h"
#include "linkui.h"
#include "../sharedbl/linkman.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLinkOptions dialog


CLinkOptions::CLinkOptions(CWnd* pParent /*=NULL*/)
	: CDialog(CLinkOptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLinkOptions)
	m_SelectChildren = FALSE;
	m_SelectParents = FALSE;
	//}}AFX_DATA_INIT
}


void CLinkOptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLinkOptions)
	DDX_Control(pDX, IDC_SELECT_CHILDREN, m_SelectChildrenButton);
	DDX_Control(pDX, IDC_SELECT_PARENTS, m_SelectParentsButton);
	DDX_Control(pDX, IDC_LINKS_SYSTEM, m_SelectSystem);	
	DDX_Check(pDX, IDC_SELECT_CHILDREN, m_SelectChildren);
	DDX_Check(pDX, IDC_SELECT_PARENTS, m_SelectParents);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLinkOptions, CDialog)
	//{{AFX_MSG_MAP(CLinkOptions)
	ON_BN_CLICKED(IDC_LINKS_ALL, OnLinksAll)
	ON_BN_CLICKED(IDC_LINKS_OFF, OnLinksOff)
	ON_BN_CLICKED(IDC_LINKS_SELECTED, OnLinksSelected)
	ON_BN_CLICKED(IDC_LINKS_SYSTEM, OnLinksSystem)
	ON_MESSAGE(CC_COLOR_CHANGE, OnColorChange)	
	ON_BN_CLICKED(IDC_SELECT_CHILDREN, OnSelectChildren)
	ON_BN_CLICKED(IDC_SELECT_PARENTS, OnSelectParents)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLinkOptions message handlers

void CLinkOptions::OnColorChange( WPARAM wparam, LPARAM lparam )
{
	IColorSwatch* swatch = GetIColorSwatch( GetDlgItem( IDC_LINK_COLOR )->m_hWnd );
	NBL_GetLinkMan()->SetLinkColor( swatch->GetColor());
	ReleaseIColorSwatch( swatch );
}
void CLinkOptions::OnLinksAll() 
{
	NBL_GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_ALL );	
}

void CLinkOptions::OnLinksOff() 
{
	NBL_GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_OFF );		
}

void CLinkOptions::OnLinksSelected() 
{
	NBL_GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_SELECTED );	
}

void CLinkOptions::OnLinksSystem() 
{
	// Show System and Select Children/Parents options are mutually exclusive
	m_SelectChildrenButton.SetCheck( 0 );
	m_SelectParentsButton.SetCheck( 0 );
	NBL_GetLinkMan()->SetSelectChildren( false );
	NBL_GetLinkMan()->SetSelectParents( false );
	LinkUI::SetSelectChildren( false );
	LinkUI::SetSelectParents( false );
	NBL_GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_SYSTEM );	
}

void CLinkOptions::OnCancel()
{
	DestroyWindow();
	DestroyLinkOptionsDialog();	
}
BOOL CLinkOptions::OnInitDialog() 
{
	int cur_mode;

	CDialog::OnInitDialog();
	
	IColorSwatch* swatch = GetIColorSwatch( GetDlgItem( IDC_LINK_COLOR )->m_hWnd );
	swatch->SetColor( NBL_GetLinkMan()->GetLinkColor());
	ReleaseIColorSwatch( swatch );

	if( NBL_GetLinkMan()->GetSelectChildren())
	{
		m_SelectChildrenButton.SetCheck( 1 );
	}
	else
	{
		m_SelectChildrenButton.SetCheck( 0 );
	}

	if( NBL_GetLinkMan()->GetSelectParents())
	{
		m_SelectParentsButton.SetCheck( 1 );
	}
	else
	{
		m_SelectParentsButton.SetCheck( 0 );
	}
	cur_mode = NBL_GetLinkMan()->GetDisplayMode();
	switch( cur_mode )
	{
		case ILinkMan::DISPLAY_MODE_OFF:
			GetDlgItem( IDC_LINKS_OFF )->SendMessage( BM_SETCHECK, BST_CHECKED, 0 );
			break;
		case ILinkMan::DISPLAY_MODE_ALL:
			GetDlgItem( IDC_LINKS_ALL )->SendMessage( BM_SETCHECK, BST_CHECKED, 0 );
			break;
		case ILinkMan::DISPLAY_MODE_SELECTED:
			GetDlgItem( IDC_LINKS_SELECTED )->SendMessage( BM_SETCHECK, BST_CHECKED, 0 );			
			break;
		case ILinkMan::DISPLAY_MODE_SYSTEM:
			GetDlgItem( IDC_LINKS_SYSTEM )->SendMessage( BM_SETCHECK, BST_CHECKED, 0 );
			break;
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLinkOptions::OnSelectChildren() 
{
	// Show System and Select Children options are mutually exclusive

	UpdateData();
	
	if( NBL_GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
	{			
		GetDlgItem( IDC_LINKS_ALL )->SendMessage( BM_SETCHECK, BST_CHECKED, 0 );
		m_SelectSystem.SetCheck( 0 );
		NBL_GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_ALL );	
		UpdateWindow();
	}
	NBL_GetLinkMan()->SetSelectChildren(( m_SelectChildren == TRUE ));
	LinkUI::SetSelectChildren( m_SelectChildren == TRUE );
}

void CLinkOptions::OnSelectParents() 
{
	// Show System and Select Parents options are mutually exclusive

	UpdateData();
	
	if( NBL_GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
	{			
		GetDlgItem( IDC_LINKS_ALL )->SendMessage( BM_SETCHECK, BST_CHECKED, 0 );
		m_SelectSystem.SetCheck( 0 );
		NBL_GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_ALL );	
		UpdateWindow();
	}
	NBL_GetLinkMan()->SetSelectParents(( m_SelectParents == TRUE ));
	LinkUI::SetSelectParents( m_SelectParents == TRUE );
}

void	CLinkOptions::SwatchSetColor( COLORREF color )
{
	IColorSwatch* swatch = GetIColorSwatch( GetDlgItem( IDC_LINK_COLOR )->m_hWnd );
	swatch->SetColor( color );
	ReleaseIColorSwatch( swatch );
}
