#ifndef __LINK_LINKMAN_H__
#define __LINK_LINKMAN_H__

#include <ref.h>

enum
{
	REFMSG_SELECT_SURROUNDING_NODES	= REFMSG_USER,
	REFMSG_DESELECT_SURROUNDING_NODES,
	REFMSG_SELECT_REFERRING_LINKS,
	REFMSG_DESELECT_REFERRING_LINKS,
	REFMSG_LINK_SELECTED,		// Sent if a selection change occured and this node was in the new set  (aml)
	REFMSG_SELECT_CHILDREN,
	REFMSG_SELECT_PARENTS,
};

class ILinkMan {
public:
	enum
	{
		DISPLAY_MODE_OFF,
		DISPLAY_MODE_ALL,
		DISPLAY_MODE_SELECTED,
		DISPLAY_MODE_SYSTEM,
		NUM_DISPLAY_MODES
	};

	virtual bool    IsLocked( void ) = 0;		// Returns true if selection related ops should be denied
	virtual void    SetLock( bool bVal ) = 0;
	virtual void	ManyToOneLink( void ) = 0;
	virtual void	OneToManyLink( void ) = 0;
	virtual void	ChainLink( bool closed, bool enumerate = true ) = 0;
	virtual void	ReverseChainLink( bool closed ) = 0;
	virtual void	Unlink( void ) = 0;
	virtual	void	SetLinkColor( Color color ) = 0;
	virtual	Color	GetLinkColor( void ) = 0;
	virtual void	SetDisplayMode( int mode ) = 0;
	virtual int		GetDisplayMode( void ) = 0;
	virtual void	SetSelectChildren( bool select ) = 0;
	virtual bool	GetSelectChildren( void ) = 0;
	virtual void	SetSelectParents( bool select ) = 0;
	virtual bool	GetSelectParents( void ) = 0;
	
	virtual	void	EnableAutoUpdate( bool enable ) = 0;
	virtual	bool	AutoUpdateEnabled( void ) = 0;

	virtual void	IncrementSystemSelectOpID( void ) = 0;
	virtual int		GetSystemSelectID( void ) = 0;
	virtual void	RecalculateReferences( void ) = 0;
	virtual void    CleanAbandonedLinks( void ) = 0;
	
	virtual bool	IsMerging( void ) = 0;
	virtual void	OnPreMerge( void ) = 0;
	virtual void	OnPostMerge( void ) = 0;
	virtual void	OnPostOpen( void ) = 0;
	virtual void	OnPreSave( void ) = 0;

	void	Release() {};
	void	AddRef() {};

};

extern ILinkMan* GetLinkMan( void );	// GUARANTEED TO RETURN A CORRECT VALUE

INode* FindLastLink(INode* node);
INode* FindNextLink(INode* node);
INode* FindStartLink(INode* node);

#endif // __LINK_LINKMAN_H__

