/*
	Flag Reassigner Patch 2
	This is used to acquire email
*/

#include "max.h"
#include "Next.h"
#include "Appdata.h"
#include "misc/maxutil.h"
#include "ifacedatamgr.h"
#include "faceflags/faceflags.h"

extern Interface* gInterface;

void FlagAsCollideSwapCompleted()
{
	ReferenceTarget* scene = gInterface->GetScenePointer();

	AppDataChunk* appdata = scene->GetAppDataChunk(vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_POSTNONCAMERA_COLLIDE_SWAP);

	if (appdata && appdata->data)
	{
		bool* pbFlagged = (bool*)appdata->data;
		*pbFlagged = true;
		return;
	}

	// Need to add new data chunk to file
	bool* pbFlagged = (bool*)malloc(sizeof(bool));
	*pbFlagged = true;

	scene->AddAppDataChunk(vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_POSTNONCAMERA_COLLIDE_SWAP, sizeof(bool), pbFlagged);
}

bool DoFlagReassignment(bool bForce)
{
	// As of 7-14-03 decision was made to get rid of the CAMERA_COLLIDE flag
	// and replace it with NON_CAMERA_COLLIDABLE

	// Do not update the scene if its already been updated
	ReferenceTarget* scene = gInterface->GetScenePointer();

	AppDataChunk* appdata = scene->GetAppDataChunk(vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_POSTNONCAMERA_COLLIDE_SWAP);

	if (appdata && appdata->data && *(bool*)appdata->data)
	{
		int bResult = IDNO;

		if (bForce)
		{
			bResult = MessageBox(gInterface->GetMAXHWnd(), "The scene has already been updated.  Do you want to perform the reset again?", "Reperform flag clear", MB_ICONQUESTION|MB_YESNO);
		}

		if (bResult == IDNO)
			return false;
	}

	// Warn user of impending doom
	if (!bForce)
	{
		int bResult = MessageBox(gInterface->GetMAXHWnd(), "WARNING!  This file has not been updated for the camera collision flag update.  By continuing, all face flags assigned Camera Collidable will be reset.\n\nAre you sure you want to do this?", "Camera Collidable flag update", MB_ICONWARNING|MB_YESNO);

		if (bResult == IDNO)
			return false;
	}

	// Modify the flags on all meshes within the scene
	INodeTab nodeList;
	GetAllNodes(nodeList);

	for(int i = 0; i < nodeList.Count(); i++)
	{
		Object* obj = nodeList[i]->EvalWorldState(0).obj;

		if (obj->CanConvertToType( triObjectClassID ))
		{
			TriObject* triObj = (TriObject*)(obj->ConvertToType(0, triObjectClassID));

			if (triObj)
			{
				// Get the face data channel
				Mesh& mesh = triObj->GetMesh();
				IFaceDataMgr* pFDMgr = static_cast<IFaceDataMgr*>(mesh.GetInterface( FACEDATAMGR_INTERFACE ));
				
				if (pFDMgr)
				{
					FaceFlagsData* fdc = dynamic_cast<FaceFlagsData*>(pFDMgr->GetFaceDataChan( vFACE_FLAGS_CHANNEL_ID ));
				
					if (fdc)
					{
						for (int j = 0; j < fdc->m_data.Count(); j++)
						{
							FlagType& ftype = fdc->m_data[j];

							if (ftype & mFD_NON_CAMERA_COLLIDABLE)
							{
								ftype &= ~mFD_NON_CAMERA_COLLIDABLE;
							}
							
							//mFD_NON_CAMERA_COLLIDABLE
						}
					}
				}
			}

			if (triObj != obj)
				triObj->DeleteThis();
		}
	}

	// Flag the scene as being updated
	bool* bNonCameraCollide = (bool*)malloc(sizeof(bool));
	*bNonCameraCollide = true;

	scene->AddAppDataChunk(vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_POSTNONCAMERA_COLLIDE_SWAP, sizeof(bool), &bNonCameraCollide);

	return true;
}

