#ifndef __EXPORT_SKINEXPORTOPTIONS_H__
#define __EXPORT_SKINEXPORTOPTIONS_H__


class SkinExportOptions
{
public:

	enum
	{
		vVERSION_NUMBER = 0x0009,	
		
		// VERSION HISTORY
		// v4 for m_FileName       aml
		// v5 for m_WarnOnLitVerts aml
		// v6 for m_DirWarn        aml
		// v7 for LOD export       aml
		// v8 for option to view usage file after export	spg
	};

	enum
	{
		vMAX_LENGTH_SKIN_NAME	= 64,
		vMAX_LENGTH_EXPORT_SET	= 64,
		vMAX_LENGTH_DIRPATH     = 256,
	};

	SkinExportOptions( void );

	int		m_Version;
	bool	m_ExportVisibleOnly;
	bool	m_ExportSelected;
	bool	m_ExportSelectionSet;
	TSTR	m_SkinName;
	TSTR	m_ExportSet;
	float	m_Scale;
	TSTR    m_DirPath;				// Export directory path  aml
	bool    m_WarnOnLitVerts;
	bool    m_DirWarn;

	bool    m_AlwaysLOD;		// aml   v7 True if MultiRes LOD data should be constructed even if there isn't
								//          currently a MultiRes modifier on the object (one will be added)
	
	float   m_LODLowerLimit;	// aml   v7 Lower LOD limit
	int     m_LODNumLevels;		// aml   v7 Number of LOD levels to export
	bool    m_LODProgressive;	// aml   v7 True if LOD data changes should be exported for each vert
	bool    m_ExportBySkinName;	// aml   v8 True if ExportBySkinName node data field should be used to export
								//          multiple skins in the same file
	bool	m_ViewUsgFile;		// spg	 v9 True if we should view the usage file after export
};


class SkinOptionsDlg
{
public:
	void Show( void );
	void Hide( void );	
private:
	HWND m_wnd;	
};

int	GetSizeSkinExportOptions( void );
void GetSkinExportOptions( SkinExportOptions* options );
void SetSkinExportOptions( SkinExportOptions* options );

#endif // __EXPORT_SKINEXPORTOPTIONS_H__