#include <Export/AnimOptionsDlg.h>
#include <next.h>
#include <appdata.h>
#include <Export/ExportOptions.h>
#include <Export/SkinExportOptions.h>
#include "path.h"

CStr GetModelName()
{
	AppDataChunk* appdata;

	ReferenceMaker* scene=gInterface->GetScenePointer();
	appdata=scene->GetAppDataChunk(vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_ANIM_EXPORT_OPTIONS_ID);

	if (!appdata)
		return CStr("default");

	// Version doesn't matter since modelname resided at same location in every version
	AnimOptionData* opts=(AnimOptionData*)appdata->data;
	
	if (strlen(opts->modelname)>0)
		return CStr(opts->modelname);
	
	return CStr("default");
}

static INT_PTR CALLBACK SkinExportOptionsDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static SkinOptionsDlg *dlg = NULL;
	
	switch(msg) 
	{
		case WM_INITDIALOG:
		{
			SkinExportOptions options;
			int i;
								
			dlg = (SkinOptionsDlg*) lParam;
			
			// Fill the selection set combo box
			for( i = 0; i < gInterface->GetNumNamedSelSets(); i++ )
			{
				SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_ADDSTRING, 0, 
					(long) gInterface->GetNamedSelSetName( i ));
			}

			GetSkinExportOptions( &options );

			ICustEdit*       model_lod_lower_cap       = GetICustEdit( GetDlgItem( hWnd, IDC_LODCAPB ) );
			ICustEdit*       model_lod_num_levels      = GetICustEdit( GetDlgItem( hWnd, IDC_LODLEVELS ) );
			ISpinnerControl* model_lod_lower_cap_spin  = GetISpinner( GetDlgItem( hWnd, IDC_LODCAPBSPIN ) );
			ISpinnerControl* model_lod_num_levels_spin = GetISpinner( GetDlgItem( hWnd, IDC_LODLEVELSSPIN ) );

			model_lod_lower_cap_spin->LinkToEdit( GetDlgItem( hWnd, IDC_LODCAPB ), EDITTYPE_FLOAT);
			model_lod_num_levels_spin->LinkToEdit( GetDlgItem( hWnd, IDC_LODLEVELS ), EDITTYPE_INT);

			model_lod_lower_cap_spin->SetLimits(0.0f, 100.0f);
			model_lod_num_levels_spin->SetLimits(0,100);

			model_lod_lower_cap_spin->SetValue(options.m_LODLowerLimit, TRUE);
			model_lod_num_levels_spin->SetValue(options.m_LODNumLevels, TRUE);

			ReleaseICustEdit( model_lod_lower_cap );
			ReleaseICustEdit( model_lod_num_levels );
			ReleaseISpinner( model_lod_lower_cap_spin );
			ReleaseISpinner( model_lod_num_levels_spin );

			if( options.m_AlwaysLOD )
			{
				SendDlgItemMessage( hWnd, IDC_ALWAYSLOD, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_LODProgressive )
			{
				SendDlgItemMessage( hWnd, IDC_LODPROGRESSIVE, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_WarnOnLitVerts )
			{
				SendDlgItemMessage( hWnd, IDC_LITVERTWARNING, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_ViewUsgFile )
			{
				SendDlgItemMessage( hWnd, IDC_OPEN_USG, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_DirWarn )
			{
				SendDlgItemMessage( hWnd, IDC_DIRWARN, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_ExportVisibleOnly )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORT_VISIBLE, BM_SETCHECK, BST_CHECKED, 0 );				
			}
			if( options.m_ExportSelected )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORT_SELECTED, BM_SETCHECK, BST_CHECKED, 0 );				
			}
			if( options.m_ExportBySkinName )
			{
				SendDlgItemMessage( hWnd, IDC_EXPORTBYNAME, BM_SETCHECK, BST_CHECKED, 0 );
			}
			if( options.m_ExportSelectionSet )
			{
				HWND sel_combo;
				int index;

				SendDlgItemMessage( hWnd, IDC_EXPORT_SELECTION_SET, BM_SETCHECK, BST_CHECKED, 0 );

				index = SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_FINDSTRING, 0, (long) (char *) options.m_ExportSet );
				if( index != CB_ERR )
				{
					SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_SETCURSEL, index, 0 );
				}		

				sel_combo = GetDlgItem( hWnd, IDC_SELECTION_COMBO );
				EnableWindow( sel_combo, TRUE );
			}			
			else
			{
				HWND sel_combo;

				sel_combo = GetDlgItem( hWnd, IDC_SELECTION_COMBO );
				EnableWindow( sel_combo, FALSE );
			}

			{
				// Initialize the export filename edit box
				ICustEdit* edit = GetICustEdit( GetDlgItem( hWnd, IDC_EDITFILENAME) );
				edit->SetText(options.m_DirPath);
				ReleaseICustEdit( edit );

				edit = GetICustEdit( GetDlgItem( hWnd, IDC_SCALE ));
				edit->SetText( options.m_Scale ); 
				ReleaseICustEdit( edit );

				ShowWindow( hWnd, SW_SHOW );
			}
			break;
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam)) 
			{
				case IDC_GETFILENAME:
				{
					OPENFILENAME ofn;
					char         filename[256]="";

					// Pop open a file dialog
					ofn.lStructSize=sizeof(ofn);
					ofn.hwndOwner=hWnd;
					ofn.hInstance=hInstance;
					ofn.lpstrFilter="All Files (*.*)\0*.*\0\0";
					ofn.lpstrCustomFilter=NULL;
					ofn.nMaxCustFilter=0;
					ofn.nFilterIndex=0;
					ofn.lpstrFile=filename;
					ofn.nMaxFile=256;
					ofn.lpstrFileTitle=NULL;
					ofn.nMaxFileTitle=0;
					ofn.lpstrInitialDir=NULL;
					ofn.lpstrTitle="Select directory for file to be saved as";
					ofn.Flags=OFN_LONGNAMES|OFN_ENABLESIZING;
					ofn.nFileOffset=0;
					ofn.nFileExtension=0;
					ofn.lpstrDefExt=TEXT(".skin");
					ofn.lCustData=0;
					ofn.lpfnHook=NULL;
					ofn.lpTemplateName=NULL;

					GetSaveFileName(&ofn);

					if (strlen(filename)>0)
					{
						// End the filename at the last backslash so we only
						// get the directory
						char* lstbs=strrchr(filename,'\\');
						if (lstbs)
							*lstbs='\0';

						ICustEdit* edit = GetICustEdit( GetDlgItem( hWnd, IDC_EDITFILENAME ));
						edit->SetText(filename);
						ReleaseICustEdit( edit );
					}
					break;
				}

				case IDOK:
				{
					SkinExportOptions options;
					
					options.m_ExportSelected = SendDlgItemMessage( hWnd, IDC_EXPORT_SELECTED, BM_GETCHECK, 0, 0 ) == BST_CHECKED;					
					options.m_ExportVisibleOnly = SendDlgItemMessage( hWnd, IDC_EXPORT_VISIBLE, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportSelectionSet = SendDlgItemMessage( hWnd, IDC_EXPORT_SELECTION_SET, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_WarnOnLitVerts = SendDlgItemMessage( hWnd, IDC_LITVERTWARNING, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ViewUsgFile = SendDlgItemMessage( hWnd, IDC_OPEN_USG, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_DirWarn = SendDlgItemMessage( hWnd, IDC_DIRWARN, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_AlwaysLOD        = SendDlgItemMessage( hWnd, IDC_ALWAYSLOD, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_LODProgressive   = SendDlgItemMessage( hWnd, IDC_LODPROGRESSIVE, BM_GETCHECK, 0, 0 ) == BST_CHECKED;
					options.m_ExportBySkinName = SendDlgItemMessage( hWnd, IDC_EXPORTBYNAME, BM_GETCHECK, 0, 0 ) == BST_CHECKED;

					ICustEdit* model_lod_lower_cap  = GetICustEdit( GetDlgItem( hWnd, IDC_LODCAPB ) );
					ICustEdit* model_lod_num_levels = GetICustEdit( GetDlgItem( hWnd, IDC_LODLEVELS ) );

					options.m_LODLowerLimit = model_lod_lower_cap->GetFloat();
					options.m_LODNumLevels  = model_lod_num_levels->GetInt();

					ReleaseICustEdit( model_lod_lower_cap );
					ReleaseICustEdit( model_lod_num_levels );

					if( options.m_ExportSelectionSet )
					{
						int index;

						index = SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_GETCURSEL, 0, 0 );
						if( index != CB_ERR )
						{
							char selection_set[128];

							SendDlgItemMessage( hWnd, IDC_SELECTION_COMBO, CB_GETLBTEXT, index, (long) selection_set );
							options.m_ExportSet = selection_set;
						}
					}

					ICustEdit* edit = GetICustEdit( GetDlgItem( hWnd, IDC_SCALE ));
					options.m_Scale = edit->GetFloat();
					ReleaseICustEdit( edit );

					// Assign directory path
					edit = GetICustEdit( GetDlgItem( hWnd, IDC_EDITFILENAME ));
					
					// Ironically, MAXs own GetText method does not work properly with MAXs CStr
					// class a buffer must be pre-allocated
					//edit->GetText(options.m_DirPath, SkinExportOptions::vMAX_LENGTH_DIRPATH);
					char tmpBuf[1024];
					edit->GetText(tmpBuf,1023);
					options.m_DirPath = tmpBuf;

					ReleaseICustEdit( edit );

					SetSkinExportOptions( &options );
					DestroySkinOptionsDialog();
					break;
				}
				case IDCANCEL:
				{					
					DestroySkinOptionsDialog();
					break;
				}				
				case IDC_EXPORT_VISIBLE:					
				case IDC_EXPORT_SELECTED:
				{
					HWND sel_combo;

					sel_combo = GetDlgItem( hWnd, IDC_SELECTION_COMBO );
					EnableWindow( sel_combo, FALSE );
					break;
				}
				case IDC_EXPORT_SELECTION_SET:
				{
					HWND sel_combo;

					sel_combo = GetDlgItem( hWnd, IDC_SELECTION_COMBO );
					EnableWindow( sel_combo, TRUE );
					break;
				}
				default:
					break;
			}
			break;
		}		
		default:
			return FALSE;
	}
	return TRUE;
}

void	SkinOptionsDlg::Show( void )
{
	m_wnd = CreateDialogParam(
		hInstance,
		MAKEINTRESOURCE(IDD_SKIN_EXPORT_OPTIONS),
		gInterface->GetMAXHWnd(),
		SkinExportOptionsDlgProc,
		(LPARAM)this);	
	TSTR title = "Skin Options";
	SetWindowText( m_wnd, title );
	gInterface->RegisterDlgWnd( m_wnd );
}

void	SkinOptionsDlg::Hide( void )
{
	gInterface->UnRegisterDlgWnd( m_wnd );
	DestroyWindow( m_wnd );	
}

void GetSkinExportOptions( SkinExportOptions* options )
{
	char* options_data;
	ReferenceTarget *scene = gInterface->GetScenePointer();
	AppDataChunk* pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SKIN_EXPORT_OPTIONS_ID );

	// Return the export options if they exist
	if( pad && pad->data )
	{
		int version;

		options_data = (char *) pad->data;
		version = *options_data;
		
		// Remain backward compatible with version 4

		//if( version != SkinExportOptions::vVERSION_NUMBER )
		if ( version < 0x0004 /*SkinExportOptions::vVERSION_NUMBER*/ )
		{
			// for now, don't be backward compatible. This will force the dialog
			// to use the default values
			scene->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SKIN_EXPORT_OPTIONS_ID );			
		}
		else
		{
			char set_name[SkinExportOptions::vMAX_LENGTH_EXPORT_SET];
			char dirpath[SkinExportOptions::vMAX_LENGTH_DIRPATH];

			memcpy( &options->m_Version, options_data, sizeof( int ));			
			options_data += sizeof( int );
			memcpy( &options->m_ExportVisibleOnly, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( &options->m_ExportSelected, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( &options->m_ExportSelectionSet, options_data, sizeof( bool ));
			options_data += sizeof( bool );
			memcpy( set_name, options_data, SkinExportOptions::vMAX_LENGTH_EXPORT_SET );
			options_data += SkinExportOptions::vMAX_LENGTH_EXPORT_SET;
			options->m_ExportSet = set_name;
			memcpy( &options->m_Scale, options_data, sizeof( float ));
			options_data += sizeof( float );
			memcpy( dirpath, options_data, SkinExportOptions::vMAX_LENGTH_DIRPATH );
			options->m_DirPath=dirpath;
			options_data += SkinExportOptions::vMAX_LENGTH_DIRPATH;

			// Remain backward compatible with v4
			if ( version >= 0x0005 )
			{
				memcpy( &options->m_WarnOnLitVerts, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if ( version >= 0x0006 )
			{
				memcpy( &options->m_DirWarn, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if ( version >= 0x0007 )
			{
				memcpy( &options->m_AlwaysLOD, options_data, sizeof( bool ));
				options_data += sizeof( bool );

				// Temporarily disabling.  All MultiRes mods should be manually applied for now
				options->m_AlwaysLOD = false;

				memcpy( &options->m_LODLowerLimit, options_data, sizeof( float ));
				options_data += sizeof( float );

				memcpy( &options->m_LODNumLevels, options_data, sizeof( int ));
				options_data += sizeof( int );

				memcpy( &options->m_LODProgressive, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if ( version >= 0x0008 )
			{
				memcpy( &options->m_ExportBySkinName, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}

			if ( version >= 0x0009 )
			{
				memcpy( &options->m_ViewUsgFile, options_data, sizeof( bool ));
				options_data += sizeof( bool );
			}
		}
	}	
}

void SetSkinExportOptions( SkinExportOptions* options )
{
	char* options_data;	
	AppDataChunk* pad;
	ReferenceTarget *scene;
	int version;
	char set_name[SkinExportOptions::vMAX_LENGTH_EXPORT_SET];
	char dirpath[SkinExportOptions::vMAX_LENGTH_DIRPATH];

	assert( options );

	scene = gInterface->GetScenePointer();	
	pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SKIN_EXPORT_OPTIONS_ID );
	
	if( !pad )
	{
		options_data = new char[GetSizeSkinExportOptions()];		
		scene->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_SKIN_EXPORT_OPTIONS_ID, 
			GetSizeSkinExportOptions(), (void*) options_data );	
	}
	else
	{
		options_data = (char*) pad->data;		
	}

	version = SkinExportOptions::vVERSION_NUMBER;
	memcpy( options_data, &version, sizeof( int ));	
	options_data += sizeof( int );
	memcpy( options_data, &options->m_ExportVisibleOnly, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportSelected, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportSelectionSet, sizeof( bool ));
	options_data += sizeof( bool );
	strcpy( set_name, options->m_ExportSet );
	memcpy( options_data, set_name, SkinExportOptions::vMAX_LENGTH_EXPORT_SET );
	options_data += SkinExportOptions::vMAX_LENGTH_EXPORT_SET;	
	memcpy( options_data, &options->m_Scale, sizeof( float ));
	options_data += sizeof( float );
	strcpy( dirpath, options->m_DirPath );
	memcpy( options_data, dirpath, SkinExportOptions::vMAX_LENGTH_DIRPATH );
	options_data += SkinExportOptions::vMAX_LENGTH_DIRPATH;
	memcpy( options_data, &options->m_WarnOnLitVerts, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_DirWarn, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_AlwaysLOD,sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_LODLowerLimit, sizeof( float ));
	options_data += sizeof( float );
	memcpy( options_data, &options->m_LODNumLevels, sizeof( int ));
	options_data += sizeof( int );
	memcpy( options_data, &options->m_LODProgressive, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ExportBySkinName, sizeof( bool ));
	options_data += sizeof( bool );
	memcpy( options_data, &options->m_ViewUsgFile, sizeof( bool ));
	options_data += sizeof( bool );
}

int	GetSizeSkinExportOptions( void )
{
	int size;

	size = 0;
	
	size += sizeof( int );	//	int		m_Version;	
	size += sizeof( bool );
	size += sizeof( bool );
	size += sizeof( bool );
	size += SkinExportOptions::vMAX_LENGTH_EXPORT_SET;		
	size += sizeof( float );	// float	m_Scale;
	size += SkinExportOptions::vMAX_LENGTH_DIRPATH;
	size += sizeof( bool );
	size += sizeof( bool );		// m_DirWarn   aml
	size += sizeof( bool );     // m_AlwaysLOD
	size += sizeof( float );    // m_LODLowerLimit
	size += sizeof( int );      // m_LODNumLevels
	size += sizeof( bool );     // m_LODProgressive
	size += sizeof( bool );     // m_ExportBySkinName
	size += sizeof( bool );     // m_ViewUsgFile  aml

	return size;
}

SkinExportOptions::SkinExportOptions( void )
{	
	m_Version = vVERSION_NUMBER;
	m_ExportVisibleOnly = true;
	m_ExportSelected = false;
	m_ExportSelectionSet = false;
	m_SkinName = "";
	m_ExportSet = "";
	m_Scale = 1.0f;
	m_DirWarn = true;

	m_AlwaysLOD        = false;
	m_LODLowerLimit    = 50.0f;
	m_LODNumLevels     = 5;
	m_LODProgressive   = false;	
	m_ExportBySkinName = false;
	m_ViewUsgFile = false;
}
