#ifndef __EXPORT_SCRIPTEXPORT_H__
#define __EXPORT_SCRIPTEXPORT_H__

#include <Next.h>
#include <Export/SceneExportOptions.h>

class IScriptExporter
{
public:
	virtual	bool	ExportScripts( SceneExportOptions& export_options, bool bModel=false, char* modelName = NULL) = 0;
	virtual bool	ExportScriptsFromSet( char* scene_name, Tab <INode *> &m_exportable_nodes, bool bModel, char* modelName = NULL) = 0;
	virtual Point3  ComputePosition(INode* node) = 0;
	virtual bool	ExportableNodesExist( SceneExportOptions& export_options ) = 0;
	
	virtual bool	OutputStrNode(INode* node, CStr& outBuf, CStr& outBuf2, LinkList<CStr>* scripts, bool bForceOrigin = false) = 0;
	
	virtual void	        ClearParticleTextureList( void ) = 0;
	virtual LinkList<CStr>* GetParticleTextureList( void ) = 0;
	
	virtual bool	ParseScriptIni(char* filename = NULL) = 0;
};

IScriptExporter* GetScriptExporter( void );

#endif // __EXPORT_SCRIPTEXPORT_H__