/*
	PartialAnimEditor.h
	Partial Animation Editor
	6-25-03
*/

#ifndef __PARTIALANIMEDITOR__
#define __PARTIALANIMEDITOR__

#include "../UI/ModalDlg.h"
#include "../misc/llist.h"
#include "max.h"

struct PartialAnimSet
{
	LinkList<CStr>   bones;		// List of all the bone names for the bones within this set
	CStr             name;		// Name of this animation set

	bool             IsExportableBone(CStr boneName);
};

class PartialAnimEditor: public ModalDlgWindow
{	
	LinkList<PartialAnimSet> db;		// Database of partial animation sets

	BOOL DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void PopulateAnimSetList();
	void PopulateAnimBoneList();

public:
	PartialAnimEditor(HINSTANCE hInstance, HWND hwndParent);
	~PartialAnimEditor();

	inline LinkList<PartialAnimSet>* GetAnimDB() { return &db; }

	void AddBone();
	void RemoveBone();
	void AddSet();
	void RemoveSet();
	void RenameSet();

	bool LoadAnimSets();
	bool SaveAnimSets();

	bool IsExportableBone(CStr partialAnimName, CStr boneName);
	PartialAnimSet* GetPartialAnimSet(CStr partialAnimName);
};

#endif
