/*
 	ObjKeyEditor.cpp
	Per Object Key Editor Window
*/

#include "CutsceneExportDlg.h"
#include "ObjKeyEditor.h"
#include "Resource.h"

ObjKeyEditor::ObjKeyEditor(HINSTANCE hInstance, HWND hwndParent, CutsceneObj* cso) :
	MSDlgWindow(hInstance, MAKEINTRESOURCE(IDD_PEROBJECTKEYEDITOR), hwndParent)
{
	pCutsceneObj     = cso;
	fpKeyChanged     = NULL;
	pKeyChangedData  = NULL;
	
	pScriptKeyEditor = new ScriptKeyEditor(hInstance, hwnd);

	objTrack = new TrackUI(hInstance);
	objTrack->Attach(GetDlgItem(hwnd, IDC_TRACK));
	objTrack->CreateKeyList(&pCutsceneObj->trackKeyDB);
	objTrack->SetKeyChangedCB(ctKeyChanged, this);
	objTrack->SetKeyActionCB(KeyActionCB, this);
}

ObjKeyEditor::~ObjKeyEditor()
{
	delete pScriptKeyEditor;
	delete objTrack;
}

void ObjKeyEditor::Show()
{
	objTrack->CreateKeyList(&pCutsceneObj->trackKeyDB);
	objTrack->SetKeyChangedCB(ctKeyChanged, this);
	objTrack->SetKeyActionCB(KeyActionCB, this);

	char buf[1024];
	sprintf(buf, "Per Object Script Key Editor - [%s]", (char*)pCutsceneObj->name);
	SetWindowText(hwnd, buf);	

	POINT pt;
	GetCursorPos(&pt);
	SetWindowPos(hwnd, HWND_TOP, pt.x, pt.y, 0, 0, SWP_NOSIZE);

	MSDlgWindow::Show();
}

void ObjKeyEditor::ctKeyChanged(TrackUI* trackUI, void* pData)
{
	ObjKeyEditor* pthis = (ObjKeyEditor*)pData;

	// Call any attached callback
	if (pthis->fpKeyChanged)
		pthis->fpKeyChanged(pthis, pthis->pCutsceneObj, pthis->pKeyChangedData);

	// Mark this object as modified
	pthis->pCutsceneObj->bModified = true;
	pthis->pCutsceneObj->trackKeyDB = *pthis->objTrack->GetKeyList();
}

void ObjKeyEditor::KeyActionCB(Link<TrackUIKey>* link, void* pData)
{
	ObjKeyEditor* pthis = (ObjKeyEditor*)pData;

	pthis->pScriptKeyEditor->BuildKeyList(pthis->objTrack);
	pthis->pScriptKeyEditor->SetKeyAdjust(link);

	pthis->objTrack->LockAffectKey(link);
	pthis->pScriptKeyEditor->SetTimeChangeCB(pthis->KeyTimeChanged,pthis);
	pthis->pScriptKeyEditor->SetUpdateCB(pthis->UpdateKeys,pthis);
	pthis->pScriptKeyEditor->SetCancelCB(pthis->CancelKeyUpdate,pthis);
	pthis->pScriptKeyEditor->SetKeyChangeCB(pthis->KeyChanged,pthis);
	pthis->pScriptKeyEditor->Show();
}

void ObjKeyEditor::KeyTimeChanged(int time, void* pData)
{
	ObjKeyEditor* pthis = (ObjKeyEditor*)pData;
	pthis->objTrack->Refresh();
}

void ObjKeyEditor::UpdateKeys(ScriptKeyEditor* pEditor, void* pData)
{
	ObjKeyEditor* pthis = (ObjKeyEditor*)pData;

	pthis->objTrack->UnlockAffectKey();
	pthis->objTrack->CallKeyUpdatedCB();
	pthis->objTrack->Refresh();
}

void ObjKeyEditor::CancelKeyUpdate(ScriptKeyEditor* pEditor, void* pData)
{
	ObjKeyEditor* pthis = (ObjKeyEditor*)pData;

	pthis->objTrack->UnlockAffectKey();
	pthis->objTrack->Refresh();
}

void ObjKeyEditor::KeyChanged(ScriptKeyEditor* pEditor, Link<TrackUIKey>* link, void* pData)
{
	ObjKeyEditor* pthis = (ObjKeyEditor*)pData;

	pthis->objTrack->LockAffectKey(link);
}

BOOL ObjKeyEditor::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
/*
	case WM_INITDIALOG:
		{
			objTrack = new TrackUI(hInstance);
			objTrack->Attach(GetDlgItem(hwnd, IDC_TRACK));
			objTrack->CreateKeyList(&pCutsceneObj->trackKeyDB);
			objTrack->SetKeyChangedCB(ctKeyChanged, this);
			objTrack->SetKeyActionCB(KeyActionCB, this);
/*
	pthis->scriptKeyEditor->BuildKeyList(pthis->pCameraTrack);
	pthis->scriptKeyEditor->SetKeyAdjust(link);
	pthis->pCameraTrack->LockAffectKey(link);
	pthis->scriptKeyEditor->SetTimeChangeCB(pthis->KeyTimeChanged,pthis);
	pthis->scriptKeyEditor->SetUpdateCB(pthis->UpdateKeys,pthis);
	pthis->scriptKeyEditor->SetCancelCB(pthis->CancelKeyUpdate,pthis);
	pthis->scriptKeyEditor->SetKeyChangeCB(pthis->KeyChanged,pthis);
	pthis->scriptKeyEditor->Show();
*//*
			char buf[1024];
			sprintf(buf, "Per Object Script Key Editor - [%s]", (char*)pCutsceneObj->name);
			SetWindowText(hwnd, buf);	
		}
		return TRUE;
*/

	case WM_CLOSE:
		//EndDialog(hwnd, 0);
		Hide();
		return TRUE;
	}

	return FALSE;
}

void ObjKeyEditor::SetKeyChangedCB(void (*fp)(ObjKeyEditor*,CutsceneObj*,void*), void* pData)
{
	fpKeyChanged     = fp;
	pKeyChangedData = pData;
}
