#ifndef __EXPORT_MODELEXPORT_H__
#define __EXPORT_MODELEXPORT_H__

#include <next.h>
#include <export/export.h>
#include <export/ModelExportOptions.h>
#include "../../genlib/virtualfile.h"
#undef PI
#undef DegToRad
#undef RadToDeg
#include <core/math.h>

class NxModel : public GeoDatabase
{
public:
	enum
	{
		MODEL_VERSION = 0x0001,
	};

	struct BoneDesc
	{
		unsigned long crc;	// The CRC name of this bone
		Mth::Matrix   mat;	// Matrix to convert local coords into coord system of parent
	};

	int nBones;			// Number of objects being exported with hierarchial information
						// this includes dummy objects

	BoneDesc*  bones;	// Contains the per bone info

	NxModel( void );
	~NxModel();
};

class IModelExporter : public Exporter
{
public:

	virtual NxModel*		ExtractModelData( Tab <INode *>& exportable_nodes, bool skinned, float scale, INode* rootBone = NULL, bool bCutscene = false) = 0;

	// From Exporter
	virtual	bool	DoExport( ExportType type ) = 0;
	virtual bool	Save( void ) = 0;

	virtual void SetExportOptions(ModelExportOptions* expopt)=0;

	// Made Available for Cutscene Exporter
	virtual bool	SaveGeometry( IoUtils::CVirtualOutputFile &file ) = 0;
	virtual void    SetExportModel(NxModel* model) = 0;

private:
	
	ModelExportOptions	m_export_options;
};

IModelExporter* GetModelExporter( void );

#endif // __EXPORT_MODELEXPORT_H__