/*
	AnimStore.h
	A utility plugin to allow the storing of a node's anim transforms
	and the reaplication thereof to another model while retaining 
	hierarchial transform data from deleted nodes

    aml - 10-18-02
*/

#ifndef __ANIMSTORE__
#define __ANIMSTORE__

#include "max.h"
#include "utilapi.h"
#include "iparamb2.h"

#define ANIMSTORE_CLASS_ID  Class_ID(0x56324850, 0x2974797f)

class NodeSelect;

class AnimStore: public UtilityObj
{
	HWND        hwndRollup;
	Interface   *ip;

	// From UtilityObj
	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }

public:
	AnimStore();
	~AnimStore();
};

class AnimStoreClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new AnimStore(); }
	const TCHAR *	ClassName() {return _T("NeverSoft AnimStore Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return ANIMSTORE_CLASS_ID;}
	const TCHAR* 	Category() {return _T("AnimStore");}
	const TCHAR*	InternalName() { return _T("AnimStore"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	
};

#endif
