// qmake.cpp : Defines the entry point for the application.
//
// To do:	Use fprintf(stderr instead of printf
//			Check that spawnvp worked.

#include "stdafx.h"
#include "stdio.h"
#include "string.h"
#include "stdlib.h"
#include "conio.h"
#include "process.h"
#include "time.h"
#include "sys/types.h"
#include "sys/stat.h"

#define TRUE 1

void Assert(int Condition, char *pMessage)
{
	if (!Condition)
	{
		printf("qmake assertion failed:\n%s",pMessage);
		exit(1);
	}
}

#define MAXFILENAMECHARS 1000
#define MAXDIRBUFCHARS 1000

int main(int argc, char* argv[])
{
	bool create_map_file=false;
	if (argc==2)
	{
		if (stricmp(argv[1],"-createmapfile")==0)
		{
			create_map_file=true;
		}

		if (stricmp(argv[1],"-help")==0 ||
			stricmp(argv[1],"-?")==0 ||
			stricmp(argv[1],"?")==0)
		{
			printf("\n");
			printf("QMake.exe, %s\n\n",__DATE__);
			printf("QMake will open %%SKATE4_PATH%%\\bin\\win32\\qmake.txt and call QComp.exe on all\n");
			printf("the .q and .qn files listed within that require QComp'ing.\n");
			printf("qmake.txt is just a directory listing generated by a 'dir /b' command.\n\n");

			printf("Use the -createmapfile option to have qcomp generate qcomp.map\n");
			printf("(Note: This will make qcomp very slow)\n\n");
			exit(1);
		}
	}

	char DirNameBuf[MAXDIRBUFCHARS+1];
	const char *p_skate4_path=getenv("SKATE4_PATH");
	Assert(p_skate4_path!=NULL,"QMake.exe requires that the SKATE4_PATH environment variable be set.");

	Assert(strlen(p_skate4_path)+strlen("\\bin\\win32\\qmake.txt")<=MAXDIRBUFCHARS,"Path too long.");
	strcpy(DirNameBuf,p_skate4_path);
	strcat(DirNameBuf,"\\bin\\win32\\qmake.txt");

	FILE *listifp=fopen(DirNameBuf,"r");
	Assert(listifp!=NULL,"Could not open qmake.txt.\n\nYou need to run qcompall.bat to generate qmake.txt");

    // Check each of the files listed.
	int FinalErrorCode=0;
    while (TRUE)
    {
        // File name buffer.
        char NameBuf[MAXFILENAMECHARS+1];
        // Make sure it is terminated in case the "too many chars" assert goes off.
        NameBuf[MAXFILENAMECHARS]=0;

        // Load each character into the buffer until end-of-line or end-of-file.
        int i=0;
        while (TRUE)
        {
            Assert(i<=MAXFILENAMECHARS,"Too many chars in filename.");
			char ch=fgetc(listifp);

            // Check if end-of-file or end-of-line.
            if (ch==EOF || ch=='\n')
            {
                // Terminate the current string.
                NameBuf[i]=0;
                break;
            }

			NameBuf[i]=ch;
            ++i;
        }

        if (NameBuf[0])
		{
			// Derive the .qb filename.
	        char QBNameBuf[MAXFILENAMECHARS+1];
			strcpy(QBNameBuf,NameBuf);
			int Len=strlen(QBNameBuf);
			Assert(Len>3,"Very short filename?");

			if (stricmp(&QBNameBuf[Len-2],".q")==0)
				// Append a 'b' if it is a .q
				strcat(QBNameBuf,"b");
			else if (stricmp(&QBNameBuf[Len-3],".qn")==0)
				// Change to qb if it is a .qn
				QBNameBuf[Len-1]='b';
			else
				Assert(0,"Filename does not have .q or .qn extension");

			struct stat SourceStatBuf;
			struct stat QBStatBuf;
			int ReturnCode=stat(QBNameBuf,&QBStatBuf);

			if (ReturnCode==-1)
			{
				// The QB file does not exist so compile the source file.
				printf("Compiling new source file %s\n",NameBuf);
				char *args[5];
				args[0]="qcomp";
				args[1]=NameBuf;
				//args[2]="-nomessageboxes";
				//args[2]="-textfile";
				if (create_map_file)
				{
					args[2]=NULL;
				}
				else
				{
					args[2]="-nomapfile";
					args[3]=NULL;
				}
				int ErrorCode=spawnvp(P_WAIT,args[0],&args[0]);
				if (ErrorCode<0)
				{
					printf("spawnvp failed! Try closing this DOS window and open a new one.\n");
				}
				if (ErrorCode>0)
				{
					printf("QComp.exe returned an error.\n");
				}
				if (ErrorCode && !FinalErrorCode)
				{
					FinalErrorCode=ErrorCode;
				}
			}
			else
			{
				Assert(ReturnCode==0,"Unexpected ReturnCode when running stat on qb filename");
				ReturnCode=stat(NameBuf,&SourceStatBuf);
				Assert(ReturnCode==0,"Unexpected ReturnCode when running stat on source filename");

				if (SourceStatBuf.st_mtime>QBStatBuf.st_mtime)
				{
					// The source file is newer than the QB, so compile the source file.
					printf("Compiling %s\n",NameBuf);
					char *args[5];
					args[0]="qcomp";
					args[1]=NameBuf;
					//args[2]="-nomessageboxes";
					//args[2]="-textfile";
					//args[2]="-nomapfile";
					if (create_map_file)
					{
						args[2]=NULL;
					}
					else
					{
						args[2]="-nomapfile";
						args[3]=NULL;
					}
					int ErrorCode=spawnvp(P_WAIT,args[0],&args[0]);
					if (ErrorCode<0)
					{
						printf("spawnvp failed! Try closing this DOS window and open a new one.\n");
					}
					if (ErrorCode>0)
					{
						printf("QComp.exe returned an error.\n");
					}
					if (ErrorCode && !FinalErrorCode)
					{
						FinalErrorCode=ErrorCode;
					}
				}
			}
		}
        else
            break;
    }
	
	fclose (listifp);
	return FinalErrorCode;
}



