#ifndef __XBOX_XBOXCONV_H__
#define __XBOX_XBOXCONV_H__

#include <SceneConv.h>

#define vXBOX_COLLISION_VERSION_NUMBER	0x0009	
#define	vXBOX_MATERIAL_VERSION_NUMBER	0x0001
#define vXBOX_MESH_VERSION_NUMBER		0x0001
#define vXBOX_VERTEX_VERSION_NUMBER		0x0001
#define vXBOX_TEXTURE_VERSION_NUMBER	0x0001	
#define vXBOX_CASFLAGS_VERSION_NUMBER	0x0002
#define vXBOX_WEIGHTMAP_VERSION_NUMBER	0x0001

class IXBoxConverter : public SceneConverter
{
public:
	virtual bool	SaveCollisionData( char* path ) = 0;
	virtual bool	ConvertData( void ) = 0;
	virtual bool	SaveScene( char* path ) = 0;
	virtual bool	SaveTextureDictionary( char* path, char* usg_path ) = 0;
	virtual bool	SaveCASFlags( char* path ) = 0;	
	virtual bool	SaveWeightMap( char* path ) = 0;
};

IXBoxConverter* GetXBoxConverter( void );
void ResetXBoxConverter( void );

#endif	// __XBOX_XBOXCONV_H__