#ifndef __SCENECONV_H__
#define __SCENECONV_H__

#pragma warning( disable : 4355 ) // 'this' : used in base member initializer list
#pragma warning( disable : 4786 ) // identifier was truncated to '255' characters in the debug information

#include <strip/strip.h>
#include <List/Head.h>
#include <List/Node.h>
#include <List/llist.h>
#include <core/debug/checks.h>
#include <core/math.h>
#include <core/hashtable.h>

#include "Utility.h"

using namespace std;

namespace IoUtils
{
	class CVirtualInputFile;
	class CVirtualOutputFile;
}

#define vMAX_MATERIAL_PASSES	4
#define vMAX_WIBBLE_SEQUENCES	8
typedef	__int64	FlagType;
typedef __int64 CASFlagType;

#define	GENERATE_FIXED_POINT_COLLISION	1

typedef enum
{
	mPLAT_PS2 = 1 << Utils::vPLATFORM_PS2,
	mPLAT_NGC = 1 << Utils::vPLATFORM_NGC,
	mPLAT_XBOX     = 1 << Utils::vPLATFORM_XBOX,
	mPLAT_PCVIEWER = 1 << Utils::vPLATFORM_PCVIEWER,
};

typedef enum
{
	vMAPPING_EXPLICIT,
	vMAPPING_ENVIRONMENT,
} MappingMode;

typedef enum
{
	vFILTERING_NEAREST,
	vFILTERING_LINEAR,
	vFILTERING_NEAREST_MIPMAP_NEAREST,
	vFILTERING_NEAREST_MIPMAP_LINEAR,
	vFILTERING_LINEAR_MIPMAP_NEAREST,
	vFILTERING_LINEAR_MIPMAP_LINEAR
} FilteringMode;    

typedef enum
{
	vBLEND_MODE_DIFFUSE,				// ( 0 - 0 ) * 0 + Src
	vBLEND_MODE_ADD,					// ( Src - 0 ) * Src + Dst
	vBLEND_MODE_ADD_FIXED,				// ( Src - 0 ) * Fixed + Dst
	vBLEND_MODE_SUBTRACT,				// ( 0 - Src ) * Src + Dst
	vBLEND_MODE_SUB_FIXED,				// ( 0 - Src ) * Fixed + Dst
	vBLEND_MODE_BLEND,					// ( Src - Dst ) * Src + Dst	
	vBLEND_MODE_BLEND_FIXED,			// ( Src - Dst ) * Fixed + Dst	
	vBLEND_MODE_MODULATE,				// ( Dst - 0 ) * Src + 0
	vBLEND_MODE_MODULATE_FIXED,			// ( Dst - 0 ) * Fixed + 0	
	vBLEND_MODE_BRIGHTEN,				// ( Dst - 0 ) * Src + Dst
	vBLEND_MODE_BRIGHTEN_FIXED,			// ( Dst - 0 ) * Fixed + Dst	
	vBLEND_MODE_GLOSS_MAP,				// Src/Dst/Fixed N/A
	vBLEND_MODE_BLEND_PREVIOUS_MASK,	// ( Src - Dst ) * Dst + Dst
	vBLEND_MODE_BLEND_INVERSE_PREVIOUS_MASK,	// ( Dst - Src ) * Dst + Src
	vBLEND_MODE_ADD_PREVIOUS_ALPHA,		// ( Src - 0 ) * Dst + Src

	vNUM_BLEND_MODES
} BlendModes; 

enum
{
	vPARAM_SRC,
	vPARAM_DST,
	vPARAM_ZERO,
	vPARAM_RESERVED,
	vPARAM_FIXED = vPARAM_ZERO
};

#define	vINVALID_CHECKSUM	0xFFFFFFFF
#define vNO_GROUP			-1

class NxAnimatedTextureKeyframe
{
public:
	NxAnimatedTextureKeyframe( void );

	unsigned int	m_Time;
	unsigned long	m_TexChecksum[Utils::vNUM_PLATFORMS];
};

class NxAnimatedTexture
{
public:
	enum
	{
		vLOOP,
		vPING_PONG,
	};
	NxAnimatedTexture( void );
	~NxAnimatedTexture( void );

	int	m_NumKeyframes;
	int	m_Period;
	int m_Iterations;
	int m_Phase;
	NxAnimatedTextureKeyframe*	m_Keyframes;
};

class NxMaterialPass
{
public:
	enum
	{
		COLOR_LOCKED		= 0x0001,
		UNLIT				= 0x0002,
		IGNORE_VERTEX_ALPHA	= 0x0004,
		FORCE_ALPHA			= 0x0008,	// indicates subsequent pass uses previous alpha
		ANIMATED_TEXTURE	= 0x0010,
	};

	NxMaterialPass( void );

	void	operator = ( NxMaterialPass& pass );

	void			SetTextureChecksum( int platform, unsigned long tex_checksum );
	unsigned long	GetTextureChecksum( int platform );
	unsigned long	GetTextureChecksum( int index, int platform );

	int				GetNumTextures( int platform );
	
	int				m_BlendMode;
	int				m_AddressModeU;
	int				m_AddressModeV;
	int				m_FixedAlpha;
	MappingMode		m_MappingMode;		// Explicit or procedural (eg. environment-mapping)	
	FilteringMode	m_MinFilteringMode;	// Point/Bi-linear
	FilteringMode	m_MagFilteringMode;	// Point/Bi-linear/Tri-linear
	bool			m_UVWibbleEnabled;		
	float			m_UVel;
	float			m_VVel;	
	float			m_UAmplitude;
	float			m_VAmplitude;
	float			m_UPhase;
	float			m_VPhase;
	float			m_UFrequency;
	float			m_VFrequency;
	float			m_EnvTileU;
	float			m_EnvTileV;
	float			m_Color[3];
	float			m_Ambient[3];
	float			m_Diffuse[3];
	float			m_Specular[3];
	float			m_MipMapK;	
	bool            m_HasColor;			// True if the m_Color member is valid to use   aml
	unsigned long   m_Flags;			// aml  v10
	int				m_OrigPass;			// Original pass number, not taking into account the collapse of unused passes
	NxAnimatedTexture m_AnimatedTexture;

private:
	unsigned long	m_tex_checksum[Utils::vNUM_PLATFORMS];
};

class WibbleKeyframe
{
public:
	float	m_Color[4];
	int		m_Time;
};

class VCWibbleSequence : public Lst::Node< VCWibbleSequence >
{
public:
	VCWibbleSequence( void );

	int				m_NumFrames;
	int				m_Index;
	int				m_Offset;
	int				m_Phase;
	WibbleKeyframe	*m_WibbleFrames;
};

// !!! UPDATE CopyMaterial if adding new members !!!
class NxMaterial : public Lst::Node< NxMaterial >
{
public:
	
	enum
	{
		mUV_WIBBLE		= 0x0001,
		mVC_WIBBLE		= 0x0002,
		mTEXTURED		= 0x0004,
		mENVIRONMENT	= 0x0008,
		mDECAL			= 0x0010,
		mSMOOTH			= 0x0020,
		mTRANSPARENT	= 0x0040,
		mONE_SIDED		= 0x0080,
		mINVISIBLE		= 0x0100,
		mTWO_SIDED      = 0x0200,
		mSPECULAR       = 0x0400,
		mANIMATED_TEX	= 0x0800,	// This is distinct from NxMaterialPass::ANIMATED_TEXTURE
		mNEWFORMATCRC   = 0x1000,
		mFORCE_ALPHA	= 0x2000,
	};

	enum
	{
		mGROUP_PASS_1			= 0x0001,
		mGROUP_PASS_2			= 0x0002,
		mGROUP_PASS_3			= 0x0004,
		mGROUP_PASS_4			= 0x0008,
		mGROUP_TRANSPARENT		= 0x0010

	};

	enum
	{
		vCUTOFF_NOUPDATE,
		vCUTOFF_UPDATEFRAMEBUFFER,
	};


					NxMaterial( void );

	//bool			operator == ( NxMaterial& material );
	
	unsigned long	GetCRC( void );
	int				GetWibbleSequence( int base_seq, int offset );

	unsigned long	m_Checksum;
	unsigned long	m_materialName;
	int				m_GroupFlags;	
	bool			m_Invisible;
	int				m_Terrain;
	int				m_AlphaCutoff;
	int				m_NumPasses;
	bool			m_ShouldExpand;
	float			m_DrawOrder;
	int				m_BasePass;
	bool			m_Sorted;
	int				m_GroupId;
	int             m_CutoffFunc;
	bool			m_water;			// new 0x0E
	bool            m_grassify;			// new v8
	float           m_grassHeight;		// new v9
	int             m_grassLayers;		// new v9
	int				m_Pass;
	bool            m_TwoSided;
	bool			m_OneSided;			// PS2-Specific
	float           m_SpecularPower;
	float           m_SpecularColor[3];	// Specular color in RGB percents
	bool			m_Used;
	Lst::Head< VCWibbleSequence > m_WibbleSequences;

	NxMaterialPass	m_Passes[vMAX_MATERIAL_PASSES];
};

class	NxVertex
{
public:
	NxVertex( void );

	enum
	{
			vMAX_WEIGHTS_PER_VERTEX	=	6,
	};

	void	SortVertexWeights( void );
	void	NormalizeVertexWeights( int numWeights );

	bool operator==( NxVertex& vertex );
	bool	PosAndColorSame( const NxVertex& vertex ) const;

	float	m_Pos[3];
	float	m_Normal[3];
	float	m_TexCoord[vMAX_MATERIAL_PASSES][2];
	float	m_Color[4];
	int		m_WibbleIndex;
	int		m_WibbleOffset;
	int		m_Pass;	
	int		m_NumWeights;
	int		m_WeightedIndex[vMAX_WEIGHTS_PER_VERTEX];
	float	m_Weight[vMAX_WEIGHTS_PER_VERTEX];
	bool	m_Invisible;
	bool	m_NonCollidable;

	int		m_MeshScalingWeightedIndex[vMAX_WEIGHTS_PER_VERTEX];
	float	m_MeshScalingWeight[vMAX_WEIGHTS_PER_VERTEX];
};

struct UVCoord
{
	float u,v;
};

class	NxFace
{
public:
	enum
	{
		mFD_SKATABLE			  = 0x00000001,
		mFD_NOT_SKATABLE		  = 0x00000002,
		mFD_WALL_RIDABLE		  = 0x00000004,
		mFD_VERT				  = 0x00000008,
		mFD_NON_COLLIDABLE		  = 0x00000010,
		mFD_DECAL				  = 0x00000020,
		mFD_TRIGGER			      = 0x00000040,
		mFD_NON_CAMERA_COLLIDABLE = 0x00000080,
		//mFD_CAMERA_COLLIDABLE	= 0x00000080,
		mFD_NO_SKATER_SHADOW	  = 0x00000100,
		mFD_SKATER_SHADOW		  = 0x00000200,
		mFD_NO_SKATER_SHADOW_WALL = 0x00000400,
		mFD_UNDER_OK			  = 0x00000800,
		mFD_INVISIBLE			  = 0x00001000,
		mFD_CASFACEFLAGSEXIST     = 0x00002000,
		mFD_PASS_1_DISABLED       = 0x00004000,	// Set only if pass 1 is turned off (so it defaults on for everything)
		mFD_PASS_2_ENABLED        = 0x00008000,
		mFD_PASS_3_ENABLED        = 0x00010000,
		mFD_PASS_4_ENABLED        = 0x00020000,
		mFD_RENDER_SEPARATE		  = 0x00040000,
		mFD_LIGHTMAPPED           = 0x00080000,
		mFD_NON_WALL_RIDABLE	  = 0x00100000,
		//mFD_NON_CAMERA_COLLIDABLE = 0x00200000,
		mFD_EXPORT_COLLISION	  = 0x00400000,
	};

	NxFace( void );

	int			m_Vertex[3];	// Index into vert list
	float		m_Normal[3];
	unsigned long	m_MatChecksum;	// Checksum of material	
	FlagType	m_FaceFlags;	
	int			m_Index;
	int			m_Pass;
	int			m_PassFlags;
	CASFlagType m_CASFaceFlags;
	bool		m_Invisible;
	bool		m_NonCollidable;
	unsigned long m_LightmapChecksum;	// Obj v2: Checksum of lightmap                 [aml 9-26-02]
	UVCoord       m_LightmapUV[3];		// Obj v2: Texture UV coordinates for lightmap  [aml 9-26-02]
};

class	NxFaceInfo
{
public:
	unsigned short	m_flags;
	unsigned short	m_terrain_type;
};

class	NxFaceInfoPalette
{
public:
	// Constants
	enum
	{
		MAX_PALETTE_ENTRIES = 256,
	};

					NxFaceInfoPalette();

	void			ClearPalette();

	int				AddFaceInfo(unsigned short flags, unsigned short terrain_type);
	int				AddFaceInfo(const NxFaceInfo & info);

	NxFaceInfo		m_face_info[MAX_PALETTE_ENTRIES];
	int				m_num_entries;
};

class	NxBoundingBox
{
public:
	void Set(const float min[3], const float max[3]);
    void AddPoint(const float point[3]);

	float	m_Min[3];
	float	m_Max[3];
};

class	NxSphere
{
public:
	float	m_Center[3];
	float	m_Radius;
};

class NxStripVert
{
public:
	bool	m_StripVert;	// if true, this is the third vert of a tri in a strip
							// if false, this is one of the first two verts of the start of a strip
	int		m_Index;
};

class NxMesh : public Lst::Node< NxMesh >
{
public:
	enum
	{
		vMAX_FACES = 5000
	};

	NxMesh( unsigned long mat_checksum );	
	~NxMesh( void );

	void			SetWibbleFlags( void );
	
	unsigned long	m_MatChecksum;
	FlagType		m_ShadowFlags;
	int				m_NumStripVerts;
	NxStripVert*	m_VertStrip;
	int				m_Topology[vMAX_FACES][3];
	int				m_NumFaces;	
	class NxObject*	m_Object;
	int				m_Flags;

	// for create-a-skater flags
public:
	unsigned long	m_CASFaceFlags[vMAX_FACES];
	unsigned long	FindCASFaceFlags( int vertIndex0, int vertIndex1, int vertIndex2 );
};

class NxMeshGroup : public Lst::Node< NxMeshGroup >
{
public:
	NxMeshGroup( void );

	int					m_GroupNumber;
	Lst::Head< NxMesh >	m_Meshes;
};

class NxMeshList
{
public:

//	static const unsigned int MAX_NUM_MESHES	= 256;
	static const unsigned int MESH_BLOCK_SIZE	= 256;
	
			NxMeshList( void );
			~NxMeshList( void );

	void	operator = ( NxMeshList& mesh_list );
	void	Reset( void );
	void	AppendMesh( NxMesh* mesh, int lod = 0 );

	NxMesh**m_Meshes[8];					// Can support up to 8 LOD levels of 2048 meshes per object.
	int		m_NumMeshes[8];					// Number of meshes in in each LOD level.
	int		m_MaxMeshes[8];					// Maximum meshes in in each LOD level.
};

////////////////////////////////////////////////////////////////
// Axis-Aligned BSP tree node
//

// Precision for fixed point split point value
#define COLLISION_SUB_INCH_PRECISION 16.0f
#define COLLISION_RECIPROCAL_SUB_INCH_PRECISION 0.0625f

class NxCollBSPNode
{
public:
	// Constants
	enum
	{
		NUM_AXIS_BITS = 2,			// Number of bits used in fixed split_point for the axis identification
	};

						NxCollBSPNode();
	virtual				~NxCollBSPNode();

	virtual int			InstanceSize() const { return s_bsp_node_size; }

	static int			CountBSPNodes( NxCollBSPNode *p_bsp_node );		// recursively count nodes
	static int			AssignNodesToArray( NxCollBSPNode *p_bsp_node, NxCollBSPNode **p_bsp_array,
											int & cur_array_idx, int & cur_array_offset, bool root_node = true );

	char				m_split_axis;		// the axis it is split on (0 = X, 1 = Y, 2 = Z, 3 = Leaf)
	float				m_split_point;		// the point on the axis

	NxCollBSPNode *		mp_less_branch;		// branches
	NxCollBSPNode *		mp_greater_branch;
	int					m_less_branch_idx;	// index into exported node array
	int					m_greater_branch_idx;
	int					m_array_offset;		// offset of this node in the export array

private:
	static const int	s_bsp_node_size;
};

////////////////////////////////////////////////////////////////
// Axis-Aligned BSP tree leaf
//
class NxCollBSPLeaf : public NxCollBSPNode
{
public:
						NxCollBSPLeaf();
	virtual				~NxCollBSPLeaf();

	virtual int			InstanceSize() const { return s_bsp_leaf_size; }

	unsigned short		m_num_faces;
	unsigned short *	mp_face_idx_array;

private:
	static const int	s_bsp_leaf_size;
};

class	NxCASData
{
public:
	unsigned long	m_Mask;
	unsigned long	m_Data;
	unsigned long	m_Data1;
};

class NxLODLevel
{
public:
	enum
	{
		vVERSION_NUMBER =  0x0001
	};

				   NxLODLevel( void );

	float		   m_Distance;
	unsigned long  m_ObjectCRC;
};

struct NxLODFace
{
	int v[3];	// Index into vert list for each vertex in face
};

struct NxLODInfo
{
	NxLODFace* faces;
	int        numFaces;
	float      distance;		// Only valid if NxObject::mHASLODDISTS is set

	NxLODInfo()
	{
		faces    = NULL;
		numFaces = 0;
	}

	~NxLODInfo()
	{
		if (faces)
			delete [] faces;
	}

	NxLODInfo& operator=(NxLODInfo& obj)
	{
		numFaces = obj.numFaces;

		if (obj.faces)
		{
			faces = new NxLODFace[obj.numFaces];
			memcpy(faces, obj.faces, sizeof(NxLODFace) * numFaces);
		}
		else
			faces = NULL;

		return *this;
	}
};

// WARNING!  REMEMBER TO UPDATE ASSIGNMENT OPERATOR ON ADDITION OF NEW FIELDS
class	NxObject
{
public:
	enum
	{
		vMAXCASDATA = 8192	
	};

	enum
	{
		mTEXTURED			=	0x00000001,
		mCOLORED			=	0x00000002,
		mNORMALS			=	0x00000004,
		mINVISIBLE			=	0x00000008,
		mSKINNED			=	0x00000010,
		mDYNAMIC			=	0x00000020,
		mOCCLUDER			=	0x00000040,
		mHASCASREMOVEFLAGS  =   0x00000080,
		mPASS_BIT_1			=	0x00000100,
		mPASS_BIT_2			=	0x00000200,
		mNO_SHADOW			=	0x00000400,
		mVCWIBBLE			=	0x00000800,
		mRENDER_SEPARATE	=	0x00001000,
		mHASKBIAS			=	0x00002000,
		mNO_SHADOW_WALL		=	0x00004000,
		mHASLODINFO			=   0x00008000,		// True if LOD info fields are included  aml
		mSKELETALMODEL      =   0x00010000,		// True if this is a model that uses procedural skeletal animation
		mUNLIT				=	0x00020000,
		mCOLOR_LOCKED		=	0x00040000,
		mGRASS				=	0x00080000,
		mHASINTLODINFO		=   0x00100000,		// True if this object contains its LOD data internally
		mSHADOWVOLUME       =   0x00200000,		// True if this object is flagged as a shadow volume in the PE
		mHAS4WEIGHTS        =   0x00400000,		// True if skinned model has 4 weights per vert
		mBILLBOARD          =   0x00800000,
		mSS_NORMALS			=	0x01000000,		// Has normals solely for the purpose of determining which side should be rendered in a single-sided mesh
		mPASS_BIT_3			=	0x02000000,		// Extra pass bits for z-push
		mPASS_BIT_4			=	0x04000000,
		mWATER				=	0x08000000,		// is a water material
		mABSENTINNETGAMES   =   0x10000000,		// Flagged if the object has AbsentInNetGames checked
		mHASLODDISTS		=   0x20000000,		// Flagged if the object has user defined distance data per LOD level
		mHASVERSIONINFO     =   0x80000000,		// Version info wasn't saved in original,  if included load version
												// field
	};

	// LOD Flags
	enum
	{
		mMASTER = 0x0001,					// This is the main instance of the object containing the LOD level info
		mSLAVE  = 0x0002,					// This object is an LOD level for the given Master object
	};

	NxObject( void );
	~NxObject( void );

	void	OptimizeVertList( class NxScene* scene );
	bool	InitBSPTree( void );
	bool	UseFaceSmall( void ) const { return m_NumCollVerts <= 256; }
	
	static const int	sFaceLargeSize;
	static const int	sFaceSmallSize;
	static const int	sVertexLargeSize;
	static const int	sVertexSmallSize;

	unsigned long	m_Checksum;
	unsigned long	m_SkeletonChecksum;
	int				m_NumFaces;	
	NxFace*			m_Faces;
	int				m_NumVerts;
	NxVertex*		m_Verts;
	NxVertex*		m_OriginalVerts;
	NxBoundingBox	m_BoundingBox;
	NxBoundingBox	m_CollisionBoundingBox;	// Could be slightly different
	NxSphere		m_BoundingSphere;
	int				m_Flags;	
	NxMeshList		m_MeshList;
	int				m_NumUVSets;
	int             m_CASRemoveFlags;
	NxCollBSPNode *	mp_BSPRoot;
	NxVertex *		mp_CollVerts;
	int *			mp_ToCollVertIdxs;
	NxFace *		mp_CollFaces;
	int				m_NumCollVerts;
	int				m_NumCollFaces;
	unsigned int	m_CollUseFixedVerts;
	float           m_KBias;	
	int             m_ParentMatrixIndex;	// Index into matrix array for transform of this object
											// if it's a modal that uses skeletal animation

	int             m_LODFlags;				// load only with mHASLODINFO  aml

	struct LODMaster
	{
		int           m_NumLODLevels;		// load only with mHASLODINFO  aml
		NxLODLevel*   m_LODLevels;			// load only with mHASLODINFO  aml
	};

	struct LODSlave
	{
		unsigned long m_masterCRC;			// load only with mHASLODINFO  aml
		NxObject*	  mp_master_object;
	};

	union
	{
		LODMaster   m_LODMaster;			// if mMASTER LOD flag set
		LODSlave    m_LODSlave;				// if mSLAVE LOD flag set
	};
	
	// Relative info
	int             m_ParentCRC;			// v1
	int             m_NumChildren;			// v1
	unsigned long*  m_ChildCRCs;			// v1

	int             m_LODLevels;
	NxLODInfo*      m_LODinfo;

	// Billboard data
	enum BillboardType
	{
		BBT_NOT_BILLBOARD,
		BBT_SCREEN_ALIGNED,
		BBT_AXIAL_ALIGNED,
	};
	
	BillboardType   m_BillboardType;
	float           m_BillboardOrigin[3];
	float           m_PivotPos[3];
	float           m_PivotAxis[3];

public:
	// for generating create-a-skater flags
	void			GetFaceFlags( unsigned long mask, int* numFound, int* pReturnArray );
	bool			AddCASData( unsigned long mask, unsigned long data0, unsigned long data1 = 0 );
	NxCASData*		mp_CASData;
	int				m_NumCASData;

	NxObject&      operator = (NxObject& obj);

private:

	bool	flag_invisible_vertices_and_faces( class NxScene* scene );

	NxCollBSPNode *		create_bsp_tree(const NxBoundingBox & bbox, unsigned short *p_face_indexes, int num_faces, int level = 1);
	NxCollBSPLeaf *		create_bsp_leaf(unsigned short *p_face_indexes, int num_faces);
	bool				calc_split_faces(int axis, float axis_distance, unsigned short *p_face_indexes,
										 int num_faces, int & less_faces, int & greater_faces, 
										 unsigned short *p_less_face_indexes = NULL, unsigned short *p_greater_face_indexes = NULL);
};

#define	GetPassNumber(a)	((( a & ( NxObject::mPASS_BIT_1 | NxObject::mPASS_BIT_2 )) >> 8 ) | \
								(( a & ( NxObject::mPASS_BIT_3 | NxObject::mPASS_BIT_4 )) >> 23 ))
#define PassToFlags(a)		((( a & 0x03 ) << 8) | (( a & 0x0C ) << 23))

class NxModel
{
public:
	enum
	{
		MODEL_VERSION = 0x0001,
	};

	struct BoneDesc
	{
		unsigned long crc;	// The CRC name of this bone
		Mth::Matrix   mat;	// Matrix to convert local coords into coord system of parent
	};

	int nBones;			// Number of objects being exported with hierarchial information
						// this includes dummy objects

	BoneDesc*  bones;	// Contains the per bone info

	NxModel( void );
	~NxModel();
};

class	NxScene
{
public:
	NxScene( void );
	~NxScene( void );

	NxMaterial*		GetMaterial( unsigned long checksum );
	NxMaterial*		CopyMaterial( unsigned long old_checksum, unsigned long new_checksum, int pass_flags );
	int				GetNumVisibleMaterials( void );
	bool			ContainsSortedUntexturedMaterials( int platform );
	void			RemoveUnusedMaterials( void );
	NxObject*		FindObject(unsigned long checksum);

	int				m_NumMaterials;

	int				m_NumObjects;
	NxObject*		m_Objects;
	int				m_NumCollBSPTreeNodes;

	NxModel         m_Model;

	void			RemoveMaterialFromLookup(NxMaterial* pMaterial)
	{
		m_MaterialLookup.FlushItem(pMaterial->m_Checksum);
	}

	void			AddMaterialToLookup(NxMaterial* pMaterial)
	{
		if( m_MaterialLookup.GetItem( pMaterial->m_Checksum ))
		{
			printf( "\nWarning: Adding material checksum %x already exists in lookup table.\n" );
		}
		m_MaterialLookup.PutItem(pMaterial->m_Checksum,pMaterial);
	}

	Lst::Head< NxMaterial >	m_Materials;	
	Lst::HashTable< NxMaterial > m_MaterialLookup;
};

class NxTexture
{
public:
	enum
	{
		v32_BIT,
		v24_BIT,
		v16_BIT,
		v8_BIT,
		v4_BIT,		
		v8_BIT_GRAY,
		v4_BIT_GRAY
	};

	enum
	{
		vMAX_MIP_LEVELS = 10,
		vMAX_NAME_LENGTH = 256,
		vMIN_MIP_WIDTH = 4,
		vMIN_MIP_HEIGHT = 4,
	};

	enum
	{
		vADDRESS_MODE_REPEAT,
		vADDRESS_MODE_CLAMP,
	};

	enum
	{
		mFORCE_BYTE_PER_COMPONENT		=	0x0001,
		mCHANGE_FULLY_TRANSPARENT_COLOR	=	0x0002,
		mAUTO_GENERATE_MIPMAPS			=	0x0004,
		mTRANSPARENT					=	0x0008,
		mOPAQUE							=	0x0010,
		mCOMPRESS_NGC					=	0x0020,
		mCOMPRESS_XBOX					=	0x0040,
		mINVISIBLE						=	0x0080,		// Not meant to be rendered. 		
	};	

	enum
	{
		vGROUP_PASS_1,
		vGROUP_PASS_2,
		vGROUP_PASS_3,
		vGROUP_PASS_4,
		vGROUP_TRANSPARENT_1,
		vGROUP_TRANSPARENT_2,
		vGROUP_TRANSPARENT_3,
		vGROUP_TRANSPARENT_4,
		vNUM_GROUP_TYPES
	};

	NxTexture( void );
	~NxTexture( void );

	bool	IsPaletted( void );
	int		GetTotalDataSize( void );

	// Useful (though somewhat specific) conversion functions.
	bool	ConvertTo32BitPixelFormat( void );
	bool	Convert32BitRGBAPixelFormatTo32BitBGRAPixelFormat( void );

	bool	Convert4BitPixelFormatTo8BitPixelFormat( void );
	bool	Convert16BitPaletteFormatTo32BitPaletteFormat( void );
	bool	Convert24BitPaletteFormatTo32BitPaletteFormat( void );
	bool	Convert32BitRGBAPaletteFormatTo32BitBGRAPaletteFormat( void );

	int	m_PixelFormat;
	int	m_PaletteFormat;

	int	m_Width[vMAX_MIP_LEVELS];
	int	m_Height[vMAX_MIP_LEVELS];

	int m_Bpp;
	int m_PaletteBpp;
	
	int	m_TotalPaletteDataSize;
	int	m_TotalTexelDataSize;
	int	m_TexelDataSize[vMAX_MIP_LEVELS];

	char*	m_TexelData[vMAX_MIP_LEVELS];
	char*	m_PaletteData;

	int m_NumPaletteEntries;
	
	int	m_MipLevels;

	int	m_Flags;	
	int m_PlatFlags;

	char m_Name[vMAX_NAME_LENGTH];
	
	unsigned long m_Checksum;	

	float	m_LastDrawOrder;
	int m_LastGroupIndex;
	int m_LastGroupId;
	int	m_GroupFlags;

	bool m_AlreadyExported;
};

struct CRCEntry
{
	char                      Name[NxTexture::vMAX_NAME_LENGTH];
	LinkList< unsigned long > CRCs;

	bool operator ==(CRCEntry& right)
	{
		if (strcmp(Name,right.Name)==0)
			return true;

		return false;
	}
};

class	SceneConverter
{
public:
	SceneConverter( void );
	virtual ~SceneConverter();

	virtual	bool	LoadScene( char* path );
	virtual bool	LoadTextureDictionary( char* path );
	virtual bool    LoadLightmaps( char* path );
	virtual	NxTexture*	GetTextureByChecksum( unsigned long checksum );

	virtual bool	ConvertData( void ) = 0;
	virtual bool	GenerateCollisionBSP( void );
	virtual bool	CollapseCollsionVertices( bool round_verts = false );
	virtual bool	SaveScene( char* path ) = 0;
	virtual bool	SaveTextureDictionary( char* path, char* usg_path ) = 0;	
	virtual int		GetPlatformFlags( void ) = 0;	
	virtual	void	LimitMipMaps( void );
	virtual	void	ExpandMultiPassMaterials( void );
	virtual	void	SeparateMultiPassMeshes( void );
	
	virtual	bool	HasValidUVs(NxMaterial* material, NxObject* obj, NxFace* face, int pass );
	virtual	void	Sort(float* val0,float* val1,float* val2);

	virtual void	EnableOptimization( bool enable );
	virtual void	EnableWeightMapGeneration( bool generate_weight_map );

protected:
	char			     m_scene_name[1024];
	bool			     m_sky;
	NxScene*		     m_scene;
	int				     m_num_textures;
	NxTexture*	   	     m_textures;
	NxTexture*           m_lightmaps;
	int                  m_NumLightmaps;
	bool				m_generate_optimized_level;
	bool				m_generate_weight_map;

	enum {
		vMAX_WEIGHT_MAP_VERTICES = 10000
	};
	bool				m_weight_map_loaded;
	NxVertex*			mp_weight_map_vertices;
	int					m_num_weight_map_vertices;

	LinkList< CRCEntry > usedCRCs;				// List of dupped CRCs

	int				get_source_uv_channel( int pass_flags, int src_pass );	

	bool			should_generate_optimized_level( void );	

	int				iReject;		// Number of polys rejected for bad UVs
	int				iTotal;			// Total number of polys

private:	
	bool			load_objects(IoUtils::CVirtualInputFile* file, int mesh_version );	
	bool			load_materials(IoUtils::CVirtualInputFile* file, int material_version);
	
	bool			create_new_multipass_materials( void );			
	bool			create_new_vc_wibble_sequences( void );	

protected:
	bool			temp_write_weight_map_file( char* path );
	bool			load_weight_map_file( char* path );

protected:
	// for generating create-a-skater flags
	NxObject*		get_cas_object();

	void            AddUSGTexture(NxTexture* texture);
	void            WriteUSGDuplicates(IoUtils::CVirtualOutputFile* pUsageFile);
};

extern bool	gTextureOverride;
extern int	gTextureOverrideMapping[Utils::vNUM_PLATFORMS];
#endif	//	__SCENECONV_H__