// NGCDLL.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "windows.h"
#include "NGCDLL.h"
#include "GC\GameCubeConv.h"

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

NGCDLL_API int NGCDLL_export( char * filename, char * dict_name, char * col_name, char * dst_scene, int platform, char * usg_name, char * cas_name, char * weightmap_name, bool optimized )
{
	if( optimized ) return 0;

	char save_name[256];

			ResetGameCubeConverter();	// reset for next use
			IGameCubeConverter* gc_conv;
			gc_conv = GetGameCubeConverter();
			gc_conv->LoadScene( filename );
			bool has_tex_dict = gc_conv->LoadTextureDictionary( dict_name );
			gc_conv->CollapseCollsionVertices();
			gc_conv->GenerateCollisionBSP();
			
			if (!gc_conv->SaveCollisionData( col_name ))
				return -1;

			if (!gc_conv->ConvertData())
				return -2;

			if (!gc_conv->SaveScene( dst_scene ))
				return -3;

			// Only save the texture dictionary if it has one...
			if( has_tex_dict )
			{
				strcpy( save_name, dict_name );
				strcat( save_name, "." );
				strcat( save_name, Utils::GetPlatformExt(platform) );
			
				if (!gc_conv->SaveTextureDictionary( save_name, usg_name ))
					return -4;
			}

			gc_conv->SaveCASFlags( cas_name );
			gc_conv->SaveWeightMap( weightmap_name );
			ResetGameCubeConverter();	// reset for next use
	return 0;
}

// This is the constructor of a class that has been exported.
// see NGCDLL.h for the class definition
CNGCDLL::CNGCDLL()
{ 
	return; 
}

