#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>

#include "Image.h"
#include "Genlib/Utility.h"
#include "Misc/Util.h"

#define vMAJOR_REV 2
#define vMINOR_REV 0

void	run_utility( char* png_path, int platform, bool force8 )
{
	NxTexture convert_texture;
		
	if (!FileExists(png_path))
	{
		fprintf(stderr, "Cannot find file '%s'\n", png_path);
		exit(1);
	}
		
	char texture_path[_MAX_PATH];
	char png_drive[_MAX_DRIVE];
	char png_dir[_MAX_DIR];
	char png_file[_MAX_FNAME];

	_splitpath(png_path, png_drive, png_dir, png_file, NULL);
	_makepath(texture_path, png_drive, png_dir, png_file, "img");

	// Add platform specific extension
	strcat( texture_path, "." );
	strcat( texture_path, Utils::GetPlatformExt(platform) );

	// GJ:  As a speed optimization, we assume that
	// time check was done by the ConvertAssets utility
	// and that the utility would not have been called 
	// unless we actually wanted to update the file...
//	if (FileIsNewer(texture_path, png_path) || FileIsNewer(texture_path, executable_path))
	{
		printf("Converting .png file '%s'\n", png_path);

		if( !convert_texture.LoadImage2(png_path) )
		{
			printf("\nError loading image: %s\n", png_path);
			exit( 1 );
		}

		//printf("Writing out texture file '%s'\n", texture_path);

		MakeFileRW(texture_path);

		convert_texture.SaveTexture(texture_path, platform, force8);
	}
}

int main(int argc, char **argv)
{
	char* filename = NULL;
	char* batchname = NULL;
	bool batch_mode = false;

	bool force8 = false;
	int	platform = Utils::vPLATFORM_NONE;
	
	if( argc > 2 )
	{
		int i;

		for( i = 1; i < argc; i++ )
		{
			if( argv[i][0] == '-' )
			{
				switch( argv[i][1] )
				{
					case 'P':
					case 'p':
						switch( argv[i][2] )
						{
							case 'P':
							case 'p':
								platform = Utils::vPLATFORM_PS2;
								break;
							case 'G':
							case 'g':
								platform = Utils::vPLATFORM_NGC;
								break;
							case 'X':
							case 'x':
								platform = Utils::vPLATFORM_XBOX;
								break;
						}
						break;
					case 'B':
					case 'b':
						batch_mode = true;
						batchname = &argv[i][2];
						break;
					case 'F':
					case 'f':
						filename = &argv[i][2];
						break;
					case '8':
						force8 = true;
						break;

						/*
					case 'C':	// check timestamp
					case 'c':
						// by default, we no longer do the
						// timestamp comparison.  the utilities
						// now assume that if it is called,
						// it is supposed to re-convert the files
						// unconditionally.  it's up to the
						// convertassets program to do the 
						// timestamp comparisons
						s_force_overwrite = false;
						break;
						*/
				}
			}
		}	
	}

	if( ( platform == Utils::vPLATFORM_NONE ) ||
		( filename == NULL && !batch_mode ))
	{	

#ifdef _DEBUG
		printf( "\nPngConv v%%d.%d (Debug) Built %s %s\n", vMAJOR_REV, vMINOR_REV ,__DATE__, __TIME__ );
#else
		printf( "\nPngConv v%%d.%d (Release) Built %s %s\n", vMAJOR_REV, vMINOR_REV ,__DATE__, __TIME__ );
#endif

		printf( "Neversoft Entertainment\n" );
		printf( "\nUsage: PngConv -f<filename> -p[p | g | x]\n" );
		printf( "Where p = PS2, g = GameCube, x = Xbox\n" );	
		printf( "Ex: PngConv -fc:/skate4/data/images/loadscrn.png -pp\n" );
		exit(1);
	}

	if ( batch_mode )
	{
		char* pBatchFileName = batchname;

		fstream batchStream( pBatchFileName, ios::in | ios::nocreate );
		if ( !batchStream.is_open() )
		{
			printf( "Error!  Could not open %s\n", pBatchFileName );
			batchStream.close();
			exit(1);
		}

		printf( "Running batch mode on %s\n", batchname );

		while ( !batchStream.eof() )
		{
			char lineBuf[256];
			batchStream.getline( &lineBuf[0], 256 );
			if ( batchStream.eof() )
			{
				break;
			}

			run_utility( lineBuf, platform, force8 );
		}

		batchStream.close();
	}
	else
	{
		run_utility( filename, platform, force8 );
	}

	return 0;
}
