#ifndef __IMAGE_IMAGE_H__
#define __IMAGE_IMAGE_H__

//#include <fstream.h>

class	NxTexture
{
public:
	enum
	{
		v32_BIT,
		v24_BIT,
		v16_BIT,
		v8_BIT,
		v4_BIT,		
		v8_BIT_GRAY,
		v4_BIT_GRAY,
		v2_BIT,
		v1_BIT,
		v2_BIT_GRAY,
		v1_BIT_GRAY,
	};

	enum
	{
		vMAX_MIP_LEVELS = 10
	};

	enum
	{
		mFORCE_BYTE_PER_COMPONENT		=	0x0001,
		mCHANGE_FULLY_TRANSPARENT_COLOR	=	0x0002,
		mAUTO_GENERATE_MIPMAPS			=	0x0004,
		mTRANSPARENT					=	0x0008,
	};	

	NxTexture( void );
	~NxTexture( void );

	bool	operator==( NxTexture& texture );

	int GetBpp( void );
	int GetPaletteBpp( void );

	int	GetPixelFormat( void );
	int	GetPaletteFormat( void );

	char* GetTexelData( int mip_level );
	char* GetPaletteData( void );

	int	GetTexelDataSize( int mip_level );
	int GetPaletteDataSize( void );
	int	GetTotalDataSize( void );

	int	GetWidth( int mip_level );
	int GetHeight( int mip_level );

	void SetWidth( int mip_level, int width );
	void SetHeight( int mip_level, int height );

	int GetNumPaletteEntries( void );

	bool IsPaletted( void );

	char*	GetName( void );
	char*	GetMipPath( int mip_level );

	// "LoadImage" is a Windows macro
	// so we need to resolve the name conflict by adding the "2"
	bool	LoadImage2( char* path );
	bool	SaveTexture( char* path, int platform, bool force8 );

	bool	Convert4BitPixelFormatTo8BitPixelFormat( void );
	bool	Convert16BitPaletteFormatTo32BitPaletteFormat( void );
	bool	Convert24BitPaletteFormatTo32BitPaletteFormat( void );
	bool	Convert32BitRGBAPaletteFormatTo32BitBGRAPaletteFormat( void );
	bool	Convert32BitRGBAPixelFormatTo32BitBGRAPixelFormat( void );
	bool	ConvertTo32BitPixelFormat( void );
	
	bool	SwizzleTextureForXbox( void );
	bool	SaveTextureForNGPS( char* path );
	bool	writeNGC( fstream * p_file, unsigned int * p_image, int width, int height );
	bool	SaveTextureForNGC( char* path, bool force8 );
	bool	SaveTextureForXbox( char* path );

	bool	ShouldAutoGenerateMipMaps( void );
	bool	ShouldCompressComponents( void );
	bool	ShouldChangeTransparentColor( void );	
	
	//void	SetTransparentColor( Color trans_color );
	//Color	GetTransparentColor( void );
	void	SetFlags( int flags );
	int		GetFlags( void );

	void	SetAutoGenerateMipMaps( bool auto_generate );
	
	void	SetNumMipLevels( int num_mip_levels );
	int		GetNumMipLevels( void );

	void	GenerateChecksum( void );
	unsigned long	GetChecksum( void );

	void	SetValidity( bool valid );
	bool	IsValid( void );

private:

	bool	load_png( char* path, int mip_level, bool pad_texture = true );

	int	m_pixel_format;
	int	m_palette_format;

	int	m_orig_width[vMAX_MIP_LEVELS];
	int	m_orig_height[vMAX_MIP_LEVELS];

	int	m_width[vMAX_MIP_LEVELS];
	int	m_height[vMAX_MIP_LEVELS];

	int m_bpp;
	int m_palette_bpp;

	char*	m_texel_data[vMAX_MIP_LEVELS];
	char*	m_palette_data;

	int m_num_palette_entries;
	
	int		m_mip_levels;

	int		m_flags;	

	char	m_name[256];

	unsigned long m_checksum;

	bool	m_valid;
};

#endif	// __IMAGE_IMAGE_H__