#========================================================================================
#
# MakeFile - Make rules for Adobe Photoshop 3.0 Developer Toolkit Basic Examples
#
# Written by Dave Wise
#
# Copyright  1994, Adobe Systems Incorporated, all rights reserved worldwide.
#
# Version	1.00	10/20/94	Original version
#
#========================================================================================

#========================================================================================
# Basic symbols
#========================================================================================
c				=	:c:
h				=	:h:
r				=	:r:
o				=	:o:

ErrorOut		=	"{Worksheet}"
Dumpfile		=	:h:Photoshop.d
Out				=	::Plug-ins:

#========================================================================================
# Utility library stuff
#========================================================================================
# 68K
Libs			=	"{Libraries}"Interface.o 
RFiles			=	"{Rincludes}"Types.r
Utils			=	{o}DialogUtilities.c.o {o}PIUtilities.c.o 

# PPC
alllibs			=	{PPCLibraries}StdCRuntime.o 
					{PPCLibraries}StdCLib.xcoff 
					{PPCLibraries}InterfaceLib.xcoff 
					{PPCLibraries}PPCCRuntime.o 
					{PPCLibraries}MathLib.xcoff
librenames		=	-l MathLib.xcoff=MathLib 
					-l StdCLib.xcoff=StdCLib 
					-l InterfaceLib.xcoff=InterfaceLib
PPCUtilsList	=	{o}DialogUtilities.c.po {o}PIUtilities.c.po 
PPCUtils		=	{PPCUtilsList} {alllibs}

#========================================================================================
# Options
#========================================================================================
mbgOpts			=	full
symOpts			=	off

linkOpts		=	-w -sym {symOpts}
cOpts			=	-mbg {mbgOpts} -sym {symOpts} -i {h}
ppccOpts		=	-align mac68K -appleext on -sym {symOpts} -i {h}
aOpts			=	-sym {symOpts}

#========================================================================================
# Basic object-to-source dependency
#========================================================================================
{o}					{c} {r}

#========================================================================================
# Default rules
#========================================================================================
.c.o				.c
	Echo "# `Date -t` ----- Compiling {Default} (68K)"  {ErrorOut}
	C {cOpts} -r -b2 -bigseg -mc68020 
		{DepDir}{Default}.c -o {Targ}  {ErrorOut}

.c.po				.c
	Echo "# `Date -t` ----- Compiling {Default} (PPC)"  {ErrorOut}
	PPCC {ppccOpts} {DepDir}{Default}.c -o {Targ}  {ErrorOut}

.a.o				.a
	Echo "# `Date -t` ----- Assembling {Default} (68K)"  {ErrorOut}
	Asm {aOpts} -i {h} -i {a} -case obj 
		{DepDir}{Default}.a -o {Targ}  {ErrorOut}
	
#========================================================================================
# Overall build
#========================================================================================
BuildMe				"{Out}Dissolve" 
					"{Out}DummyExport" 
					"{Out}DummyScan" 
					"{Out}HistoryExport" 
					"{Out}Sample Format" 
					"{Out}Paths to Illustrator" 

#========================================================================================
# Dump file
#========================================================================================
PhotoshopHeaders	=	{h}PIGeneral.h {h}MacStd.h {h}PITypes.h {h}PIAbout.h 
						{h}PIExport.h {h}DialogUtilities.h {h}PIUtilities.h 
						{h}ExportUtilities.h {h}AcquireUtilities.h


{Dumpfile}							{PhotoshopHeaders}
	Echo "# `Date -t` ----- Building {Dumpfile} (68K)"  {ErrorOut}
	C {cOpts} -r -b2 -bigseg -mc68020 -d MAKEDUMP Photoshop.h  {ErrorOut}
	Delete Photoshop.h.o  {ErrorOut}

{o}DialogUtilities.c.o  {Dumpfile}
{o}DialogUtilities.c.po  {PhotoshopHeaders}

{o}PIUtilities.c.o  {Dumpfile}
{o}PIUtilities.c.po  {PhotoshopHeaders}

{o}AcquireUtilities.c.o  {Dumpfile}
{o}AcquireUtilities.c.po  {PhotoshopHeaders}

{o}ExportUtilities.c.o  {Dumpfile}
{o}ExportUtilities.c.po  {PhotoshopHeaders}


#========================================================================================
# Dissolve 
#========================================================================================
"{o}Dissolve.c.o"			{Dumpfile}
"{o}Dissolve.c.po"			{PhotoshopHeaders}

"{Out}Dissolve"			{o}Dissolve.c.o {Utils}
	Echo "# `Date -t` ----- Linking 'Dissolve' (68K)"  {ErrorOut}
	Link -sg 'Dissolve...' -rt 8BFM=16000 -t 8BFM -c 8BIM -m ENTRYPOINT -o {Targ} {LinkOpts} 
		{o}Dissolve.c.o  {Utils} {Libs}  {ErrorOut}
	Delete -i {Targ}.SYM  {ErrorOut}
	Echo "Delete 'ICNc';" | Rez -a -o {Targ}  {ErrorOut}

"{o}Dissolve.xcoff"		"{o}Dissolve.c.po" {PPCUtilsList}
	Echo "# `Date -t` ----- Linking 'Dissolve' (PPC)"  {ErrorOut}
	PPCLink -mf -main ENTRYPOINT 
		"{o}Dissolve.c.po" {PPCUtils} -o {Targ}

"{Out}Dissolve"			"{o}Dissolve.xcoff"
	Echo "# `Date -t` ----- Making 'Dissolve' PEF (PPC)"  {ErrorOut}
	MakePEF -b {librenames} "{o}Dissolve.xcoff" -o {Targ}

"{Out}Dissolve"			"{r}Dissolve.r"
	Echo "# `Date -t` ----- Rezzing 'Dissolve'"  {ErrorOut}
	Rez -a -rd {RFiles} "{r}Dissolve.r" -o {Targ}  {ErrorOut}


#========================================================================================
# DummyExport 
#========================================================================================
"{o}DummyExport.c.o"			{Dumpfile}
"{o}DummyExport.c.po"			{PhotoshopHeaders}

"{Out}DummyExport"			{o}DummyExport.c.o {o}ExportUtilities.c.o {Utils}
	Echo "# `Date -t` ----- Linking 'DummyExport' (68K)"  {ErrorOut}
	Link -sg 'DummyExport...' -rt 8BEM=17000 -t 8BEM -c 8BIM -m ENTRYPOINT -o {Targ} {LinkOpts} 
		{o}DummyExport.c.o  {o}ExportUtilities.c.o {Utils} {Libs}  {ErrorOut}
	Delete -i {Targ}.SYM  {ErrorOut}
	Echo "Delete 'ICNc';" | Rez -a -o {Targ}  {ErrorOut}

"{o}DummyExport.xcoff"		"{o}DummyExport.c.po" "{o}ExportUtilities.c.po" {PPCUtilsList}
	Echo "# `Date -t` ----- Linking 'DummyExport' (PPC)"  {ErrorOut}
	PPCLink -mf -main ENTRYPOINT 
		"{o}DummyExport.c.po" "{o}ExportUtilities.c.po" {PPCUtils} -o {Targ}

"{Out}DummyExport"			"{o}DummyExport.xcoff"
	Echo "# `Date -t` ----- Making 'DummyExport' PEF (PPC)"  {ErrorOut}
	MakePEF -b {librenames} "{o}DummyExport.xcoff" -o {Targ}

"{Out}DummyExport"			"{r}DummyExport.r"
	Echo "# `Date -t` ----- Rezzing 'DummyExport'"  {ErrorOut}
	Rez -a -rd {RFiles} "{r}DummyExport.r" -o {Targ}  {ErrorOut}

#========================================================================================
# DummyScan 
#========================================================================================
"{o}DummyScan.c.o"			{Dumpfile}
"{o}DummyScan.c.po"			{PhotoshopHeaders}

"{Out}DummyScan"			{o}DummyScan.c.o {o}AcquireUtilities.c.o {Utils}
	Echo "# `Date -t` ----- Linking 'DummyScan' (68K)"  {ErrorOut}
	Link -sg 'DummyScan...' -rt 8BAM=16000 -t 8BAM -c 8BIM -m ENTRYPOINT -o {Targ} {LinkOpts} 
		{o}DummyScan.c.o  {o}AcquireUtilities.c.o {Utils} {Libs}  {ErrorOut}
	Delete -i {Targ}.SYM  {ErrorOut}
	Echo "Delete 'ICNc';" | Rez -a -o {Targ}  {ErrorOut}

"{o}DummyScan.xcoff"		"{o}DummyScan.c.po" "{o}AcquireUtilities.c.po" {PPCUtilsList}
	Echo "# `Date -t` ----- Linking 'DummyScan' (PPC)"  {ErrorOut}
	PPCLink -mf -main ENTRYPOINT 
		"{o}DummyScan.c.po" "{o}AcquireUtilities.c.po" {PPCUtils} -o {Targ}

"{Out}DummyScan"			"{o}DummyScan.xcoff"
	Echo "# `Date -t` ----- Making 'DummyScan' PEF (PPC)"  {ErrorOut}
	MakePEF -b {librenames} "{o}DummyScan.xcoff" -o {Targ}

"{Out}DummyScan"			"{r}DummyScan.r"
	Echo "# `Date -t` ----- Rezzing 'DummyScan'"  {ErrorOut}
	Rez -a -rd {RFiles} "{r}DummyScan.r" -o {Targ}  {ErrorOut}

#========================================================================================
# HistoryExport 
#========================================================================================
"{o}HistoryExport.c.o"			{Dumpfile}
"{o}HistoryExport.c.po"			{PhotoshopHeaders}

"{Out}HistoryExport"			{o}HistoryExport.c.o {Utils}
	Echo "# `Date -t` ----- Linking 'HistoryExport' (68K)"  {ErrorOut}
	Link -sg 'HistoryExport...' -rt 8BEM=17000 -t 8BEM -c 8BIM -m ENTRYPOINT -o {Targ} {LinkOpts} 
		{o}HistoryExport.c.o  {Utils} {Libs}  {ErrorOut}
	Delete -i {Targ}.SYM  {ErrorOut}
	Echo "Delete 'ICNc';" | Rez -a -o {Targ}  {ErrorOut}

"{o}HistoryExport.xcoff"		"{o}HistoryExport.c.po" {PPCUtilsList}
	Echo "# `Date -t` ----- Linking 'HistoryExport' (PPC)"  {ErrorOut}
	PPCLink -mf -main ENTRYPOINT 
		"{o}HistoryExport.c.po" {PPCUtils} -o {Targ}

"{Out}HistoryExport"			"{o}HistoryExport.xcoff"
	Echo "# `Date -t` ----- Making 'HistoryExport' PEF (PPC)"  {ErrorOut}
	MakePEF -b {librenames} "{o}HistoryExport.xcoff" -o {Targ}

"{Out}HistoryExport"			"{r}HistoryExport.r"
	Echo "# `Date -t` ----- Rezzing 'HistoryExport'"  {ErrorOut}
	Rez -a -rd {RFiles} "{r}HistoryExport.r" -o {Targ}  {ErrorOut}

#========================================================================================
# SampleFormat 
#========================================================================================
"{o}SampleFormat.c.o"			{Dumpfile}
"{o}SampleFormat.c.po"			{PhotoshopHeaders}

"{Out}Sample Format"			{o}SampleFormat.c.o {Utils}
	Echo "# `Date -t` ----- Linking 'Sample Format' (68K)"  {ErrorOut}
	Link -sg 'SampleFormat...' -rt 8BIF=16000 -t 8BIF -c 8BIM -m ENTRYPOINT -o {Targ} {LinkOpts} 
		{o}SampleFormat.c.o  {Utils} {Libs}  {ErrorOut}
	Delete -i {Targ}.SYM  {ErrorOut}
	Echo "Delete 'ICNc';" | Rez -a -o {Targ}  {ErrorOut}

"{o}SampleFormat.xcoff"		"{o}SampleFormat.c.po" {PPCUtilsList}
	Echo "# `Date -t` ----- Linking 'Sample Format' (PPC)"  {ErrorOut}
	PPCLink -mf -main ENTRYPOINT 
		"{o}SampleFormat.c.po" {PPCUtils} -o {Targ}

"{Out}Sample Format"			"{o}SampleFormat.xcoff"
	Echo "# `Date -t` ----- Making 'Sample Format' PEF (PPC)"  {ErrorOut}
	MakePEF -b {librenames} "{o}SampleFormat.xcoff" -o {Targ}

"{Out}Sample Format"			"{r}SampleFormat.r"
	Echo "# `Date -t` ----- Rezzing 'Sample Format'"  {ErrorOut}
	Rez -a -rd {RFiles} "{r}SampleFormat.r" -o {Targ}  {ErrorOut}

#========================================================================================
# Paths to Illustrator 
#========================================================================================
"{o}IllustratorExport.c.o"			{Dumpfile}
"{o}IllustratorExport.c.po"			{PhotoshopHeaders}

"{Out}Paths to Illustrator"			{o}IllustratorExport.c.o {Utils}
	Echo "# `Date -t` ----- Linking 'IllustratorExport' (68K)"  {ErrorOut}
	Link -sg 'IllustratorExport...' -rt 8BEM=17000 -t 8BEM -c 8BIM -m ENTRYPOINT -o {Targ} {LinkOpts} 
		{o}IllustratorExport.c.o  {Utils}  {Libs} "{Libraries}"Runtime.o {CLibraries}Math.o  {ErrorOut}
	Delete -i {Targ}.SYM  {ErrorOut}
	Echo "Delete 'ICNc';" | Rez -a -o {Targ}  {ErrorOut}

"{o}IllustratorExport.xcoff"		"{o}IllustratorExport.c.po" {PPCUtilsList}
	Echo "# `Date -t` ----- Linking 'IllustratorExport' (PPC)"  {ErrorOut}
	PPCLink -mf -main ENTRYPOINT 
		"{o}IllustratorExport.c.po" {PPCUtils} -o {Targ}

"{Out}Paths to Illustrator"			"{o}IllustratorExport.xcoff"
	Echo "# `Date -t` ----- Making 'IllustratorExport' PEF (PPC)"  {ErrorOut}
	MakePEF -b {librenames} "{o}IllustratorExport.xcoff" -o {Targ}

"{Out}Paths to Illustrator"			"{r}IllustratorExport.r"
	Echo "# `Date -t` ----- Rezzing 'IllustratorExport'"  {ErrorOut}
	Rez -a -rd {RFiles} "{r}IllustratorExport.r" -o {Targ}  {ErrorOut}
