// ADOBE SYSTEMS INCORPORATED
// Copyright  1993 - 2002 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this 
// file in accordance with the terms of the Adobe license agreement
// accompanying it.  If you have received this file from a source
// other than Adobe, then your use, modification, or distribution
// of it requires the prior written permission of Adobe.
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUSuites.cpp
//
//	Description:
//		Utility routines to acquire and release suites for your plug in
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#include "PIUSuites.h"



//-------------------------------------------------------------------------------
//
//	PIUSuitesAcquire
//
// Acquire all the suites in the given list
//
//-------------------------------------------------------------------------------
SPErr PIUSuitesAcquire(_AcquireList *suitesToAcquire, int16 numSuites)
	{	
	int16	i;
	SPErr	err = noErr;
	
	for (i = 0; i < numSuites; i++)
		{
		*suitesToAcquire[i].suitePtr = NULL;
		}
	
	if (sSPBasic != NULL)
		{
		for (i = 0; i < numSuites && err == noErr; i++)
			{
			err = sSPBasic->AcquireSuite(suitesToAcquire[i].name, 
										 suitesToAcquire[i].version,
										 (const void **)suitesToAcquire[i].suitePtr);
			if (err)
				err = errPlugInHostInsufficient;
			}
		}
	else
		{
		err = errPlugInHostInsufficient;
		}

	return err;
}



//-------------------------------------------------------------------------------
//
//	PIUSuitesAcquire
//
// Release all the suites in the given list
//
//-------------------------------------------------------------------------------
void PIUSuitesRelease(_AcquireList *suitesToRelease, int16 numSuites)
{
	if (sSPBasic == NULL)
		return;

	for (int16 i = 0; i < numSuites; i++)
	{
		if (*suitesToRelease[i].suitePtr != NULL)
		{
			sSPBasic->ReleaseSuite(suitesToRelease[i].name, 
								   suitesToRelease[i].version);
			*suitesToRelease[i].suitePtr = NULL;
		}
	}
}
// end PIUSuites.cpp