// ADOBE SYSTEMS INCORPORATED
// Copyright  1993 - 2002 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this 
// file in accordance with the terms of the Adobe license agreement
// accompanying it.  If you have received this file from a source
// other than Adobe, then your use, modification, or distribution
// of it requires the prior written permission of Adobe.
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUFile.cpp
//
//	Description:
//		File utilities for alias values acquired from the automation system.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#include "PIUFile.h"

#ifdef __PIMac__
static void pstrcat(StringPtr dst, StringPtr src);
static void pstrinsert(StringPtr dst, StringPtr src);
static void ptocstr(StringPtr src);
#endif

void AliasToFullPath(Handle aliasValue, char* fullPath)
{
	if (fullPath != NULL)
	{
		*fullPath = 0;
#ifdef __PIMac__
		OSErr err;
		Boolean wasChanged = false;
		FSSpec fileSpec;
		CInfoPBRec pb;
		DirInfo *block = (DirInfo *)&pb;
		Str255 directoryName;

		err = ResolveAlias(nil, (AliasRecord**)aliasValue, &fileSpec, &wasChanged);
		if (err != noErr) return;

		pstrinsert((unsigned char *)fullPath, fileSpec.name);
				
		block->ioDrParID = fileSpec.parID;
		block->ioNamePtr = directoryName;
		do {
			block->ioVRefNum = fileSpec.vRefNum;
			block->ioFDirIndex = -1;
			block->ioDrDirID = block->ioDrParID;
			err = PBGetCatInfo(&pb, FALSE);
			if (err == noErr)
			{
				pstrcat(directoryName, (StringPtr)"\p:");
				pstrinsert((unsigned char *)fullPath, directoryName);
			}
		} while (block->ioDrDirID != 2 && err == noErr);
		
		ptocstr((unsigned char*)fullPath);
				
#elif defined(__PIWin__)
		int32 length = sPSHandle->GetSize(aliasValue);
			
		Boolean oldLock = FALSE;
		Ptr pointer = NULL;
			
		sPSHandle->SetLock(aliasValue, true, &pointer, &oldLock);
			
		if (pointer != NULL)
		{
			strcpy(fullPath, pointer);
			sPSHandle->SetLock(aliasValue, oldLock, &pointer, &oldLock);
		}
			
		
	#endif
		}
}

void FullPathToAlias(char* fullPath, Handle& aliasValue)
{
	aliasValue = NULL;
#if __PIMac__
	NewAliasMinimalFromFullPath(strlen(fullPath),fullPath,nil,nil,&(AliasHandle)aliasValue);
#else
	Boolean oldLock;
	Ptr address;
    aliasValue = sPSHandle->New(strlen(fullPath)+1);
    if (aliasValue != NULL)
	{
		sPSHandle->SetLock(aliasValue, true, &address, &oldLock);
        strncpy(address, fullPath, strlen(fullPath)+1);
		sPSHandle->SetLock(aliasValue, false, &address, &oldLock);
    }
#endif
}


int32 GetFullPathToDesktop(char* fullPath)
{
	int32 error = 0;
	if (fullPath == NULL) return kSPBadParameterError;
	
	#if __PIMac__
		strcpy(fullPath, (const char *)"\p:");

		short myVRef = 0;
		long myDirID = 0;

		error = FindFolder(kOnSystemDisk, 
			 					 kDesktopFolderType, 
								 kDontCreateFolder, 
								 &myVRef, 
								 &myDirID);
		if (error) return error;

		FSSpec fsSpec;
		Str255 directoryName = "";

		error = FSMakeFSSpec(myVRef, myDirID, directoryName, &fsSpec);
		if (error) return error;
		
		pstrinsert((unsigned char *)fullPath, fsSpec.name);

		CInfoPBRec pb;
		DirInfo* block = (DirInfo *)&pb;

		block->ioDrParID = fsSpec.parID;
		block->ioNamePtr = directoryName;
		
		do {
			block->ioVRefNum = fsSpec.vRefNum;
			block->ioFDirIndex = -1;
			block->ioDrDirID = block->ioDrParID;
			error = PBGetCatInfo(&pb, FALSE);
			if (error == noErr)
			{
				pstrcat(directoryName, (StringPtr)"\p:");
				pstrinsert((unsigned char *)fullPath, directoryName);
			}
		} while (block->ioDrDirID != 2 && error == noErr);

		if (error) return error;
		ptocstr((unsigned char *)fullPath);
		
	#else
		strcpy(fullPath, "C:\\");
	#endif
	
	return error;
}

// I probably should write something like this
//static void FileSpecToFullPath(FSSpec& fileSpec, char * fullPath);

#if __PIMac__
static void pstrcat(StringPtr dst, StringPtr src)
{
	BlockMove(src + 1, dst + *dst + 1, *src);
	*dst += *src;
}

static void pstrinsert(StringPtr dst, StringPtr src)
{
	BlockMove(dst + 1, dst + *src + 1, *dst);
	BlockMove(src + 1, dst + 1, *src);
	*dst += *src;
}	

static void ptocstr(StringPtr src)
{	short len, i;

	len = src[0];

	for (i = 0; i < len; i++)
	{
		src[i] = src[i+1];
	}
	src[len] = '\0';
}
	
#endif