// MonitorMouse.cpp
// KSH 19 Nov 2002
// This creates MonitorMouse.dll for use by monitor.exe (the script debugger)
// All this does is send mouse event info to the monitor application's main window
// via the WM_COPYDATA message.

// The script debugger application then uses the mouse info to cause a 
// mouse cursor to appear on the PSX screen whenever the PC mouse cursor is 
// moved off the left edge of the PC monitor.

#include "stdafx.h"
#include "MonitorMouse.h"

#pragma data_seg(".SHARDATA")
HHOOK ghMouseHook=NULL;
HWND ghWndApp=NULL;
#pragma data_seg()

#pragma comment(linker, "/SECTION:.SHARDATA,RWS")

HINSTANCE hInstDLL = NULL;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			hInstDLL = (HINSTANCE)hModule;
			break;
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}


LRESULT CALLBACK MouseProc(int code, WPARAM wParam, LPARAM lParam)
{
	MOUSEHOOKSTRUCT *p_struct=(MOUSEHOOKSTRUCT*)lParam;

	// Send the MOUSEHOOKSTRUCT info & wParam using a COPYDATA message.

	SMouseInfo mouse_info;
	mouse_info.mMouseProcCode=code;
	mouse_info.mMouseProcWParam=wParam;
	mouse_info.mMouseHookStruct=*p_struct;

	COPYDATASTRUCT cds;
	cds.dwData=(DWORD)p_struct->hwnd;
	cds.cbData=sizeof(SMouseInfo);
	cds.lpData=&mouse_info;

	if (SendMessage(ghWndApp, WM_COPYDATA, (WPARAM)cds.dwData, (LPARAM)&cds))
	{
		// If the script debugger returns true from SendMessage, that means that
		// the mouse cursor is on the game screen so button events must not be passed
		// on to windows.
		return 1;
	}
	
    return CallNextHookEx(ghMouseHook, code, wParam, lParam);
}

BOOL __declspec(dllexport) SetMouseHook(HWND hwnd)
{
    ghMouseHook = SetWindowsHookEx(WH_MOUSE, MouseProc, hInstDLL, 0);
	if (ghMouseHook==NULL)
	{
		return FALSE;
	}

    ghWndApp = hwnd;
    return TRUE;
}

BOOL __declspec(dllexport) ReleaseMouseHook()
{
    ghWndApp = NULL;
    return UnhookWindowsHookEx(ghMouseHook);
}

