#ifndef __IGNORE_H

#ifndef __CORE_DEFINES_H
#include "core/defines.h"
#endif

class CScriptIdList
{
	enum 
	{
		// The buffer needs to be big enough such that very late script info packets
		// will be ignored. I think 500 should be enough ...
		MAX_ENTRIES=500
	};

	uint32 mp_script_ids[MAX_ENTRIES];
	int m_num_entries;
	int m_next_entry;

public:
	CScriptIdList();
	~CScriptIdList();

	void Clear();
	bool IsInList(uint32 id);
	void AddId(uint32 id);
	void RemoveId(uint32 id);
};

extern CScriptIdList gDeadScriptsIdList;
extern CScriptIdList gIgnoredScriptsIdList;

#endif
