#include "stdafx.h"
#include "ignore.h"

// This maintains an array of the ids of scripts whose info packets need to be ignored,
// such as dead scripts and scripts which the user has chosen not to watch any more.

// This is needed because sometimes packets arrive out of order from the PS2,
// so a script-died message may arrive, followed by some late script-info packets.
// This was causing a problem because the script-died message will make the
// script window close, but then the late script-info packet will cause it
// to get recreated.

CScriptIdList gDeadScriptsIdList;
CScriptIdList gIgnoredScriptsIdList;

CScriptIdList::CScriptIdList()
{
	Clear();
}

CScriptIdList::~CScriptIdList()
{
}

void CScriptIdList::Clear()
{
	m_num_entries=0;
	m_next_entry=0;
}

bool CScriptIdList::IsInList(uint32 id)
{
	for (int i=0; i<m_num_entries; ++i)
	{
		if (mp_script_ids[i]==id)
		{
			return true;
		}
	}
	return false;
}

void CScriptIdList::AddId(uint32 id)
{
	mp_script_ids[m_next_entry]=id;

	++m_next_entry;
	if (m_next_entry >= MAX_ENTRIES)
	{
		m_next_entry=0;
	}
	
	if (m_num_entries < MAX_ENTRIES)
	{
		++m_num_entries;
	}
}

void CScriptIdList::RemoveId(uint32 id)
{
	int index=-1;
	for (int i=0; i<m_num_entries; ++i)
	{
		if (mp_script_ids[i]==id)
		{
			index=i;
			break;
		}
	}
	if (index==-1)
	{
		return;
	}

	for (i=index; i<m_num_entries-1; ++i)
	{
		mp_script_ids[i]=mp_script_ids[i+1];
	}
	if (m_next_entry > index)
	{
		--m_next_entry;
	}
	--m_num_entries;
}	

