// WatchListView.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "WatchListView.h"
#include "WatchListTree.h"
#include "gel/scripting/debugger.h"
#include "sk/gamenet/scriptdebugger.h"
#include "engine.h"
#include "checksum.h"
#include "utils.h"
#include "scriptselect.h"
#include <gel/scripting/checksum.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int WM_WATCH_LIST = RegisterWindowMessage ("WATCH_LIST");

/////////////////////////////////////////////////////////////////////////////
// CWatchListView

IMPLEMENT_DYNCREATE(CWatchListView, CView)

HWND CWatchListView::s_window=NULL;

CWatchListView::CWatchListView()
{
	mp_tree=NULL;
	s_window=NULL;
}

CWatchListView::~CWatchListView()
{
	if (mp_tree)
	{
		delete mp_tree;
	}
	s_window=NULL;
}


BEGIN_MESSAGE_MAP(CWatchListView, CView)
	//{{AFX_MSG_MAP(CWatchListView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_REGISTERED_MESSAGE(WM_WATCH_LIST, OnWatchList)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_REFRESH, OnRefreshWatchList)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_INSERT, OnInsert)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWatchListView drawing

void CWatchListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

void CWatchListView::indicate_waiting_for_reply()
{
	CDocument *p_doc=GetDocument();
	p_doc->SetTitle("Waiting for reply ...");

	if (mp_tree)
	{
		mp_tree->DeleteAllItems();
	}
}

enum
{
	WATCH_LIST_WIDTH=300,
	WATCH_LIST_HEIGHT=400
};

void CWatchListView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	// Change the width and height so that all the controls I'm adding are visible.
	// The SWP_NOMOVE means keep the x,y coord of the top left corner the same as it
	// is currently, so that the passed x,y of 0,0 is ignored.
	GetParent()->SetWindowPos(NULL, 0,0, WATCH_LIST_WIDTH,WATCH_LIST_HEIGHT, SWP_NOMOVE);

	mp_tree=new CWatchListTree;
	mp_tree->Create(TVS_HASLINES | 
					TVS_LINESATROOT |
					TVS_HASBUTTONS |
					TVS_NOTOOLTIPS |
					WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_VSCROLL | WS_HSCROLL,
					CRect(0, 0, WATCH_LIST_WIDTH-12, WATCH_LIST_HEIGHT-31), this, 111);

	mp_tree->SetBkColor((COLORREF)0xc0c0c0);

	indicate_waiting_for_reply();
}

HWND CWatchListView::sGetWindow()
{
	return s_window;
}

/////////////////////////////////////////////////////////////////////////////
// CWatchListView diagnostics

#ifdef _DEBUG
void CWatchListView::AssertValid() const
{
	CView::AssertValid();
}

void CWatchListView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWatchListView message handlers

int CWatchListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	s_window=m_hWnd;
	
	return 0;
}

void CWatchListView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	if (mp_tree)
	{
		mp_tree->SetWindowPos(NULL, 0,0, cx, cy, SWP_NOMOVE);	
	}
}

void CWatchListView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	ConvertKeyPressToMessage(nChar,this);
	
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

afx_msg LRESULT CWatchListView::OnWatchList(WPARAM wParam, LPARAM lParam)
{
	CDocument *p_doc=GetDocument();
	p_doc->SetTitle("Script watches ... press F5 to refresh");

	mp_tree->DeleteAllItems();


	// wParam is the size of the data in bytes, the data being an array of SWatchInfo's
	Dbg_MsgAssert(wParam%sizeof(Dbg::SWatchInfo)==0,("Size of watch list data is not a multiple of sizeof(Dbg::SWatchInfo)"));
	int n=wParam/sizeof(Dbg::SWatchInfo);

	// lParam is the pointer to the data.
	Dbg::SWatchInfo *p_info=(Dbg::SWatchInfo*)lParam;

	for (int i=0; i<n; ++i)
	{
		HTREEITEM h_item=mp_tree->InsertItem(Script::FindChecksumName(p_info->mScriptName));
		mp_tree->SetCheck(h_item,p_info->mStopImmediately);

		++p_info;
	}

	return (LRESULT)0;
}

afx_msg LRESULT CWatchListView::OnRefreshWatchList(WPARAM wParam, LPARAM lParam)
{
	indicate_waiting_for_reply();

	// Send a refresh request to the PS2
	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_SEND_WATCH_LIST;
	gClient->EnqueueMessageToServer(&msg);

	return (LRESULT)0;
}

afx_msg LRESULT CWatchListView::OnHelp(WPARAM wParam, LPARAM lParam)
{
	BringUpHelpFile("Watch_list_window");
	return (LRESULT)0;
}

afx_msg LRESULT CWatchListView::OnInsert(WPARAM wParam, LPARAM lParam)
{
	CScriptSelect dlg;
	dlg.DoModal();

	return (LRESULT)0;
}
