// WatchListTree.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "WatchListTree.h"
#include "utils.h"
#include "engine.h"
#include "sk/gamenet/scriptdebugger.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWatchListTree

CWatchListTree::CWatchListTree()
{
}

CWatchListTree::~CWatchListTree()
{
}


BEGIN_MESSAGE_MAP(CWatchListTree, CTreeCtrl)
	//{{AFX_MSG_MAP(CWatchListTree)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWatchListTree message handlers

void CWatchListTree::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// Note: CWatchListView also has a KeyDown handler, but the tree needs one too because
	// the CWatchListView will not get a keydown message if the tree is selected.
	ConvertKeyPressToMessage(nChar,GetParent());

	// If the delete key is pressed, send a message to the PS2 telling it to
	// stop watching that script.
	if (nChar==46)
	{
		HTREEITEM h_selected_item=GetSelectedItem();
		if (h_selected_item)
		{
			uint32 index=0;
			HTREEITEM h_item=GetRootItem();
			while (true)
			{
				if (h_item==h_selected_item)
				{
					// Found it!

					// Tell the PS2 to stop watching this script.
					Net::MsgDesc msg;
					msg.m_Id = GameNet::vMSG_ID_DBG_STOP_WATCHING_THIS_INDEX;
					msg.m_Length=4;
					msg.m_Data=&index;
					gClient->EnqueueMessageToServer(&msg);

					// Note: The PS2 will send a message back refreshing the watch-list,
					// so there is no need here to remove the tree item, since it will
					// get removed by the refresh.
					break;
				}
				if (h_item==NULL)
				{
					// Just for safety, to avoid an infinite loop
					break;
				}

				h_item=GetNextSiblingItem(h_item);
				++index;
			}
		}
	}


	CTreeCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
}
