// ScriptGlobalView.cpp : implementation file
//

#include "stdafx.h"
#include "Monitor.h"
#include "ScriptGlobalView.h"
#include "mycode.h"
#include "checksum.h"
#include "mytreectrl.h"
#include "utils.h"
#include "sk/gamenet/scriptdebugger.h"
#include "engine.h"
#include "debuggerbutton.h"
#include <gel/scripting/checksum.h>

int WM_SCRIPT_GLOBAL_INFO = RegisterWindowMessage ("SCRIPT_GLOBAL_INFO");
// CScriptGlobalView

IMPLEMENT_DYNCREATE(CScriptGlobalView, CView)

CScriptGlobalView::CScriptGlobalView()
{
	m_id=0;
	m_width=500;
}

CScriptGlobalView::~CScriptGlobalView()
{
	RemoveWindowFromHashTable(gpScriptGlobalWindowHashTable,m_id);
}

BEGIN_MESSAGE_MAP(CScriptGlobalView, CView)
	ON_REGISTERED_MESSAGE(WM_SCRIPT_GLOBAL_INFO, OnScriptGlobalInfo)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_REFRESH, OnRefresh)
	ON_REGISTERED_MESSAGE(WM_EXPAND_ALL,OnExpandAll)
	ON_REGISTERED_MESSAGE(WM_COLLAPSE_ALL,OnCollapseAll)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
END_MESSAGE_MAP()


// CScriptGlobalView drawing

void CScriptGlobalView::OnDraw(CDC* pDC)
{
	CMyListView::OnDraw(pDC);
}

void CScriptGlobalView::OnInitialUpdate() 
{
	CMyListView::OnInitialUpdate();
	add_expand_collapse_buttons();
}

// CScriptGlobalView diagnostics

#ifdef _DEBUG
void CScriptGlobalView::AssertValid() const
{
	CView::AssertValid();
}

void CScriptGlobalView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG


// CScriptGlobalView message handlers

int CScriptGlobalView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMyListView::OnCreate(lpCreateStruct) == -1)
		return -1;

	// Register itself in the hash table indexed by the object id, so that when
	// a message is received from the game the message can be sent to this window.

	m_id=gNewWindowParams.mId;

	gNewWindowParams.mInfo.mViewHWND=m_hWnd;
	gNewWindowParams.mInfo.mpDocument=GetDocument();

	CWindowInfo *p_new=new CWindowInfo;
	*p_new=gNewWindowParams.mInfo;
	gpScriptGlobalWindowHashTable->PutItem(m_id,p_new);
	
	return 0;
}

afx_msg LRESULT CScriptGlobalView::OnScriptGlobalInfo(WPARAM wParam, LPARAM lParam)
{
	GetParentFrame()->BringWindowToTop();

	uint32 *p_data=(uint32*)lParam;
	uint32 id=*p_data++;
	uint32 type=*p_data++;
	const char *p_source_file_name=(const char*)p_data;
	uint8 *p_structure_data=(uint8*)(p_source_file_name+strlen(p_source_file_name)+1);

	CDocument *p_doc=GetDocument();
	char p_title[1024];
	sprintf(p_title,"Script global '%s'",Script::FindChecksumName(id));
	p_doc->SetTitle(p_title);

	m_top_text="Defined in ";
	m_top_text+=p_source_file_name;

	mp_tree->RemoveAllEntries();
	InsertCStructIntoTree(mp_tree,NULL,p_structure_data);
	mp_tree->CopyToDisplayedTree();

	// Make sure the parent is expanded just for convenience.
	mp_tree->Expand(mp_tree->GetRootItem(),TVE_EXPAND);

	return (LRESULT)0;
}

// This gets called when F5 is pressed.
afx_msg LRESULT CScriptGlobalView::OnRefresh(WPARAM wParam, LPARAM lParam)
{
	indicate_waiting_for_reply();

	// Send a refresh request to the PS2
	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_SEND_SCRIPT_GLOBAL_INFO;
	msg.m_Length=4;
	msg.m_Data=&m_id;
	gClient->EnqueueMessageToServer(&msg);

	return (LRESULT)0;
}

// Needed so that the background can be cleared to grey so as to match that of
// the tree control, otherwise the background will be white behind the buttons
// at the top.
BOOL CScriptGlobalView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default

	return CMyListView::OnEraseBkgnd(pDC);
}

// Needed so that F5 presses can be detected.
void CScriptGlobalView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

	CMyListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

// Need this so that the tree adjusts its size to match that of the window.
void CScriptGlobalView::OnSize(UINT nType, int cx, int cy)
{
	CMyListView::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
}
