// PrintfView.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "PrintfView.h"
#include "utils.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrintfView

int WM_PRINTF = RegisterWindowMessage ("PRINTF");

IMPLEMENT_DYNCREATE(CPrintfView, CView)

HWND CPrintfView::s_window=NULL;

CPrintfView::CPrintfView()
{
	s_window=NULL;
	mp_edit=NULL;
	m_counter=0;
}

CPrintfView::~CPrintfView()
{
	s_window=NULL;
	if (mp_edit)
	{
		delete mp_edit;
	}
}


BEGIN_MESSAGE_MAP(CPrintfView, CView)
	//{{AFX_MSG_MAP(CPrintfView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_REGISTERED_MESSAGE(WM_PRINTF, OnPrintf)
	//}}AFX_MSG_MAP
	ON_WM_KEYDOWN()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrintfView drawing

void CPrintfView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

enum
{
	PRINTF_WIDTH=550,
	PRINTF_HEIGHT=400
};

enum
{
	TEXT_HEIGHT=10*20,
};

void CPrintfView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	GetDocument()->SetTitle("Printf output");
	GetParent()->SetWindowPos(NULL, 450,25, PRINTF_WIDTH,PRINTF_HEIGHT,0);

	mp_edit = new CRichEditCtrl;
	mp_edit->Create(ES_MULTILINE |
					ES_AUTOHSCROLL |
					ES_AUTOVSCROLL |
					ES_READONLY |
					ES_NOHIDESEL |
					WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_VSCROLL | WS_HSCROLL,
					CRect(0, 0, PRINTF_WIDTH-12, PRINTF_HEIGHT-31), this, 111);
					
	mp_edit->SetBackgroundColor(false,(COLORREF)0x000000);


	CHARFORMAT cf;
	cf.cbSize = sizeof(CHARFORMAT); //CHARFORMAT can be variant sizes 
    cf.dwMask = CFM_BOLD | CFM_COLOR | CFM_FACE |
                CFM_ITALIC | CFM_SIZE | CFM_UNDERLINE; 
    cf.dwEffects = 0; // CFE_BOLD CFE_ITALIC CFE_UNDERLINE
    cf.yHeight = TEXT_HEIGHT;
    cf.crTextColor = RGB(0, 255, 0);
    strcpy(cf.szFaceName, "Arial");
    cf.bCharSet = 0; 
    cf.bPitchAndFamily = 0;

	mp_edit->SetDefaultCharFormat(cf);
}

HWND CPrintfView::sGetWindow()
{
	return s_window;
}

// This will scroll the window so that the bottom line is visible and at the bottom
// of the window.
void CPrintfView::scroll_to_bottom()
{
	RECT rect;
	mp_edit->GetClientRect(&rect);

	// There is probably a better way of working this out, but this roughly works ...
	int num_lines_that_will_fit_in_window=(rect.bottom-rect.top)/(TEXT_HEIGHT/12.34f);

	int num_lines_to_scroll=mp_edit->GetLineCount()-
							(mp_edit->GetFirstVisibleLine()+1)-
							num_lines_that_will_fit_in_window;

	mp_edit->LineScroll(num_lines_to_scroll);
}

/////////////////////////////////////////////////////////////////////////////
// CPrintfView diagnostics

#ifdef _DEBUG
void CPrintfView::AssertValid() const
{
	CView::AssertValid();
}

void CPrintfView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPrintfView message handlers

int CPrintfView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	s_window=m_hWnd;
	
	return 0;
}

void CPrintfView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	if (mp_edit)
	{
		mp_edit->SetWindowPos(NULL, 0,0, cx, cy, SWP_NOMOVE);	
	}
}

void CPrintfView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	scroll_to_bottom();
}

enum
{
	MAX_LINES=100,
};

afx_msg LRESULT CPrintfView::OnPrintf(WPARAM wParam, LPARAM lParam)
{
	if (mp_edit)
	{
		CString text;

		while (mp_edit->GetLineCount() >= MAX_LINES)
		{
			mp_edit->GetWindowText(text);
			text.Delete(0,text.Find("\n",0)+1);
			mp_edit->SetWindowText(text);
		}

		mp_edit->GetWindowText(text);

		char p_foo[100];
		sprintf(p_foo,"%d:",m_counter++);
		text+=p_foo;
		text+=(const char *)lParam;
		text+="\n";
		mp_edit->SetWindowText(text);

		scroll_to_bottom();
	}
	return (LRESULT)0;
}


void CPrintfView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

	if (nChar==112) // F1
	{
		BringUpHelpFile("Printf_window");
		return;
	}

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}
