// MyTreeCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "MyTreeCtrl.h"
#include "mycode.h"
#include "utils.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//int gNumCMyTreeEntries=0;

CMyTreeEntry::CMyTreeEntry()
{
	mpText[0]=0;
	mpNext=NULL;
	mpChild=NULL;
	//++gNumCMyTreeEntries;
}

CMyTreeEntry::~CMyTreeEntry()
{
	if (mpChild)
	{
		CMyTreeEntry *p_entry=mpChild;
		while (p_entry)
		{
			CMyTreeEntry *p_next=p_entry->mpNext;
			delete p_entry;
			p_entry=p_next;
		}
	}
	//--gNumCMyTreeEntries;
}

/////////////////////////////////////////////////////////////////////////////
// CMyTreeCtrl

CMyTreeCtrl::CMyTreeCtrl()
{
	mp_first_entry=NULL;
}

CMyTreeCtrl::~CMyTreeCtrl()
{
	RemoveAllEntries();
}

void CMyTreeCtrl::RemoveAllEntries()
{
	CMyTreeEntry *p_entry=mp_first_entry;
	while (p_entry)
	{
		CMyTreeEntry *p_next=p_entry->mpNext;
		delete p_entry;
		p_entry=p_next;
	}
	mp_first_entry=NULL;
}

CMyTreeEntry *CMyTreeCtrl::GetFirstEntry()
{
	return mp_first_entry;
}

CMyTreeEntry *CMyTreeCtrl::AddEntry(const char *p_text, CMyTreeEntry *p_parent)
{
	CMyTreeEntry *p_new_entry=new CMyTreeEntry;

	// Copy in the text.
	Dbg_MsgAssert(strlen(p_text)<=CMyTreeEntry::MAX_TEXT_LENGTH,("Text '%s' too long for CMyTreeEntry",p_text));
	strcpy(p_new_entry->mpText,p_text);

	CMyTreeEntry *p_first=NULL;

	// Passing a parent of NULL is used to mean use the root.
	if (p_parent==NULL)
	{
		p_first=mp_first_entry;
	}
	else
	{
		if (p_parent->mpChild)
		{
			p_first=p_parent->mpChild;
		}
		else
		{
			p_parent->mpChild=p_new_entry;
			return p_new_entry;
		}
	}

	// Find the last entry
	CMyTreeEntry *p_last=NULL;
	CMyTreeEntry *p_scan=p_first;
	while (p_scan)
	{
		p_last=p_scan;
		p_scan=p_scan->mpNext;
	}

	// Stick the new entry on the end.
	if (p_last)
	{
		p_last->mpNext=p_new_entry;
	}
	else
	{
		mp_first_entry=p_new_entry;
	}

	return p_new_entry;
}

void CMyTreeCtrl::CopyToDisplayedTree(CMyTreeEntry *p_sourceParent, CMyTreeEntry *p_sourceItem,
									  HTREEITEM h_destParent, HTREEITEM h_destItem)
{
	while (true)
	{
		if (p_sourceItem==NULL)
		{
			if (h_destItem==NULL)
			{
				// Finished!
				break;
			}
			else
			{
				// Delete h_destItem then make h_destItem be the next sibling.
				// h_destParent remains the same.
				HTREEITEM h_next=GetNextSiblingItem(h_destItem);
				DeleteItem(h_destItem);
				h_destItem=h_next;
			}
		}
		else
		{
			if (h_destItem==NULL)
			{
				h_destItem=InsertItem(p_sourceItem->mpText,h_destParent);
			}
			else
			{
				// Only update the text if it has changed, to reduce flicker.
				if (strcmp(GetItemText(h_destItem),p_sourceItem->mpText))
				{
					SetItemText(h_destItem,p_sourceItem->mpText);
				}
			}
			
			if (p_sourceItem->mpChild)
			{
				CopyToDisplayedTree(p_sourceItem,p_sourceItem->mpChild,
									h_destItem,GetChildItem(h_destItem));
			}
			else
			{
				// The source item has no child, but maybe the dest item does.
				// If so, it and all other children it has need to be removed
				// so as to match the source item.
				if (ItemHasChildren(h_destItem))
				{
					HTREEITEM h_child=GetChildItem(h_destItem);
					while (h_child != NULL)
					{
						HTREEITEM h_next=GetNextSiblingItem(h_child);
						DeleteItem(h_child);
						h_child=h_next;
					}
				}
			}

			p_sourceItem=p_sourceItem->mpNext;
			h_destItem=GetNextSiblingItem(h_destItem);
		}
	}
}

void CMyTreeCtrl::CopyToDisplayedTree()
{
	CopyToDisplayedTree(NULL,mp_first_entry,
						TVI_ROOT,GetRootItem());
}

HTREEITEM CMyTreeCtrl::CollapseAllSiblingsButExpandLast(HTREEITEM h_item)
{
	HTREEITEM h_last_item=NULL;
	while (h_item != NULL)
	{
		if (h_last_item != NULL)
		{
			Expand(h_last_item,TVE_COLLAPSE);
		}
		h_last_item=h_item;
		h_item=GetNextSiblingItem(h_item);
	}

	if (h_last_item != NULL)
	{
		Expand(h_last_item,TVE_EXPAND);
	}

	return h_last_item;
}

void CMyTreeCtrl::ExpandAllSiblingsAndChildren(HTREEITEM h_item, UINT nCode)
{
	while (h_item != NULL)
	{
		if (ItemHasChildren(h_item))
		{
			ExpandAllSiblingsAndChildren(GetChildItem(h_item),nCode);
		}
		Expand(h_item,nCode);
		h_item=GetNextSiblingItem(h_item);
	}
}

void CMyTreeCtrl::ExpandAll(UINT nCode)
{
	ExpandAllSiblingsAndChildren(GetRootItem(),nCode);
}

void CMyTreeCtrl::BringUpInfoOnItem(HTREEITEM h_item)
{
	if (h_item)
	{
		// Parse the text to see if it is referring to a script or an object, and
		// bring up the appropriate window.
		CString text=GetItemText(h_item);
		ParseTreeEntryText(text);
	}
}

BEGIN_MESSAGE_MAP(CMyTreeCtrl, CTreeCtrl)
	//{{AFX_MSG_MAP(CMyTreeCtrl)
	ON_NOTIFY_REFLECT(TVN_SELCHANGING, OnSelchanging)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclk)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyTreeCtrl message handlers


// This gets called whenever the user selects an entry in the displayed tree
// by clicking on it.
// Whenever they click on one of the entries at the lowest level, ie one of the
// entries specifying a script file name, this will send a message up to
// the parent CMonitorView object so that it can change the displayed file
// in the edit box.
void CMyTreeCtrl::OnSelchanging(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	
	// Check whether this entry is one of the callstack entries, which it
	// will be if it has no parent.
	if (GetParentItem(pNMTreeView->itemNew.hItem)==NULL)
	{
		// It is a callstack entry, so find out its index by counting
		// from the start until it is found.
		int index=0;
		HTREEITEM h_item=GetRootItem();
		while (true)
		{
			if (h_item==pNMTreeView->itemNew.hItem)
			{
				// Found it!
				break;
			}
			if (h_item==NULL)
			{
				// Just for safety, to avoid an infinite loop
				break;
			}

			h_item=GetNextSiblingItem(h_item);
			++index;
		}

		// Got the index, so send a message containing the index up to the CMonitorView

		int WM_CHANGE_FILE = RegisterWindowMessage ("CHANGE_FILE");
		GetParent()->SendMessage(WM_CHANGE_FILE,index);
	}
	*pResult = 0;
}


void CMyTreeCtrl::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// The tree needs a keydown handler because the parent view class will
	// not get a keydown message if the tree is selected.
	// So if the tree gets a keydown massage, pass on a message to the parent.
	// This is for handling things such as F5 presses.
	ConvertKeyPressToMessage(nChar,GetParent());
	
	// If the enter key is pressed, make it have the same effect as double-clicking
	// the tree entry.
	if (nChar==13)
	{
		BringUpInfoOnItem(GetSelectedItem());
	}

	CTreeCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CMyTreeCtrl::OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult)
{
	// Figure out what tree item was clicked on.
	CPoint p(GetMessagePos());
    ScreenToClient (&p);
	HTREEITEM h_clicked_item=HitTest(p);

	BringUpInfoOnItem(h_clicked_item);

	*pResult = 0;
}
