#pragma once

class CMyTreeCtrl;
class CDebuggerButton;

// CMyListView view

class CMyListView : public CView
{
	DECLARE_DYNCREATE(CMyListView)

protected:
	CMyListView();           // protected constructor used by dynamic creation
	virtual ~CMyListView();
	void OnInitialUpdate();

	void indicate_waiting_for_reply();
	void remove_buttons();
	int  add_button(const char *p_text, int messageToSendToParent);
	void move_buttons_and_tree_down(int dy);
	void enable_top_text(int height, const char *p_fontName="Arial");
	void support_profiling_info();
	void show_total_cpu_time();
	void add_expand_collapse_buttons();


	int m_width;
	int m_height;

	bool m_got_top_text;
	int m_top_text_height;
	CFont *mp_text_font;
	CString m_top_text;

	int m_num_buttons;
	enum
	{
		MAX_BUTTONS=10
	};
	CDebuggerButton *mp_buttons[MAX_BUTTONS];
	int m_button_width;
	int m_button_height;
	CFont *mp_button_font;

	CMyTreeCtrl *mp_tree;

public:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg LRESULT OnSortTreeByCPUTime(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnExpandAll(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnCollapseAll(WPARAM wParam, LPARAM lParam);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};

extern int WM_SORT_TREE_BY_CPU_TIME;
extern int WM_EXPAND_ALL;
extern int WM_COLLAPSE_ALL;

