// ChecksumEntryDialog.cpp : implementation file
//

#include "stdafx.h"
#include "Monitor.h"
#include "ChecksumEntryDialog.h"
#include "engine.h"
#include "checksum.h"
#include <gel/scripting/checksum.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChecksumEntryDialog dialog


CChecksumEntryDialog::CChecksumEntryDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CChecksumEntryDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChecksumEntryDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CChecksumEntryDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChecksumEntryDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CChecksumEntryDialog, CDialog)
	//{{AFX_MSG_MAP(CChecksumEntryDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChecksumEntryDialog message handlers

void CChecksumEntryDialog::OnOK() 
{
	CDialog::OnOK();

	char p_text[100];
	GetDlgItemText(IDC_EDIT2,p_text,100);

	// Skip leading white space
	char *p_start=p_text;
	while (*p_start==' ' || *p_start=='\t')
	{
		++p_start;
	}

	// Skip any '0x'
	if (p_start[0]=='0' && (p_start[1]=='x' || p_start[1]=='X'))
	{
		p_start+=2;
	}
	// Skip any '$'
	if (*p_start=='$')
	{
		++p_start;
	}

	uint32 checksum=0;
	for (int i=0; i<8; ++i)
	{
		int ch=*p_start;
		if (ch==0 || ch==' ' || ch=='\t')
		{
			break;
		}
		if (ch>='0' && ch<='9')
		{
			checksum=(checksum<<4)+ch-'0';
		}
		else if (ch>='a' && ch<='f')
		{
			checksum=(checksum<<4)+ch-'a'+10;
		}
		else if (ch>='A' && ch<='F')
		{
			checksum=(checksum<<4)+ch-'A'+10;
		}
		else
		{
			char p_blaa[1000];
			sprintf(p_blaa,"Bad character '%c' in hex value '%s'",ch,p_text);
			MessageBox(p_blaa,"Error",MB_OK);
			return;
		}
		++p_start;
	}
	if (!(*p_start==' ' || *p_start=='\t' || *p_start==0))
	{
		char p_blaa[1000];
		sprintf(p_blaa,"Hex value '%s' too long",p_text);
		MessageBox(p_blaa,"Error",MB_OK);
		return;
	}

	char p_title[1000];
	sprintf(p_title,"Checksum lookup for 0x%08x",checksum);
	if (Script::FindChecksumNameNULL(checksum)==NULL)
	{
		MessageBox("No name found",p_title,MB_OK);
	}
	else
	{
		MessageBox(Script::FindChecksumName(checksum),p_title,MB_OK);
	}
}
