/*
	ThumbnailTree.h
	Thumbnail TreeView control
	Custom Drawn TreeView control that displays thumbnails next to each entry

	9-10-03 - aml
*/

#ifndef __THUMBNAILTREE_H__
#define __THUMBNAILTREE_H__

#include "UIControl.h"

#define CLASSNAME_TNTREEUI	"ThumbnailTree"

class ThumbNailTree: public UIControl
{
	HWND     hwndTree;
	WNDPROC  origWndproc;		// Original wndproc of TreeView control before subclassing

	void BuildControlUI();
	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	
	void (*fpSelChange)(ThumbNailTree*, void*);
	void* pSelChangeData;

	static LRESULT SubWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	
	static DWORD WINAPI LoadImageThread(void* pData);

	HWND   GetFocusWindow() { return hwndTree; }

public:
	CLASSNAME(CLASSNAME_TNTREEUI)

	ThumbNailTree(HINSTANCE hInstance);
	ThumbNailTree(HINSTANCE hInstance, HWND hwnd);
	//ThumbNailTree(ThumbNailTree& right);
	~ThumbNailTree();

	//ThumbNailTree& operator = (ThumbNailTree& right);

	void* AddNode(char* name, void* pData = NULL);
	void* AddNode(char* name, char* filename, void* pData = NULL);
	void* AddNode(void* pParent, char* name, void* pData = NULL);
	void* AddNode(void* pParent, char* name, char* filename, void* pData = NULL);
	
	void  RemoveNode(void* pData);

	int   GetSelCount();
	void  GetSelItems(void** selList, int selMax);

	bool  GetItemName(void* pData, char* name, int len);
	bool  SetItemName(void* pItem, char* name);
	void* GetItemData(void* pData);

	int   GetItemDepth(void* pData);
	void  ClearSelections();
	void  Clear();

	void  RegisterSelChangeCB(void (*fpFunc)(ThumbNailTree*,void*), void* pData);
	bool  TraverseTree(bool (*fpFunc)(ThumbNailTree*, void* , void*), void* pData);
	bool  TraverseTreeItems(void* hItem, bool (*fpFunc)(ThumbNailTree*, void*, void*), void* pData);

	bool  SetThumbnailFile(void* pItem, char* filename);
	char* GetThumbnailFile(void* pItem);

	void* GetChildItem(void* pItem);
	void* GetParentItem(void* pItem);
	void* GetNextItem(void* pItem);
	int   GetChildIndex(void* pItem);
};

#endif
