#include "FuncEnter.h"

/*
	SlideNum.cpp
	Slider Number UI
	A slider UI with an attached label displaying it's value
*/

#include "SlideNum.h"

SliderNum::SliderNum(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("SliderNum::SliderNum"); 
	hwndSlider = NULL;
	hwndEdit  = NULL;
	ISlider    = NULL;

	bLockChange = FALSE;

	SetLimits(0,100);
}

SliderNum::SliderNum(HINSTANCE hInstance, HWND hwnd) :
	UIControl(hInstance, hwnd, CLASS)
{ FUNC_ENTER("SliderNum::SliderNum"); 
	hwndSlider = NULL;
	hwndEdit  = NULL;
	ISlider    = NULL;

	SetLimits(0,100);
}

SliderNum::~SliderNum()
{ FUNC_ENTER("SliderNum::~SliderNum"); 
	ReleaseISlider(ISlider);
}

SliderNum::SliderNum(SliderNum& right) :
	UIControl(right.hInstance, CLASS)
{ FUNC_ENTER("SliderNum::SliderNum"); 
	hwndSlider = NULL;
	hwndEdit   = NULL;
	ISlider    = NULL;
	mode       = right.mode;

	switch(mode)
	{
	case MODE_FLOAT:
		fmin  = right.fmin;
		fmax  = right.fmax;
		fincr = right.fincr;
		break;

	case MODE_INT:
		imin  = right.imin;
		imax  = right.imax;
		iincr = right.iincr;
		break;
	}
}

SliderNum& SliderNum::operator = (SliderNum& right)
{ FUNC_ENTER("SliderNum::operator="); 
	hwndSlider = NULL;
	hwndEdit   = NULL;
	ISlider    = NULL;
	mode       = right.mode;

	switch(mode)
	{
	case MODE_FLOAT:
		fmin  = right.fmin;
		fmax  = right.fmax;
		fincr = right.fincr;
		break;

	case MODE_INT:
		imin  = right.imin;
		imax  = right.imax;
		iincr = right.iincr;
		break;
	}

	return *this;
}

void SliderNum::SetLimits(int min,int max)
{ FUNC_ENTER("SliderNum::SetLimits"); 
	imin  = min;
	imax  = max;
	mode  = MODE_INT;

	if (ISlider)
	{
		ISlider->SetLimits(min,max);
	}
}

void SliderNum::SetLimits(float min,float max)
{ FUNC_ENTER("SliderNum::SetLimits"); 
	fmin  = min;
	fmax  = max;
	mode  = MODE_FLOAT;

	if (ISlider)
	{
		ISlider->SetLimits(min,max);
	}
}

void SliderNum::BuildControlUI()
{ FUNC_ENTER("SliderNum::BuildControlUI"); 
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	int width = wndRect.right - wndRect.left;

	hwndSlider = CreateWindow("SliderControl",
		                      "None",
							  WS_CHILD|WS_VISIBLE,
							  0,
							  0,
							  2 * (width / 3),
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)0,
							  hInstance,
							  NULL);

	hwndEdit  = CreateWindow("CustEdit",
		                      "0",
							  WS_CHILD|WS_VISIBLE,
							  2 * (width / 3),
							  0,
							  (width / 3),
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)0,
							  hInstance,
							  NULL);

	ISlider = GetISlider(hwndSlider);

	ICustEdit* IEdit = GetICustEdit(hwndEdit);
	IEdit->WantDlgNextCtl(TRUE);
	ReleaseICustEdit(IEdit);

	if (mode == MODE_INT)
	{
		ISlider->SetLimits(imin,imax);
		ISlider->LinkToEdit(hwndEdit,EDITTYPE_INT);
	}
	else
	{
		ISlider->SetLimits(fmin,fmax);
		ISlider->LinkToEdit(hwndEdit,EDITTYPE_FLOAT);
	}
}

LRESULT SliderNum::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("SliderNum::WndProc"); 
	switch(msg)
	{
	case WM_SETTEXT:
		{
			SetWindowText(hwndEdit,(char*)lParam);
		}
		return TRUE;

	case WM_GETTEXT:
		{
			char buf[256];
			GetWindowText(hwndEdit,buf,255);

			char* str    = (char*)lParam;
			int   maxlen = (int)wParam;

			for(int i=0;i<strlen(buf) && i<maxlen-1;i++)
				str[i] = buf[i];

			str[i] = '\0';

			return strlen(str);
		}
		return TRUE;

	case WM_ACTIVATE:
		{
			if (LOWORD(wParam))
			{
				HWND hwndParent = GetParent(hwnd);
				int  ID         = (int)GetWindowLong(hwnd,GWL_ID);
				SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);
			}
			return TRUE;
		}

		
	case CC_SLIDER_CHANGE:
		{
			if (bLockChange)
				break;
			/*
			char buf[256];

			if (mode == MODE_INT)
				sprintf(buf,"%i",ISlider->GetIVal());
			else
				sprintf(buf,"%f",ISlider->GetFVal());

			SendMessage(hwndEdit,WM_SETTEXT,0,(LPARAM)buf);
			*/

			// Notify the parent window that an update has occurred
			HWND hwndParent = GetParent(hwnd);
			int  ID         = (int)GetWindowLong(hwnd,GWL_ID);

			SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
		}
	}

	return UIControl::WndProc(hwnd, msg, wParam, lParam);
	//return DefWindowProc(hwnd,msg,wParam,lParam);
}

int SliderNum::GetValue()
{ FUNC_ENTER("SliderNum::GetValue"); 
	return ISlider->GetIVal();
}

void SliderNum::SetValue(int val)
{ FUNC_ENTER("SliderNum::SetValue"); 
	bLockChange=TRUE;
	ISlider->SetValue(val,TRUE);
	bLockChange=FALSE;
}

HWND SliderNum::GetFocusWindow()
{ FUNC_ENTER("SliderNum::GetFocusWindow"); 
	return hwndEdit;
}
