/*
	ProgressBar.h
	A window that displays a progress bar

	NOTE:  This class assumes that you've already initialized Custom Controls

	Adam Lippmann
	12-13-01
*/

#ifndef __PROGRESSBAR__
#define __PROGRESSBAR__

#include <windows.h>
#include <commctrl.h>
#include "../Resource.h"

class ProgressBar
{
	HANDLE    hThread;		// Handle to the thread thats driving the progress bar
	DWORD     dwThreadID;	// ID of thread thats driving the progress bar
	HINSTANCE hInstance;	// hInstance of app
	HWND      hwnd;			// Handle to the Dialog window
	HWND      hwndBar;		// Handle to the progress bar itself
	HWND      hwndText;		// Handle to the text window
	bool      bCancel;		// True if operation was canceled

	int       min;
	int       max;
	int       val;

	void(*fpCancel)(void*);	// Function called when the cancel button is pressed
	void* pCancelData;		// Retained data for the callback

	static BOOL CALLBACK RedirectDlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	static DWORD __stdcall ThreadProc(LPVOID lpParameter);

public:
	ProgressBar(HINSTANCE hInstance,HWND hwndOwner,char* Caption,int min=0,int max=100,int val=0);
	~ProgressBar();

	void ProcMessage(MSG msg);
	void SetCancelCB(void(*Func)(void*),void* pData);

	void SetCaption(char* Caption);
	void SetVal(int val);
	
	void AllowCancel(BOOL bVal);
	BOOL Update();

	inline HWND GetHWND() { return hwnd; }

	bool WasCanceled();
	inline int GetVal() { return val; }

	void SetRange(int min, int max);
};

#endif
