/*
	FlagSelect.h
	This is a UI control for building an array of flag constants
	aml - 7-3-01
*/

#ifndef __FLAGSELECT__
#define __FLAGSELECT__

#include "UIControl.h"
#include "ModalDlg.h"
#include "max.h"
#include "../misc/llist.h"

#define FLAGSELECT_CLASSNAME  "FlagSelect"

class FlagSelectDlg: public ModalDlgWindow
{
	CStr strFlags;
	LinkList<CStr> listFlags;

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void ParseSelectedFlags();

public:
	FlagSelectDlg(HINSTANCE hInstance,HWND hwndParent);
	~FlagSelectDlg();

	void BuildFlags();
	void AddFlag(char* flag);
	void SetFlags(CStr flags);
	void Reset();

	inline CStr GetFlags() { return strFlags; }
};

class FlagSelect: public UIControl
{
	CStr           strValue;
	HWND           hwndButton;
	FlagSelectDlg* flagSelectDlg;
	LinkList<CStr> listFlags;

	void BuildControlUI();

	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

public:
	CLASSNAME(FLAGSELECT_CLASSNAME)

	void OpenFlagBrowser();
	CStr GetValue();
	void SetValue(char* val);
	void AddItem(char* val);

	FlagSelect(HINSTANCE hInstance);
	~FlagSelect();

	FlagSelect(FlagSelect& right);
	FlagSelect& operator = (FlagSelect& right);
};

#endif
