#include "FuncEnter.h"

/*
	FlagSelect.cpp
	This is a UI control for building an array of flag constants
	aml - 7-3-01
*/

#include "FlagSelect.h"
#include "../Resource.h"
#include "../PropEdit/ParseFuncs.h"

#define CUSTIDC_BUTTON 1

////////////////////// FlagSelectDlg

FlagSelectDlg::FlagSelectDlg(HINSTANCE hInstance,HWND hwndParent) :
	ModalDlgWindow(hInstance,MAKEINTRESOURCE(IDD_FLAGBROWSER),hwndParent)
{ FUNC_ENTER("FlagSelectDlg::FlagSelectDlg"); 
	
}

FlagSelectDlg::~FlagSelectDlg()
{ FUNC_ENTER("FlagSelectDlg::~FlagSelectDlg"); 

}

BOOL FlagSelectDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("FlagSelectDlg::DlgProc"); 
	switch(msg)
	{
	case WM_INITDIALOG:
		{
			// Move dialog to cursor position
			RECT  winRect;
			POINT pos;
			GetCursorPos(&pos);
			GetWindowRect(hwnd,&winRect);

			SetWindowPos(hwnd,
					     HWND_TOPMOST,
						 pos.x,pos.y,
						 winRect.right-winRect.left,
						 winRect.bottom-winRect.top,
						 SWP_SHOWWINDOW);

			// Add all the items in the flag list to the list
			SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_RESETCONTENT,0,0);

			Link<CStr>* link = listFlags.GetHead();

			while(link)
			{
				SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_ADDSTRING,0,(LPARAM)(char*)link->data);
				link = link->next;
			}

			ParseSelectedFlags();
		}
		return TRUE;
	
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_APPLY:
			BuildFlags();
			EndDialog(hwnd,0);
			return TRUE;
		}
	}

	return FALSE;
}

void FlagSelectDlg::BuildFlags()
{ FUNC_ENTER("FlagSelectDlg::BuildFlags"); 
	// Scan through the flag list and build an array string based on
	// the user's current selection
	int  count      = SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_GETCOUNT,0,0);
	int  iArrayElem = 0;
	char buf[256];

	strFlags = "[";

	for(int i=0;i<count;i++)
	{
		if (SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_GETSEL,(WPARAM)i,0))
		{
			SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_GETTEXT,(WPARAM)i,(LPARAM)buf);

			if (iArrayElem==0)
				strFlags += buf;
			else
				strFlags += CStr(" ") + buf;

			iArrayElem++;
		}
	}

	strFlags += "]";

	if (strFlags.Length()==2)
	{
		strFlags = "";
		return;
	}

	// If there's only one element within the array
	// We can just specify that one element for efficiency
	if (iArrayElem == 1)
	{
		strFlags = ReplaceStr(strFlags,"[","");
		strFlags = ReplaceStr(strFlags,"]","");
	}
}

void FlagSelectDlg::AddFlag(char* flag)
{ FUNC_ENTER("FlagSelectDlg::AddFlag"); 
	listFlags.Add(&CStr(flag));
	SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_ADDSTRING,0,(LPARAM)flag);
}

void FlagSelectDlg::SetFlags(CStr flags)
{ FUNC_ENTER("FlagSelectDlg::SetFlags"); 
	strFlags = flags;
}

void FlagSelectDlg::ParseSelectedFlags()
{ FUNC_ENTER("FlagSelectDlg::ParseSelectedFlags"); 
	// Parse the flag string array to select the flags in the list
	char* pos = strstr(strFlags,"[");
	char* end = strstr(strFlags,"]");

	if (!pos || !end)
	{
		if (strFlags.Length() == 0)
			return;

		// This is a one element flag
		int index = SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_FINDSTRING,(WPARAM)-1,(LPARAM)(char*)strFlags);
		
		if (index != LB_ERR)
			SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_SETSEL,(WPARAM)TRUE,(LPARAM)index);

		return;
	}

	// Clear the current selection set
	SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_SETSEL,(WPARAM)FALSE,(LPARAM)-1);

	pos++;
	char chr[2];
	chr[1] = 0;
	CStr strFlag;

	while(*pos != ']' && pos != end)
	{
		if (*pos == ' ' && !LineContainsAll(strFlag,' '))
		{
			StripToken(strFlag);
			int index = SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_FINDSTRING,(WPARAM)-1,(LPARAM)(char*)strFlag);

			if (index != LB_ERR)
				SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_SETSEL,(WPARAM)TRUE,(LPARAM)index);

			strFlag = "";
			pos++;
			continue;
		}

		chr[0] = *pos;
		strFlag += chr;
		pos++;
	}

	// Process last flag
	if (strFlag.Length()>0 && !LineContainsAll(strFlag,' '))
	{
		StripToken(strFlag);
		int index = SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_FINDSTRING,(WPARAM)-1,(LPARAM)(char*)strFlag);
		SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_SETSEL,(WPARAM)TRUE,(LPARAM)index);
	}
}

void FlagSelectDlg::Reset()
{ FUNC_ENTER("FlagSelectDlg::Reset"); 
	SendDlgItemMessage(hwnd,IDC_FLAGLIST,LB_RESETCONTENT,0,0);
	strFlags = "";
}

///////////////////// FlagSelect
FlagSelect::FlagSelect(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("FlagSelect::FlagSelect"); 
	flagSelectDlg = NULL;
}

FlagSelect::~FlagSelect()
{ FUNC_ENTER("FlagSelect::~FlagSelect"); 

}

FlagSelect::FlagSelect(FlagSelect& right) :
	UIControl(right.hInstance, CLASS)
{ FUNC_ENTER("FlagSelect::FlagSelect"); 
	strValue  = right.strValue;
	listFlags = right.listFlags;
	
	hwndButton = NULL;
	flagSelectDlg = NULL;
}

FlagSelect& FlagSelect::operator = (FlagSelect& right)
{ FUNC_ENTER("FlagSelect::operator="); 
	strValue  = right.strValue;
	listFlags = right.listFlags;
	
	hwndButton = NULL;
	flagSelectDlg = NULL;

	return *this;
}


LRESULT FlagSelect::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("FlagSelect::WndProc"); 
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			OpenFlagBrowser();
			return TRUE;
		}
		break;
	}

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void FlagSelect::BuildControlUI()
{ FUNC_ENTER("FlagSelect::BuildControlUI"); 
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	hwndButton = CreateWindow("button",
		                      "",
							  WS_CHILD|WS_VISIBLE,
							  0,
							  0,
							  wndRect.right - wndRect.left,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTON,
							  hInstance,
							  NULL);

	if (flagSelectDlg)
		delete flagSelectDlg;

	flagSelectDlg = new FlagSelectDlg(hInstance,hwnd);

	// Add flags to list
	Link<CStr>* curflag = listFlags.GetHead();

	while(curflag)
	{
		flagSelectDlg->AddFlag(curflag->data);
		curflag = curflag->next;
	}
}

void FlagSelect::OpenFlagBrowser()
{ FUNC_ENTER("FlagSelect::OpenFlagBrowser"); 
	flagSelectDlg->SetFlags(strValue);
	flagSelectDlg->Show();

	strValue = flagSelectDlg->GetFlags();
	SetWindowText(hwndButton,(char*)strValue);

	HWND hwndParent = GetParent(hwnd);
	int  ID         = GetWindowLong(hwnd,GWL_ID);

	SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
}

CStr FlagSelect::GetValue()
{ FUNC_ENTER("FlagSelect::GetValue"); 
	return strValue;
}

void FlagSelect::SetValue(char* val)
{ FUNC_ENTER("FlagSelect::SetValue"); 
	if (flagSelectDlg)
		flagSelectDlg->SetFlags(CStr(val));

	strValue = val;

	SetWindowText(hwndButton,val);
}

void FlagSelect::AddItem(char* val)
{ FUNC_ENTER("FlagSelect::AddItem"); 
	if (flagSelectDlg)
		flagSelectDlg->AddFlag(val);
	else
	{
		listFlags.Add(&CStr(val));
	}
}
