/*
	ColorPopup.h
	Color popup control for manipulating a group of colors
*/

#ifndef __COLORPOPUP__
#define __COLORPOPUP__

#include "UIControl.h"
#include "MSWindow.h"
#include "max.h"
#define CLASSNAME_COLORPOPUP  "ColorPopup"

class PropList;
class SliderNum;

class ColorPopupDlg: public MSDlgWindow
{
	friend class ColorPopup;

	HWND      hwndPlist;		// Window that contains the property list
	PropList* plist;

	BOOL DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	static void PropApplyCB(PropList* plist,void* pData);
	static void PropChangeCB(PropList* plist, void* pData);

public:
	ColorPopupDlg(HINSTANCE hInstance, HWND hwndParent);
	~ColorPopupDlg();

	void SetPos(int x, int y);
};

class ColorPopup: public UIControl
{
	HWND           hwndButton;
	HWND           hwndSliderNum;
	ColorPopupDlg* plistDlg;
	SliderNum*     pSliderNum;
	int            numColors;
	CStr           value;
	int            min,max;			// Limits on number of colors

	//void Init(bool bKeepPos=false);
	CStr BuildValue(PropList* plist);

	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	static void PropChangeCB(PropList* plist,void* pData);

public:
	CLASSNAME(CLASSNAME_COLORPOPUP)

	ColorPopup(HINSTANCE hInstance);
	ColorPopup(HINSTANCE hInstance, HWND hwnd);
	ColorPopup(ColorPopup& cpopup);
	~ColorPopup();

	ColorPopup& operator = (ColorPopup& right);

	void BuildControlUI();
	void ProcButton();

	void SetLimits(int min,int max);

	CStr GetValue();
	void SetValue(CStr val);
};

#endif
