#include "FuncEnter.h"

/*	
	ColorPopup.cpp
	Color popup control for manipulating a group of colors
*/

#include "ColorPopup.h"
#include "PropList.h"
#include "../PropEdit/ParseFuncs.h"
#include "../resource.h"
#include "../UI/SlideNum.h"

#define CUSTIDC_BUTTON      1
#define CUSTIDC_SLIDERNUM   2

#define DEFAULT_NUM_COLORS  4

ColorPopupDlg::ColorPopupDlg(HINSTANCE hInstance, HWND hwndParent) :
	MSDlgWindow(hInstance, MAKEINTRESOURCE(IDD_COLORLIST), hwndParent)
{ FUNC_ENTER("ColorPopupDlg::ColorPopupDlg"); 
	hwndPlist = GetDlgItem(hwnd,IDC_PLIST);

	plist = new PropList(hInstance);
	plist->HasApply(TRUE);
	plist->SetChangeCB(PropChangeCB,this);
	plist->SetApplyCB(PropApplyCB,this);
	plist->Attach(hwndPlist);
	Hide();
}

ColorPopupDlg::~ColorPopupDlg()
{ FUNC_ENTER("ColorPopupDlg::~ColorPopupDlg"); 
	if (plist)
		delete plist;
}

void ColorPopupDlg::PropChangeCB(PropList* plist, void* pData)
{ FUNC_ENTER("ColorPopupDlg::PropChangeCB"); 
	ColorPopupDlg* pthis = (ColorPopupDlg*)pData;
	CStr propVal;

	SendMessage(GetParent(pthis->hwnd),WM_CHILDUPDATED,0,0);
}

void ColorPopupDlg::PropApplyCB(PropList* plist, void* pData)
{ FUNC_ENTER("ColorPopupDlg::PropApplyCB"); 
	ColorPopupDlg* pthis = (ColorPopupDlg*)pData;
	CStr propVal;

	SendMessage(GetParent(pthis->hwnd),WM_CHILDUPDATED,0,0);
	pthis->Hide();
}

BOOL ColorPopupDlg::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ FUNC_ENTER("ColorPopupDlg::DlgProc"); 
	/*
	switch(msg)
	{
	// Hide the window if it loses focus
	case WM_KILLFOCUS:
		//Hide();

		return TRUE;
	}
	*/

	return FALSE;
}

void ColorPopupDlg::SetPos(int x, int y)
{ FUNC_ENTER("ColorPopupDlg::SetPos"); 
	RECT winRect;
	GetWindowRect(hwnd,&winRect);

	int width  = winRect.right - winRect.left;
	int height = winRect.bottom - winRect.top;

	MoveWindow(hwnd,x,y,width,height,TRUE);
}

//////////////////////////////////////////////////////////////////////////////////////

ColorPopup::ColorPopup(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("ColorPopup::ColorPopup"); 
	numColors = DEFAULT_NUM_COLORS;
	plistDlg = NULL;
	pSliderNum = NULL;
}

ColorPopup::ColorPopup(ColorPopup& right) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("ColorPopup::ColorPopup"); 
	numColors = right.numColors;
	min       = right.min;
	max       = right.max;
	value     = right.value;
}

ColorPopup::ColorPopup(HINSTANCE hInstance, HWND hwnd) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("ColorPopup::ColorPopup"); 
	numColors = DEFAULT_NUM_COLORS;
	plistDlg = NULL;
	pSliderNum = NULL;
}

ColorPopup::~ColorPopup()
{ FUNC_ENTER("ColorPopup::~ColorPopup"); 
	if (plistDlg)
	{
		delete plistDlg;
		plistDlg = NULL;
	}

	//if (hwndButton)
	//	DestroyWindow(hwndButton);
}

ColorPopup& ColorPopup::operator = (ColorPopup& right)
{ FUNC_ENTER("ColorPopup::operator="); 
	numColors = right.numColors;
	min       = right.min;
	max       = right.max;
	value     = right.value;

	return *this;
}

/*
void ColorPopup::Init(bool bKeepPos)
{
	POINT pt;
	GetCursorPos(&pt);

	if (plist)
		delete plist;

	if (bKeepPos)
	{
		pt.x = plist->GetX();
		pt.y = plist->GetY();
	}

	plist = new PropList(hInstance,hwndButton,pt.x,pt.y);

	plist->SetChangeCB(PropChangeCB,this);
	plist->SetApplyCB(PropApplyCB,this);

	if (value.Length() == 0)
	{
		plist->AddSliderNum("NumColors",min,max,"Selects the number of color fields in the color list");

		if (numColors == -1)
			numColors = DEFAULT_NUM_COLORS;

		char buf[256];
		_itoa(numColors,buf,10);
		plist->SetValue(0,buf);

		for(int i = 0; i < numColors;i++)
		{
			char bufColorName[256];
			char bufAlphaName[256];
			sprintf(bufColorName,"Color%i",i);
			sprintf(bufAlphaName,"Alpha%i",i);
			plist->AddColor(bufColorName);
			plist->AddSliderNum(bufAlphaName,0,255);
		}

		plist->BuildUI();
	}

	plist->Show();
}
*/

LRESULT ColorPopup::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("ColorPopup::WndProc"); 
	switch(msg)
	{
	case WM_CREATE:

		return TRUE;

	case WM_DESTROY:
		if (plistDlg)
		{
			delete plistDlg;
			plistDlg = NULL;
		}

		return TRUE;

	case WM_CHILDUPDATED:
		if (plistDlg)
			value = BuildValue(plistDlg->plist);
		else
			value = BuildValue(NULL);

		SendMessage(GetParent(hwnd),WM_CHILDUPDATED,GetWindowLong(hwnd,GWL_ID),0);

		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			ProcButton();
			return TRUE;
		}
	}

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void ColorPopup::BuildControlUI()
{ FUNC_ENTER("ColorPopup::BuildControlUI"); 
	RECT winRect;
	GetWindowRect(hwnd,&winRect);

	int width  = winRect.right - winRect.left;
	int height = winRect.bottom - winRect.top;

	REGISTERCLASS(SliderNum,hInstance);

	hwndSliderNum = CreateWindow(SLIDENUM_CLASSNAME,
		                         "",
								 WS_CHILD|WS_VISIBLE,
								 0,0,
								 width - 10,
								 height,
								 hwnd,
								 (HMENU)CUSTIDC_SLIDERNUM,
								 hInstance,
								 NULL);

	hwndButton = CreateWindow("button",
		                      "C",
							  WS_CHILD|WS_VISIBLE,
							  width - 10, 0,
							  10,
							  height,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTON,
							  hInstance,
							  NULL);

	if (plistDlg)
		delete plistDlg;

	if (pSliderNum)
		delete pSliderNum;

	pSliderNum = new SliderNum(hInstance);
	pSliderNum->Attach(hwndSliderNum);
	pSliderNum->SetLimits(min,max);

	plistDlg = new ColorPopupDlg(hInstance, hwndButton);
}

/*
void ColorPopup::SetValue(CStr val)
{
	value = val;

	if (!plist)
		return;

	if (val.Length() == 0)
	{
		plist->Clear();
		return;
	}

	numColors = CountChar(val,'/') + 1;

	plist->Clear();
	plist->AddSliderNum("NumColors",min,max,"Selects the number of color fields in the color list");
	
	char buf[256];
	_itoa(numColors,buf,10);
	plist->SetValue(0,buf);

	for(int i = 0;i < numColors; i++)
	{
		char buf[512];
		char bufColor[256];
		char bufAlpha[256];
		int  index;

		GetOption(val,buf,'/',i);
		GetOption(buf,bufColor,'@',0);
		GetOption(buf,bufAlpha,'@',1);

		char bufColorName[256];
		char bufAlphaName[256];
		sprintf(bufColorName,"Color%i",i);
		sprintf(bufAlphaName,"Alpha%i",i);
		
		plist->AddColor(bufColorName);
		index = plist->GetCurIndex();
		plist->SetValue(index,bufColor);

		plist->AddSliderNum(bufAlphaName,0,255);
		index = plist->GetCurIndex();
		plist->SetValue(index,bufAlpha);
	}

	value = val;

	plist->BuildUI();
}
*/

void ColorPopup::SetValue(CStr val)
{ FUNC_ENTER("ColorPopup::SetValue"); 
	value = val;

	if (pSliderNum)
		pSliderNum->SetValue(CountChar(val,'@'));
}

/*
CStr ColorPopup::GetValue()
{
	CStr propVal;

	if (!plist)
		return value;
	
	plist->GetValue(0,propVal);
	
	numColors = atoi(propVal);
	value = "";

	for(int i = 0;i < numColors; i++)
	{
		CStr strColor, strAlpha;

		plist->GetValue(i * 2 + 1, strColor);
		plist->GetValue(i * 2 + 2, strAlpha);

		if (i > 0)
			value += CStr("/");

		value += strColor + CStr("@") + strAlpha;
	}

	return value;
}
*/

CStr ColorPopup::BuildValue(PropList* plist)
{ FUNC_ENTER("ColorPopup::BuildValue"); 
	CStr val;
	int  maxColors;

	if (plist)
		maxColors = plist->NumProps() / 2;
	else
		maxColors = 0;
	
	numColors = pSliderNum->GetValue();

	// Now that we've retrieved the number of colors translate the proplist colors
	if (numColors == 0)
		return CStr("");
	
	for(int i = 0;i < numColors; i++)
	{
		CStr strColor, strAlpha;

		if (i > maxColors - 1)
		{
			strColor = "[0,0,0]";
			strAlpha = "0";
		}
		else
		{
			plist->GetValue(i * 2, strColor);
			plist->GetValue(i * 2 + 1, strAlpha);
		}

		if (i > 0)
			val += CStr("/");

		val += strColor + CStr("@") + strAlpha;
	}

	return val;
}

CStr ColorPopup::GetValue()
{ FUNC_ENTER("ColorPopup::GetValue"); 
	return value;
}

void ColorPopup::SetLimits(int min,int max)
{ FUNC_ENTER("ColorPopup::SetLimits"); 
	this->min = min;
	this->max = max;
}

void ColorPopup::PropChangeCB(PropList* plist, void* pData)
{ FUNC_ENTER("ColorPopup::PropChangeCB"); 
	ColorPopup* pthis = (ColorPopup*)pData;
	CStr propVal;

	pthis->value = pthis->BuildValue(plist);
	SendMessage(GetParent(pthis->hwnd),WM_CHILDUPDATED,GetWindowLong(pthis->hwnd,GWL_ID),0);
}

void ColorPopup::ProcButton()
{ FUNC_ENTER("ColorPopup::ProcButton"); 
	POINT pt;

	GetCursorPos(&pt);

	if (!plistDlg)
		return;

	numColors = pSliderNum->GetValue();
	plistDlg->SetPos(pt.x,pt.y);

	plistDlg->plist->Clear();

	// Convert the current value into the appropriate property list fields
	if (value.Length() == 0)
	{
		for(int i = 0; i < numColors;i++)
		{
			char bufColorName[256];
			char bufAlphaName[256];
			sprintf(bufColorName,"Color%i",i);
			sprintf(bufAlphaName,"Alpha%i",i);
			plistDlg->plist->AddColor(bufColorName);
			plistDlg->plist->AddSliderNum(bufAlphaName,0,255);
		}
	}
	else
	{
		numColors = CountChar(value,'@');

		if (numColors == 0)
			return;

		plistDlg->plist->Clear();
		
		for(int i = 0;i < numColors; i++)
		{
			char buf[512];
			char bufColor[256];
			char bufAlpha[256];
			int  index;

			GetOption(value,buf,'/',i);
			GetOption(buf,bufColor,'@',0);
			GetOption(buf,bufAlpha,'@',1);

			char bufColorName[256];
			char bufAlphaName[256];
			sprintf(bufColorName,"Color%i",i);
			sprintf(bufAlphaName,"Alpha%i",i);
			
			plistDlg->plist->AddColor(bufColorName);
			index = plistDlg->plist->GetCurIndex();
			plistDlg->plist->SetValue(index,bufColor);

			plistDlg->plist->AddSliderNum(bufAlphaName,0,255);
			index = plistDlg->plist->GetCurIndex();
			plistDlg->plist->SetValue(index,bufAlpha);
		}
	}

	plistDlg->plist->BuildUI();
	plistDlg->plist->SetChangeCB(PropChangeCB,this);

	if (!IsWindowVisible(plistDlg->hWnd()))
	{
		plistDlg->Show();
		plistDlg->SetPos(pt.x,pt.y);
	}

	//PropList(HINSTANCE hInstance,HWND hwdParent=0,int x=0,int y=0,int width=300,int height=263,CStr DlgText="");
	//plist->BuildUI();
	//plist->Show();
}
