// NExtTexture.h: Neversoft Extensions Texture
//
//////////////////////////////////////////////////////////////////////

#ifndef __TEXTURE_NEXTTEXTURE_H__
#define __TEXTURE_NEXTTEXTURE_H__

#define NEXT_TEXTURE_CLASS_ID	Class_ID(0x24917044, 0x16692a2a)

#define vMAX_NUM_MIP_LEVELS	6

enum
{
	vMIP_TYPE_NONE,
	vMIP_TYPE_AUTO,
	vMIP_TYPE_MANUAL,
};

enum
{
	vCROP,
	vPLACE,
	vNONE,
};

class INExtTexture
{
public:	
	virtual bool	ShouldCompress( int platform ) = 0;
	virtual void    SetShouldCompress( int platform, bool bMode ) = 0;

	virtual	int		GetMipType( int platform ) = 0;	
	virtual void    SetMipType( int platform, int mipType ) = 0;

	virtual bool	UsePS2Mips( int platform ) = 0;
	virtual void    SetUsePS2Mips( int platform, bool bMode ) = 0;

	virtual	int		GetMinFilterMode( void ) = 0;
	virtual void    SetMinFilterMode( int filterMode ) = 0;

	virtual	int		GetMagFilterMode( void ) = 0;
	virtual void    SetMagFilterMode( int filterMode ) = 0;

	virtual int		GetMipFilterMode( void ) = 0;
	virtual void    SetMipFilterMode( int filterMode ) = 0;

	virtual int		GetAddressModeU( void ) = 0;
	virtual int		GetAddressModeV( void ) = 0;

	virtual BitmapInfo*	GetBaseMap( int platform, bool allow_mips = true ) = 0;
	//virtual void        SetBaseMap( int platform, char* filename = NULL ) = 0;
	virtual bool        SetBaseMap( int platform, BitmapInfo* bmi = NULL ) = 0;

	virtual BitmapInfo* GetActualBaseMap( int platform ) = 0;
	
	virtual	BitmapInfo*	GetMipMap( int platform, int level ) = 0;
	//virtual void        SetMipMap( int platform, int level, char* filename = NULL ) = 0;
	//virtual bool        SetMipMap( int platform, int level, BitmapInfo* bmi = NULL ) = 0;

	virtual bool	BaseMapDefined( int platform ) = 0;
	virtual void    AssignOverrideTexName( int platform, TSTR name ) = 0;	// aml
	virtual int		GetNumMipLevels( int platform ) = 0;
	
	virtual bool	ChangeTransColor( void ) = 0;
	virtual void    SetChangeTransColor( bool bMode ) = 0;
	
	virtual Color	GetTransColor( void ) = 0;
	virtual void    SetTransColor( Color color ) = 0;

	virtual float	GetMipMapK( void ) = 0;
	virtual void    SetMipMapK( float fVal ) = 0;

	virtual bool	Force24BitPalette( void ) = 0;
	virtual void    SetForce24BitPalette( bool bMode ) = 0;

	virtual BOOL    UseBasePal( int platform, int level ) = 0;		// aml
	virtual void    SetUseBasePal( int platform, int level, bool bMode ) = 0;

	virtual bool	GetCropPlaceApply() = 0;
	virtual void	SetCropPlaceApply( bool bMode ) = 0;

	virtual float   GetCropPlaceU() = 0;
	virtual void    SetCropPlaceU( float fVal ) = 0;

	virtual float   GetCropPlaceV() = 0;
	virtual void    SetCropPlaceV( float fVal ) = 0;

	virtual float   GetCropPlaceW() = 0;
	virtual void    SetCropPlaceW( float fVal ) = 0;

	virtual float   GetCropPlaceH() = 0;
	virtual void    SetCropPlaceH( float fVal ) = 0;

	virtual int     GetCropPlaceMode() = 0;
	virtual void    SetCropPlaceMode( int iMode ) = 0;

	virtual BitmapInfo* GetManualMap(int plat, int mip) = 0;
	//virtual void        SetManualMap(int plat, int mip, char* filename = NULL) = 0;
	virtual bool        SetManualMap(int plat, int mip, BitmapInfo* bmi = NULL) = 0;
};
#endif // __TEXTURE_NEXTTEXTURE_H__
