/*
	BMTex.h
	Bitmapped Texture
	This class was previously local (implementation-side)
	I've expanded it out since ViewportTexture must derive from it, and I'd rather not cluter NExtTexture.cpp
	any more than it already is.
*/

#ifndef __BMTEX__
#define __BMTEX__

#include "../Next.h"
#include "../Export/Export.h"
#include "../Texture/NExtTexture.h"
#include <stdmat.h>
#include <bmmlib.h>
#include <texutil.h>
#include <iparamm2.h>
#include <macrorec.h>
#include <notify.h>

#define MAP_IS_GENERATED  (1 << 20)	// A bitmap info flag to indicate a generated texture
									// This flag is not defined by MAX and should not be
									// being used for anything else in BitmapInfo

class BMTex;
class BMTexDlg;

enum 
{ 
	bmtex_bitmap_ps2,
	bmtex_bitmap_ngc,
	bmtex_bitmap_xbox,
	bmtex_bitmap_filter_mode_min,
	bmtex_bitmap_filter_mode_mag,
	bmtex_bitmap_mip_filter_mode,
	bmtex_bitmap_mip_map_k,
	
	bmtex_bitmap_mip_1_ps2,
	bmtex_bitmap_mip_2_ps2,
	bmtex_bitmap_mip_3_ps2,
	bmtex_bitmap_mip_4_ps2,
	bmtex_bitmap_mip_5_ps2,

	bmtex_bitmap_mip_1_ngc,
	bmtex_bitmap_mip_2_ngc,
	bmtex_bitmap_mip_3_ngc,
	bmtex_bitmap_mip_4_ngc,
	bmtex_bitmap_mip_5_ngc,

	bmtex_bitmap_mip_1_xbox,
	bmtex_bitmap_mip_2_xbox,
	bmtex_bitmap_mip_3_xbox,
	bmtex_bitmap_mip_4_xbox,
	bmtex_bitmap_mip_5_xbox,

	bmtex_bitmap_mip_xbox,
	bmtex_bitmap_mip_ps2,
	bmtex_bitmap_mip_ngc,	
	
	bmtex_bitmap_use_ps2_mips_ngc,
	bmtex_bitmap_use_ps2_mips_xbox,

	bmtex_bitmap_compress_ngc,
	bmtex_bitmap_compress_xbox,

	bmtex_bitmap_truecolor_palette,
	
	bmtex_bitmap_change_trans_color,
	bmtex_bitmap_change_trans,
	

	bmtex_coords,	 // access for UVW mapping
	bmtex_output,	 //output window
	bmtex_filename,  // bitmap filename virtual parameter, JBW 2/23/99

	// Has to go later because old version didn't contain it so the internal
	// pblock2 versioning system gets confused with old versions since the IDs
	// would be out of sync
	bmtex_bitmap_mip_1_ps2_pal,
	bmtex_bitmap_mip_2_ps2_pal,
	bmtex_bitmap_mip_3_ps2_pal,
	bmtex_bitmap_mip_4_ps2_pal,
	bmtex_bitmap_mip_5_ps2_pal,

	bmtex_bitmap_mip_1_ngc_pal,
	bmtex_bitmap_mip_2_ngc_pal,
	bmtex_bitmap_mip_3_ngc_pal,
	bmtex_bitmap_mip_4_ngc_pal,
	bmtex_bitmap_mip_5_ngc_pal,

	bmtex_bitmap_mip_1_xbox_pal,
	bmtex_bitmap_mip_2_xbox_pal,
	bmtex_bitmap_mip_3_xbox_pal,
	bmtex_bitmap_mip_4_xbox_pal,
	bmtex_bitmap_mip_5_xbox_pal,

	bmcp_clipu,
	bmcp_clipv,
	dummy,
	bmcp_clipw,
	bmcp_cliph,
	bmcp_apply,
	bmcp_crop_place,
};


//------------------------------------------------------------------------
// BMSampler
//------------------------------------------------------------------------

class BMSampler: public MapSampler {
	Bitmap *bm;
	BMTex *tex;
	int alphaSource;
	float u0,v0,u1,v1,ufac,vfac,ujit,vjit;
	int bmw,bmh,clipx, clipy, cliph;
	float fclipw,fcliph, fbmh, fbmw;
	public:
		BMSampler() { bm = NULL; ufac = vfac = 0.0f; }
		void Init(BMTex *bmt);
		int PlaceUV(ShadeContext& sc, float &u, float &v, int iu, int iv);
		void PlaceUVFilter(ShadeContext& sc, float &u, float &v, int iu, int iv);
		AColor Sample(ShadeContext& sc, float u,float v);
		AColor SampleFilter(ShadeContext& sc, float u,float v, float du, float dv);
//		float SampleMono(ShadeContext& sc, float u,float v);
//		float SampleMonoFilter(ShadeContext& sc, float u,float v, float du, float dv);
	} ;

//------------------------------------------------------------------------
// BM\AlphaSampler
//------------------------------------------------------------------------
class BMAlphaSampler: public MapSampler {
	Bitmap *bm;
	BMTex *tex;
	float u0,v0,u1,v1,ufac,vfac,ujit,vjit;
	int bmw,bmh,clipx, clipy, cliph;
	float fclipw,fcliph, fbmh, fbmw;
	public:
		BMAlphaSampler() { bm = NULL; ufac = vfac = fbmw = fbmh = 0.0f; }
		void Init(BMTex *bmt);
		int PlaceUV(ShadeContext &sc, float &u, float &v, int iu, int iv);
		void  PlaceUVFilter(ShadeContext &sc, float &u, float &v, int iu, int iv);
		AColor Sample(ShadeContext& sc, float u,float v) { return AColor(0,0,0,0);}
		AColor SampleFilter(ShadeContext& sc, float u,float v, float du, float dv) { return AColor(0,0,0,0);}
		float SampleMono(ShadeContext& sc, float u,float v);
		float SampleMonoFilter(ShadeContext& sc, float u,float v, float du, float dv);
	} ;



//------------------------------------------------------------------------
// BMCropper
//------------------------------------------------------------------------
class BMCropper:public CropCallback {
	BMTexDlg *dlg;
	BMTex *tex;
	BOOL mode;
	float u0,v0,w0,h0;
	public:
	float GetInitU() { return u0; }
	float GetInitV() { return v0; }
	float GetInitW() { return w0; }
	float GetInitH() { return h0; }
	BOOL GetInitMode() { return mode; }
	void SetValues(float u, float v, float w, float h, BOOL md);
	void OnClose();
	void Init(BMTexDlg *tx, TimeValue t);
	};

//------------------------------------------------------------------------
// BMTexDlg
//------------------------------------------------------------------------

//class BMTexDlg: public ParamDlg , public DADMgr{
class BMTexDlg: public ParamMap2UserDlgProc , public DADMgr{
	friend class BMCropper;
	public:
		HWND hwmedit;	 // window handle of the materials editor dialog
		IMtlParams *ip;
		BMTex *theBMTex;	 // current BMTex being edited.
		HWND hPanel; // Rollup pane
//		HWND hTime; // Time Rollup pane
		TimeValue curTime; 
//		ICustButton *iName;
		BOOL valid;
		BOOL isActive;
		BOOL cropping;
		BMCropper cropper;

		//-----------------------------
		BMTexDlg(HWND hwMtlEdit, IMtlParams *imp, BMTex *m); 
		~BMTexDlg();

		// inherited from ParamMap2UserDlgProc
		void Update(TimeValue t);
		BOOL DlgProc(TimeValue t,IParamMap2 *map,HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);		

//		BOOL PanelProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );
		BOOL TimeProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );
		void HandleNameButton();
		void LoadDialog(BOOL draw);  // stuff params into dialog
		void ReloadDialog();
		void BMNameChanged();
		void UpdateMtlDisplay() { ip->MtlChanged(); }
		void ActivateDlg(BOOL onOff) {}
		void StuffBMNameField(HWND hwndDlg);
		void EnableAlphaButtons(BOOL isNew=FALSE);
		void EnableViewImage();
		void Invalidate() { valid = FALSE;	InvalidateRect(hPanel,NULL,0); }
		BOOL KeyAtCurTime(int id);
		void ShowCropImage();
		void RemoveCropImage();

		// methods inherited from ParamDlg:
		virtual Class_ID ClassID() {return NEXT_TEXTURE_CLASS_ID;  }
		void SetThing(ReferenceTarget *m);
		ReferenceTarget* GetThing() { return (ReferenceTarget *)theBMTex; }
		void DeleteThis() { delete this;  }	


		// DADMgr methods
		// called on the draggee to see what if anything can be dragged from this x,y
		SClass_ID GetDragType(HWND hwnd, POINT p) { return BITMAPDAD_CLASS_ID; }
		// called on potential dropee to see if can drop type at this x,y
		BOOL OkToDrop(ReferenceTarget *dropThis, HWND hfrom, HWND hto, POINT p, SClass_ID type, BOOL isNew) {
			if (hfrom==hto) return FALSE;
			return (type==BITMAPDAD_CLASS_ID)?1:0;
			}
		int SlotOwner() { return OWNER_MTL_TEX;	}
	    ReferenceTarget *GetInstance(HWND hwnd, POINT p, SClass_ID type);
		void Drop(ReferenceTarget *dropThis, HWND hwnd, POINT p, SClass_ID type);
		BOOL  LetMeHandleLocalDAD() { return 0; } 

	};

class BMTexNotify: public BitmapNotify {
	public:
	BMTex *tex;
	void SetTex(BMTex *tx) { tex  = tx; }
	int Changed(ULONG flags);
	};

class BMTexPostLoad;

//--------------------------------------------------------------
// BMTex: A 2D texture map
//--------------------------------------------------------------

class BMTex: public BitmapTex, public INExtTexture {
	friend class BMTexPostLoad;
	friend class BMTexDlg;
	friend class BMTexDlgProc;
	friend class BMSampler;
	friend class BMAlphaSampler;
	friend class BMCropper;

	static ParamDlg* uvGenDlg;	
	//static ParamDlg* texoutDlg;

	TextureOutput *texout; // ref #2

	BMTexNotify bmNotify;
	Interval ivalid;
	BMSampler mysamp;
	BMAlphaSampler alphasamp;
	bool	m_updated;
	BitmapInfo biTexName[vNUM_PLATFORMS - 1];		// fake BitmapInfo structure
													// that doesn't relate directly to a MAX maintained bitmap
													// We override and fill in our own name on this to maintain
													// compat w/ current system

	BOOL useBasePal[vNUM_PLATFORMS][vMAX_NUM_MIP_LEVELS];

	protected:
		UVGen *uvGen;		   // ref #0
		TexHandle *texHandle;

	public:
		BOOL isParm2;

		float pbRate;
		TimeValue startTime;
		BOOL applyCrop;
		BOOL loading;
		BOOL loadingOld;
		BOOL placeImage;
		BOOL randPlace;
		BOOL fileNotFound;
		int filterType;
		int alphaSource;
		int rollScroll;
		int endCond;
		int alphaAsMono;
		int alphaAsRGB;
		float clipu, clipv, clipw, cliph, jitter;
		BOOL premultAlpha;
		BOOL isNew;
		BOOL loadFailed; 
		BOOL inRender;
		BOOL bmWasSet;
		int texTime;
		Interval texValid;
		Interval clipValid;
		float rumax,rumin,rvmax,rvmin;


		IParamBlock2 *pblock;   // ref #1
		static BMTexDlg *paramDlg;
		PBBitmap *bitmapPB;
		BitmapInfo bi;
		TSTR bmName; // for loading old files only
		Bitmap *thebm;

		BMTex();
		~BMTex();
		IMtlParams *ip;
		ParamDlg* CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp);
		void Update(TimeValue t, Interval& valid);
		void Init();
		void Reset();
		Interval Validity(TimeValue t) { Interval v; Update(t,v); return ivalid; }
		TSTR GetFullName();

		void SetOutputLevel(TimeValue t, float v) {texout->SetOutputLevel(t,v); }
		void SetFilterType(int ft);
		void SetAlphaSource(int as);
		void SetEndCondition(int endcond);
//		void SetEndCondition(int endcond) { 
//            #ifndef DESIGN_VER
//			pblockTime->SetValue( bmtex_endcondition, 0, endcond);		
//			endCond = endcond; 
//			ParamID changedParam = pblock->LastNotifyParamID();
//			bmtex_time_param_blk.InvalidateUI(changedParam);
//            #endif // DESIGN_VER
//			}
		void SetAlphaAsMono(BOOL onoff) { 
			//pblock->SetValue( bmtex_monooutput, 0, onoff);		
			alphaAsMono = onoff; 
			}
		void SetAlphaAsRGB(BOOL onoff) { 
			//pblock->SetValue( bmtex_rgboutput, 0, onoff);		
			alphaAsRGB = onoff; 
			}
		void SetPremultAlpha(BOOL onoff) { 
			onoff = onoff != 0;
			/*BOOL oldOnOff = pblock->GetInt( bmtex_premultalpha, 0 ) != 0;
			if ( onoff != oldOnOff )
				pblock->SetValue( bmtex_premultalpha, 0, onoff);		*/
			premultAlpha = onoff; 
			}
		void SetMapName(TCHAR *name) { 
			if (name) {
				bi.SetName(name); 
				PBBitmap bt(bi);
				pblock->SetValue(bmtex_bitmap_ps2, 0, &bt);
				fileNotFound = FALSE;
				if (TestMtlFlag(MTL_TEX_DISPLAY_ENABLED)) {
					if (ip)
						ip->MtlChanged();
					}
				}
			}
			void SetPlaybackRate(float r); 
			void SetStartTime(TimeValue t);

		void AssignOverrideTexName( int platform, TSTR name );

/****
		void SetStartTime(TimeValue t) {
            #ifndef DESIGN_VER
			pblockTime->SetValue( bmtex_start, 0, t);		
			startTime = t; 
            #endif // DESIGN_VER
			}
		void SetPlaybackRate(float r) { 
            #ifndef DESIGN_VER
			pblockTime->SetValue( bmtex_playbackrate, 0, r);		
			pbRate = r; 
            #endif // DESIGN_VER
			}
****/
		void SetClipU(TimeValue t, float f);
		void SetClipV(TimeValue t, float f) ;
		void SetClipW(TimeValue t, float f) ;
		void SetClipH(TimeValue t, float f) ;
		void SetJitter(TimeValue t, float f);

		int GetFilterType() { return filterType; }
		int GetAlphaSource() { return alphaSource; }
		int GetEndCondition() { return endCond; }
		BOOL GetAlphaAsMono(BOOL onoff) { return alphaAsMono; }
		BOOL GetAlphaAsRGB(BOOL onoff) { return alphaAsRGB; }
		BOOL GetPremultAlpha(BOOL onoff) { return premultAlpha; }
		TCHAR *GetMapName() {
			UpdateBIName(); // CCJ 4/27/99
			return (TCHAR *)bi.Name();
			}
		TimeValue GetStartTime() { return startTime; }
		float GetPlaybackRate() { return pbRate; }
		StdUVGen* GetUVGen() { return (StdUVGen*)uvGen; }
		TextureOutput* GetTexout() { return texout; }
		Bitmap *GetBitmap(TimeValue t) { LoadBitmap(t); 	return thebm; }
	    float GetClipU(TimeValue t) { 	
	    	return pblock->GetFloat( bmcp_clipu, t); 	
	    	}
	    float GetClipV(TimeValue t) { 							
	    	return pblock->GetFloat( bmcp_clipv, t); 
			}
	    float GetClipW(TimeValue t);// { 
			//return pblock->GetFloat( bmcp_clipw, t); 
			//}
	    float GetClipH(TimeValue t) { 
			return pblock->GetFloat( bmcp_cliph, t); 
			}
		void StuffCropValues(); // stuff new values into the cropping VFB
		void EnableStuff();
		void UpdateBIName() {
			pblock->GetValue( bmtex_bitmap_ps2, 0,bitmapPB, clipValid );
			if (bitmapPB != NULL)   
				bi = bitmapPB->bi;	  //DS 2/24/99
			else bi.SetName(_T(""));   // DS 3/23/99
			}

		void UpdtSampler() {
			mysamp.Init(this);
			alphasamp.Init(this);
			}

		void NotifyChanged();
		void FreeBitmap();
 		BMMRES LoadBitmap(TimeValue t, BOOL quiet=TRUE, BOOL reload=FALSE);
		int CalcFrame(TimeValue t);
		void ScaleBitmapBumpAmt(float f);
		void ReloadBitmap();
/*
		void UpdateTexture()
			{
			ReloadBitmap();
			NotifyChanged();
			if (ip != NULL)	ip->MtlChanged();
//			UpdateMtlDisplay(); // redraw viewports
//			return 1;
			}

*/
		// Evaluate the color of map for the context.
		RGBA EvalColor(ShadeContext& sc);
		float EvalMono(ShadeContext& sc);
		Point3 EvalNormalPerturb(ShadeContext& sc);

		void DiscardTexHandle();

		BOOL SupportTexDisplay() { return TRUE; }
		virtual void ActivateTexDisplay(BOOL onoff);
		virtual DWORD_PTR GetActiveTexHandle(TimeValue t, TexHandleMaker& thmaker);
		virtual BITMAPINFO* GetVPDisplayDIB(TimeValue t, TexHandleMaker& thmaker, Interval &valid, BOOL mono=FALSE, BOOL forceW=0, BOOL forceH=0);
		   
		void GetUVTransform(Matrix3 &uvtrans) { uvGen->GetUVTransform(uvtrans); }
		int GetTextureTiling() { return  uvGen->GetTextureTiling(); }
		int GetUVWSource() { return uvGen->GetUVWSource(); }
		int GetMapChannel () { return uvGen->GetMapChannel(); }
		UVGen *GetTheUVGen() { return uvGen; }
					
		int RenderBegin(TimeValue t, ULONG flags) {	
			inRender = TRUE;
			return 1; 	
			}
		int RenderEnd(TimeValue t) { 	
			inRender = FALSE;	
			return 1; 	
			}
		int LoadMapFiles(TimeValue t) {	LoadBitmap(t,1,1);	return 1;	}
		void RenderBitmap(TimeValue t, Bitmap *bm, float scale3D, BOOL filter);

		Class_ID ClassID() {	return NEXT_TEXTURE_CLASS_ID; }
		SClass_ID SuperClassID() { return TEXMAP_CLASS_ID; }
		void GetClassName(TSTR& s) { s= GetString(IDS_DS_BITMAP); }  
		void DeleteThis() { delete this; }	

		// Requirements
		ULONG LocalRequirements(int subMtlNum) {
			return uvGen->Requirements(subMtlNum)|MTLREQ_TRANSP; 
			}

		void LocalMappingsRequired(int subMtlNum, BitArray & mapreq, BitArray &bumpreq) {  
			uvGen->MappingsRequired(subMtlNum,mapreq,bumpreq); 
			}

		int NumSubs() { return 3; }  
		Animatable* SubAnim(int i);
		TSTR SubAnimName(int i);
		int SubNumToRefNum(int subNum) { return subNum; }
		void InitSlotType(int sType) { if (uvGen) uvGen->InitSlotType(sType); }

		// From ref
		int NumRefs() { return 3; }
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);
		int RemapRefOnLoad(int iref); 

		RefTargetHandle Clone(RemapDir &remap = NoRemap());
		RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message );

		// From Animatable
		void EnumAuxFiles(NameEnumCallback& nameEnum, DWORD flags);
		int SetProperty(ULONG id, void *data);
		void SetBitmap(Bitmap *bm);
		void FreeAllBitmaps() { 
			FreeBitmap(); 
			}

		// IO
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);

// JBW: direct ParamBlock access is added
		int	NumParamBlocks() { return 1; }					// return number of ParamBlocks in this instance

		IParamBlock2* GetParamBlock(int i) { 
										if (i == 0) return pblock; 
											else return NULL;			 } // return i'th ParamBlock
		IParamBlock2* GetParamBlockByID(BlockID id) 
													{if (pblock->ID() == id) return pblock ;													 
													else return  NULL; } // return id'd ParamBlock

//		{ return (pblock->ID() == id) ? pblock : NULL; } // return id'd ParamBlock
		BOOL SetDlgThing(ParamDlg* dlg);

//watje pops up a bitmap loader dlg
		void BitmapLoadDlg();
//watje forces the bitmap to reload and view to be redrawn
		void ReloadBitmapAndUpdate();

//watje
		BaseInterface* GetInterface(Interface_ID id) 
			{ 
			if (id == BITMAPTEX_INTERFACE) 
				return (BitmapTex*)this; 
			else 
				return FPMixinInterface::GetInterface(id);
			} 
		void	fnReload();
		void	fnViewImage();

		// From INExtTexture

public:

		bool	Force24BitPalette( void );
		void	SetForce24BitPalette( bool bMode );
		
		bool	ShouldCompress( int platform );
		void    SetShouldCompress( int platform, bool bMode );

		int		GetMipType( int platform );
		void	SetMipType( int platform, int mipType );

		bool	UsePS2Mips( int platform );
		void	SetUsePS2Mips( int platform, bool bMode );

		int		GetMinFilterMode( void );
		void	SetMinFilterMode( int filterMode );

		int		GetMagFilterMode( void );
		void    SetMagFilterMode( int filterMode );

		int		GetMipFilterMode( void );
		void	SetMipFilterMode( int filterMode );

		int		GetAddressModeU( void );
		int		GetAddressModeV( void );

		BitmapInfo*	GetBaseMap( int platform, bool allow_mips = true );
		//void		SetBaseMap( int platform, char* filename = NULL );
		bool		SetBaseMap( int platform, BitmapInfo* bmi = NULL );

		BitmapInfo* GetActualBaseMap( int platform );

		BitmapInfo*	GetMipMap( int platform, int level );
		//void		SetMipMap( int platform, int level, char* filename = NULL );
		//bool		SetMipMap( int platform, int level, BitmapInfo* bmi = NULL );

		bool	BaseMapDefined( int platform );
		int		GetNumMipLevels( int platform );
		
		float	GetMipMapK( void );
		void	SetMipMapK( float fVal );
		
		Color	GetTransColor( void );
		void	SetTransColor( Color color );

		bool	ChangeTransColor( void );
		void	SetChangeTransColor( bool bMode );

		BOOL    UseBasePal( int platform, int level );
		void	SetUseBasePal( int platform, int level, bool bMode );

		bool	GetCropPlaceApply();
		void    SetCropPlaceApply( bool bMode );

		float   GetCropPlaceU( void );
		void	SetCropPlaceU( float fVal );

		float   GetCropPlaceV( void );
		void	SetCropPlaceV( float fVal );

		float   GetCropPlaceW( void );
		void	SetCropPlaceW( float fVal );

		float   GetCropPlaceH( void );
		void	SetCropPlaceH( float fVal );

		int     GetCropPlaceMode( void );
		void	SetCropPlaceMode( int iMode );

		BitmapInfo* GetManualMap(int plat, int mip);
		//void	SetManualMap(int plat, int mip, char* filename = NULL);
		bool	SetManualMap(int plat, int mip, BitmapInfo* bmi = NULL);
		
		BOOL	m_Compress[ vNUM_PLATFORMS ];
		int		m_MipType[ vNUM_PLATFORMS ];
		BOOL	m_UsePS2Mips[ vNUM_PLATFORMS ];
		int		m_MinFilterMode;
		int		m_MagFilterMode;
		int		m_MipFilterMode;		
		BitmapInfo*	m_Bitmaps[ vNUM_PLATFORMS ][ vMAX_NUM_MIP_LEVELS ];
		float	m_MipMapK;
		BOOL	m_Force24Bit;
		BOOL	m_ChangeTrans;
		Color	m_TransColor;
		BOOL	m_MipOptionsEnabled;
	};

#endif
