#include "FuncEnter.h"

/*
	TestPlug.cpp

	Test plugin temp
	Adam Lippmann
*/


#include "TestPlug.h"
#include "Resource.h"
#include <stdio.h>

extern PropEditor* pPropEdit;

HINSTANCE hInstanceMax;

#define NumElements(array) (sizeof(array) / sizeof(array[0]))

static TestPlugClassDesc MyPlugDesc;
static TP_ActionCB       MyActionCB;
static TP_ActionCB*      accel=NULL;

ClassDesc2* GetTestPlugDesc() { FUNC_ENTER("GetTestPlugDesc");  return &MyPlugDesc; }

TestPlug::TestPlug()
{ FUNC_ENTER("TestPlug::TestPlug"); 
	ip=NULL;
	iu=NULL;
}

TestPlug::~TestPlug()
{ FUNC_ENTER("TestPlug::~TestPlug"); 

}

// action table
static ActionDescription s_test_actions[] = {

	ID_TEST_OPEN,
	IDS_TESTPLUG_TEST_DESC,
    IDS_TESTPLUG_TEST_DESC,
    IDS_TESTPLUG_ACTIONS,
	ID_TEST_LOD_OPEN,
	IDS_TESTPLUG_TEST_LOD_DESC,
	IDS_TESTPLUG_TEST_LOD_DESC,
	IDS_TESTPLUG_ACTIONS,
};


const ActionTableId test_actions = vTESTPLUG_SHORTCUT_ID;
const ActionContextId test_actions_context     = vTESTPLUG_SHORTCUT_ID;
const ActionContextId test_actions_lod_context = vTESTPLUG_LOD_SHORTCUT_ID;

ActionTable* GetTestActions( void )
{ FUNC_ENTER("GetTestActions"); 
    //TSTR name = GetString(IDS_LINK_ACTIONS);
	TSTR name = _T("Neversoft Property Editor");
    HACCEL hAccel = LoadAccelerators(hInstance,
                                     MAKEINTRESOURCE(IDR_TEST_ACCELERATOR));
    int numOps = NumElements( s_test_actions );
    ActionTable* pTab;
    pTab = new ActionTable( test_actions, test_actions_context, name, hAccel, numOps,
                             s_test_actions, hInstance);
    GetCOREInterface()->GetActionManager()->RegisterActionContext( test_actions_context, name.data());

    return pTab;
}

bool RegTestActionAccelerators()
{ FUNC_ENTER("RegTestActionAccelerators"); 
	accel=new TP_ActionCB;

	if (!GetCOREInterface()->GetActionManager()->ActivateActionTable(accel, test_actions))
	{
		MessageBox(NULL,"ActionTable Failed to instantiate","TestPlug",MB_OK);
		return false;
	}

	return true;
}

void UnRegTestActionAccelerators()
{ FUNC_ENTER("UnRegTestActionAccelerators"); 
	delete accel;
	accel=NULL;
}

BOOL TP_ActionCB::ExecuteAction(int id)
{ FUNC_ENTER("TP_ActionCB::ExecuteAction"); 
	//pPropEdit->ParseUserProps();
	//pPropEdit->SelectionSetChanged();
	switch(id)
	{
	case ID_TEST_OPEN:
		pPropEdit->Show();
		return TRUE;

	case ID_TEST_LOD_OPEN:
		pPropEdit->OpenLODBrowser();
		return TRUE;
	}
	
	/*
	char buf[256];
	sprintf(buf,"Shortcut ID %i\n",id);
	MessageBox(GetCOREInterface()->GetMAXHWnd(),buf,"PropEditor Shortcut",MB_OK);
	*/
	
	pPropEdit->Show();

	return TRUE;
}

BOOL TP_LODActionCB::ExecuteAction(int id)
{ FUNC_ENTER("TP_LODActionCB::ExecuteAction"); 
	pPropEdit->OpenLODBrowser();

	return TRUE;
}

BOOL TestPlug::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ FUNC_ENTER("TestPlug::DlgProc"); 
	return FALSE;
}

void TestPlug::BeginEditParams(Interface *ip, IUtil *iu)
{ FUNC_ENTER("TestPlug::BeginEditParams"); 
	// Store MAX's hInstance
	HWND hwndMAX=ip->GetMAXHWnd();
	hInstanceMax=(HINSTANCE)GetWindowLong(hwndMAX,GWL_HINSTANCE);

	this->ip=ip;
	this->iu=iu;

	//propedit=new PropEditor(hInstance,ip);

	// Remove later test for parsing code
	//propedit->ParseMapFile("c:\\ParseInfo\\qcomp.map");
	//pPropEdit->ParseUserProps();		// Removed:  TT10749: opening PropEd from utilities panel resets particles...
	//pPropEdit->SelectionSetChanged();
	pPropEdit->SetCloseNotify(CloseNotifyCB,this);
	pPropEdit->Show();
}

void TestPlug::EndEditParams(Interface *ip, IUtil *iu)
{ FUNC_ENTER("TestPlug::EndEditParams"); 
	pPropEdit->Hide();
	pPropEdit->SetCloseNotify(NULL,NULL);
}

void TestPlug::SelectionSetChanged(Interface *ip, IUtil *iu)
{ FUNC_ENTER("TestPlug::SelectionSetChanged"); 
	// Selection set changes are now handle through the property editor itself
	// via a NOTIFY_POST_EDIT_OBJ_CHANGE  NotificationCallback
	// so, we can have that control regardless of being a tool plugin or not
	//pPropEdit->SelectionSetChanged();
}

void TestPlug::CloseNotifyCB(PropEditor* pedit,void* pData)
{ FUNC_ENTER("TestPlug::CloseNotifyCB"); 
	TestPlug* pthis=(TestPlug*)pData;
	
	if (pthis && pthis->iu)
		pthis->iu->CloseUtility();

	EnableAccelerators();
}
