/*
	ScriptBrowse.h
	Script Browser/Categorizer Dialog

	Adam Lippmann
	12-21-01
*/

#ifndef __SCRIPTBROWSE__
#define __SCRIPTBROWSE__

#include "PropEdit.h"
#include "../UI/MSWindow.h"
#include "../UI/Treeview.h"

class PropEditor;

class AddNodeDlg: public MSDlgWindow
{
	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void(*fpCallback)(CStr,void*);	// function called when OK is pressed
	void* vpCallback;				// callback function data

public:
	CStr GetName();

	void SetCallback(void(*func)(CStr,void*),void* vpValue);

	AddNodeDlg(HINSTANCE hInstance,HWND hwndParent);
	~AddNodeDlg();
};

class ScriptBrowse: public MSDlgWindow
{
	PropEditor* pPropEdit;
	ToolTip     ttip;
	AddNodeDlg* pAddNodeDlg;
	TreeView*   tview;

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);


	static void AddToTreeCB(CStr,void* pThis);
	static void AddToTreeChildCB(CStr,void* pThis);

	void ListSelChange();
	void ProcessPattern(CStr strPattern);
	void GoToDefinition();
	void GetDescription();
	void AddNode();
	void AddChildNode();
	void InsertScript();
	void AddScripts();

public:
	ScriptBrowse(HINSTANCE hInstance,HWND hwndParent,PropEditor* pPropEdit);
	~ScriptBrowse();
};

#endif
