#include "FuncEnter.h"

/*
	ExtScript.cpp
	External Script Viewer
	1-28-01
*/

#include "ExtScript.h"
#include "Resource.h"

ExtScriptDlg::ExtScriptDlg(HINSTANCE hInstance,HWND hwndParent) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_EXTSCRIPT),hwndParent)
{ FUNC_ENTER("ExtScriptDlg::ExtScriptDlg"); 
	pRichText=new RichText(hInstance,GetDlgItem(hwnd,IDC_SCRIPTVIEW));
}

ExtScriptDlg::~ExtScriptDlg()
{ FUNC_ENTER("ExtScriptDlg::~ExtScriptDlg"); 
	if (pRichText)
		delete pRichText;
}

void ExtScriptDlg::SetTitle(CStr str)
{ FUNC_ENTER("ExtScriptDlg::SetTitle"); 
	char windowTitle[128];
	sprintf(windowTitle,"External Script - [File: %s]",(char*)str);
	SetWindowText(hwnd,windowTitle);
}

void ExtScriptDlg::Highlight(CStr keyword)
{ FUNC_ENTER("ExtScriptDlg::Highlight"); 
	// Find the definition of the script in the file
	CStr strSearch=CStr("Script ")+keyword;
	int  index=pRichText->Search(strSearch,RTS_WHOLEWORD);
	
	if (index!=-1)
		pRichText->HighlightLine(index);
}

BOOL ExtScriptDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("ExtScriptDlg::DlgProc"); 
	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;

	case WM_CLOSE:
		Hide();
		return TRUE;
	}

	return FALSE;
}
