/*
	PartPreview.h
	This is a piece prview dialog that allows up to 9 pieces to be displayed
	in 3D at once
*/

#ifndef __PARTPREVIEW_H__
#define __PARTPREVIEW_H__

#include "../UI/MSWindow.h"
#include "max.h"
#include "PieceBrowser.h"
#include "D3DRenderer.h"

#define NUM_PREVIEW_WINDOWS 9

class PartPreviewDlg: public MSDlgWindow
{
	RendererType     rendererType;
	PieceBrowserObj* pPieceBrowser;
	int              lastTexID;
	HWND             hwndParent;
	int              selPreview;			// ID of the selected preview window
	bool             bActive;
	int              numActiveWindows;		// Number of active window pains (usually NUM_PREVIEW_WINDOWS)
											// But, less if there are less than NUM_PREVIEW_WINDOWS loaded

	HWND             hwndPreviewWindow[NUM_PREVIEW_WINDOWS];
	NSPiece          meshPreviewWindow[NUM_PREVIEW_WINDOWS];
	HGLRC            glrcPreviewWindow[NUM_PREVIEW_WINDOWS];
	D3DRenderer      d3dPreviewWindow[NUM_PREVIEW_WINDOWS];	
	D3DRenderer*     activeD3DRenderer;

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void CreatePreviewWindows();
	bool InitContexts();
	
	void DestroyContexts();
	void DestroyContextsGL();
	void DestroyContextsD3D();

	void UpdatePreviews();
	void GLUpdatePreview(int i);
	void D3DUpdatePreview(int i);
	
	void LoadMeshes(int start=0);

	void DrawPiece(NSPiece* piece);
	void DrawPieceGL(NSPiece* piece);
	void DrawPieceD3D(NSPiece* piece);
	
	int  UploadTexture(char* filename, int contextID);
	void UpdateScroll(HWND hwndScroll, int Code, int Pos);
	void ClearPieceSelection();

	void DeletePreviewTextures(int context);
	void DeletePreviewTexturesGL(int context);
	void DeletePreviewTexturesD3D(int context);
	void GetConfig();
	void Shutdown();

	static LRESULT CALLBACK PreviewGLWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	PartPreviewDlg(HINSTANCE hInstance, HWND hwndParent, PieceBrowserObj* pPieceBrowser);
	PartPreviewDlg(HINSTANCE hInstance, HWND hwndParent);
	~PartPreviewDlg();

	void Init();
	void Init(PieceBrowserObj* obj);
};

#endif
