/*
	D3DRenderer.h
	Direct3D Renderer
	aml - 11-21-02
*/

#ifndef __D3DRENDERER__
#define __D3DRENDERER__

#include "DisplayDevice.h"

class D3DRenderer
{
	HWND               hwnd;		// Window assigned to render onto
	LPDIRECT3D8        pD3D;		// Main Direct3D Interface
	DisplayDevice*     displays;	// Array of all the display devices on the system
	int                nDisplays;	// Number of display adapters on the system
	DWORD              clearColor;	// The color that the display will be 

	D3DXMATRIX         matWorld;	// World matrix
	D3DXMATRIX         matView;		// View (LookAt) matrix
	D3DXMATRIX         matProj;		// Projection matrix

public:
	D3DRenderer();
	~D3DRenderer();

	bool InitD3D(HWND hwnd);
	void ShutdownD3D();
	void Render(D3DMesh* mesh);

	inline void SetWorld(D3DXMATRIX& world) { matWorld = world;   }
	inline void SetView(D3DXMATRIX& view)   { matView  = view;    }
	inline void SetProj(D3DXMATRIX& proj)   { matProj  = proj;    }
	inline int  GetNumDisplays()            { return nDisplays;   }
	
	inline void SetClearColor(DWORD color)  { clearColor = color; }
	inline void SetClearColor(unsigned char r, unsigned char g, unsigned char b) { clearColor = D3DCOLOR_XRGB(r,g,b); }
	inline void SetClearColor(float r, float g, float b) 
	{ clearColor = D3DCOLOR_XRGB((unsigned char)(r * 255.0f),(unsigned char)(g * 255.0f), (unsigned char)(b * 255.0f)); }

	void SetTestMatrices();
	void CreateTestMesh2(D3DMesh* mesh);
	void CreateTestMesh(D3DMesh* mesh);

	void FreeTextures();
	void FreeVertBuffers();
	void FreeIndexBuffers();
	void FreeAll();

	void UploadMesh(D3DMesh* mesh);
	void UploadMesh(DisplayDevice* disp, D3DMesh* mesh);
	bool DrawMesh(DisplayDevice* disp, D3DMesh* mesh);
};

#endif
