/*
	Mesh structure supported by Direct3D Renderer
	aml - 11-20-02
*/

#ifndef __D3DMESH__
#define __D3DMESH__

#include "D3DTypes.h"

struct BufferGroup
{
	VertBufRefArray      vbuf;		// Vertex buffer for each device for this particular texture group
	IndexBufRefArray     ibuf;		// Index buffer for each device fot this particular texture group
	int                  nVerts;
	int                  nFaces;
	D3DVert*             verts;
	D3DFace*             faces;

	BufferGroup();
	~BufferGroup();

	void AllocVerts(int num);
	void AllocFaces(int num);
};


struct D3DMesh
{
	int                  nVerts;
	int                  nFaces;
	D3DVert*             verts;
	D3DFace*             faces;
	TexFace*             texFaces;	// Original face data, this will be converted into
									// vertex lists for each texture

	Link<VertexBuffer>** vBuffer;	// Array of vertex buffer references 1 per display
	Link<IndexBuffer>**  iBuffer;	// Array of index buffer references 1 per display

	BufferGroup*         texgroup;	// Contains vertex/index data for each texture

	MeshTexture*         textures;	// Array of textures used for this mesh
	int                  nTextures;	// Number of textures used in this mesh

	void Init();

	D3DMesh();
	~D3DMesh();

	void AllocVerts(int num);
	void AllocFaces(int num);
	void AllocRefs(int nDisp);
	void AllocTextures(int nTex);

	int CountTextureFaces(int id);

	void BuildBuffers();
};

#endif
