/**********************************************************************
 *<
	FILE: NExt.cpp

	DESCRIPTION:	Appwizard generated plugin

	CREATED BY: 

	HISTORY: 

 *>	Copyright (c) 2000, All Rights Reserved.
 **********************************************************************/

#include <Engine/Engine.h>
#include "export/CutsceneExportDlg.h"
#include <Export/TextureExporter.h>
#include "PropEdit/TestPlug.h"	// AML  (This is temporary, until I get QuadMenu info)
#include "GapTool/GapTool.h"
#include "Merge/Merge.h"
#include "Overlap/Overlap.h"
#include "PropEdit/PropEdit.h"	// AML
#include "NExt.h"
#include "PieceBrowser/PartPreview.h"
#include "nodecrc.h"
#include "misc/brandcheck.h"
#include "RCMenu.h"
#include "Particle/NExtParticle.h"
#include "ViewportUI.h"
#include "WibbleWatcher.h"		// Temporary for debugging the wibble bug this will scan
                                // every second for changes (wanted to force on by default until I figure this one out)

#include "memDebug.h"
#include "version.h"
#include "appdata.h"
#include "FlagReassignerPatch2.h"
#include <new.h>
#include "SymbolDebug.h"
#include "InterLink\InterLink.h"

#define NO_PREINCLUDES
#define NO_BASEPREINCLUDES
#include "FuncEnter.h"

extern TCHAR *GetString(int id);

//#define DISABLE_ENGINE_PROCESSES

Interface*   gInterface;
GUP*         gpGUP;						// Pointer to the GUP itself for access to GUP interface methods
PropEditor*  pPropEdit;					// This is temporarily global so it can be accessed via a tool plugin
										// this will change when we get info on the QuadMenu system

										// Moved here to prevent reload on trigger contruction
char         gTrgDefClass[255];			// Default trigger class name
char         gTrgDefType[255];			// Default trigger type name

CutsceneExportDlg* gpCutsceneExporter;	// Global so right click menu can access it

PartPreviewDlg* pPartPreviewDlg;		// This is the piece preview window, whenever a piece browser object is opened
										// and the Piece Palette option is choosen this window will connect to that object
										// and interact with it

ViewportUI* gpViewportUI;
BOOL        gbDoMemChecks  = FALSE;
int         gbMemCheckFreq = 50;

BOOL        gBackgroundProcesses = TRUE;
HANDLE      ghTrackingThread = NULL;	// This is used to lock debug output onto a certain thread, calls from other
										// MAX threads (or any other app for that matter) are ignored

BOOL        gbInterMaxLink = FALSE;		// True if MAX should send realtime Level Editor updates

static	Engine* s_engine;

//class NExt : public GUP, public ReferenceMaker {
class NExt : public GUP {
	public:


		static HWND hParams;

		void	QuitMax			( void );

		// GUP Methods
		DWORD	Start			( );
		void	Stop			( );
		DWORD	Control			( DWORD parameter );
		
		// Loading/Saving
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);

		
		RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
							     PartID& partID,  RefMessage message);

		//Constructor/Destructor

		NExt();
		~NExt();		

		// other
		void RegisterShortcuts();
		void UnregisterShortcuts();
};

void *	NExtClassDesc::Create(BOOL loading)
{ FUNC_ENTER("NExtClassDesc::Create");  
	return new NExt(); 
}

//static NExtClassDesc NExtDesc;
NExtClassDesc NExtDesc;				// Right-click menus must access this directly and are implemented externally
ClassDesc2* GetNExtDesc() { FUNC_ENTER("GetNExtDesc");  return &NExtDesc; }

// OBSOLETE in R4   Right click menu for the property editor AML
//static PropsRightMenu* NExt_props_menu;

NExt::NExt()
{ FUNC_ENTER("NExt::NExt"); 

}

NExt::~NExt()
{ FUNC_ENTER("NExt::~NExt"); 

}


RefResult NExt::NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
						         PartID& partID,  RefMessage message)
{ FUNC_ENTER("NExt::NotifyRefChanged"); 
	OutputDebugString("NExt::NotifyRefChanged Was called\n");

	switch(message)
	{
	case REFMSG_NODE_LINK:
		{
			//char strName[256];
			//INode* node = (INode*)hTarget;
			//sprintf(strName, "Attach/Detatch Node %s...\n", (char*)node->GetName());
			OutputDebugString("Attach/Detatch Node\n");
		}
		break;

	case REFMSG_CHANGE:
		if (partID & PART_TOPO   ||
			partID & PART_GEOM   ||
			partID & PART_TEXMAP ||
			partID & PART_MTL    ||
			partID & PART_VERTCOLOR)
		{
			OutputDebugString("Node has changed!\n");
		}
		break;

	case REFMSG_NODE_NAMECHANGE:
		{
			OutputDebugString("A node has changed its name\n");
		}
	}

	return REF_SUCCEED;
}


void BuildPlugWindowString()
{ FUNC_ENTER("BuildPlugWindowString"); 
	char plugmsg[512];
	char maxbar[512];
	char datemsg[512];
	char plugstate[80];
	bool bVerify;

	GetWindowText(gInterface->GetMAXHWnd(), maxbar, 511);

	if (strstr(maxbar, "Next.gup"))
		return;

	if (VerifyAuthenticity(NULL, NULL, plugmsg))
	{
		bVerify = true;
		strcpy(plugstate, "Release");
	}
	else
	{
		bVerify = false;
		strcpy(plugstate, "BETA");
	}

	sprintf(datemsg, "  Next.gup %s %s %s", plugstate, GetVersionDate(), GetVersionTime());

	if (bVerify)
	{
		char tmpbuf[512];
		sprintf(tmpbuf, "  [%s]", plugmsg);
		strcat(datemsg, tmpbuf);
	}

	strcat(maxbar, " ");
	strcat(maxbar, datemsg);

	SetWindowText(gInterface->GetMAXHWnd(), maxbar);
}

static void next_post_open_handler(void *param, NotifyInfo *info ) 
{ FUNC_ENTER("next_post_open_handler"); 
	OutputDebugString("HANDLER: next_post_open_handler\n");
	GetTextureExporter()->OnPostOpen();		
}

static void next_title_handler(void *param, NotifyInfo *info )
{ FUNC_ENTER("next_title_handler"); 
	OutputDebugString("HANDLER: next_title_handler\n");
	BuildPlugWindowString();
}

static void next_flag_reassign_patcher(void *param, NotifyInfo *info )
{ FUNC_ENTER("next_flag_reassign_patcher"); 
	OutputDebugString("HANDLER: next_flag_reassign_patcher\n");
	DoFlagReassignment(false);
}

static void next_pre_save_handler(void *param, NotifyInfo *info )
{ FUNC_ENTER("next_pre_save_handler"); 
	OutputDebugString("HANDLER: next_pre_save_handler\n");
	/*  Discreet recommended: But didn't solve problem
	Tab<MtlBase*> delList;
	MtlBaseLib* mlib = gInterface->GetSceneMtls();

	int nMtls = mlib->Count();
	int i;

	for(i = 0; i < nMtls; i++)
	{
		if ((*mlib)[i]->GetRefList().first == NULL)
			delList.Append(1, &((*mlib)[i]));
	}

	int nEntries = delList.Count();

	for(i = 0; i < nEntries; i++)
		mlib->Remove(delList[i]);
	*/

	// Ensure that newly saved files don't apply to the collide swap flag reset
	FlagAsCollideSwapCompleted();
}

#define vTEST_ACTION1_SHORTCUT_ID  0x1a8f3a26

enum { fnIdGlobalAction1 };

// action table
static ActionDescription stest_actions[] = {
	ID_TEST_ACTION1,
	IDS_TEST_ACTION1_NAME,
	IDS_TEST_ACTION1_DESC,
    IDS_TEST_ACTION1_ACTION,
};

ActionTable* GetRCActionTable( void )
{ FUNC_ENTER("GetRCActionTable"); 
    //TSTR name = GetString(IDS_LINK_ACTIONS);
	TSTR name = _T("NExt Right-Click Actions");
    HACCEL hAccel = LoadAccelerators(hInstance,
                                     MAKEINTRESOURCE(IDR_RIGHTCLICK_ACCEL));

    int numOps = ( sizeof(stest_actions) / sizeof(stest_actions[0]) );
    ActionTable* pTab;
    pTab = new ActionTable( vTESTPLUG_SHORTCUT_ID, vTEST_ACTION1_SHORTCUT_ID, name, hAccel, numOps,
                             stest_actions, hInstance);
    GetCOREInterface()->GetActionManager()->RegisterActionContext( vTEST_ACTION1_SHORTCUT_ID, name.data());

    return pTab;
}

class RCActionCB : public ActionCallback 
{
public:
	BOOL ExecuteAction(int id)
	{ FUNC_ENTER("RCActionCB::ExecuteAction"); 
		MessageBox(gInterface->GetMAXHWnd(), "Action Executed", "Action Executed!", MB_ICONINFORMATION|MB_OK);
		return TRUE;
	}
};

static RCActionCB RCactionHandler;

int new_exception_handler( size_t size )
{ FUNC_ENTER("new_exception_handler"); 
	DumpLog("c:\\next.log");

	char strErr[256];
	sprintf(strErr, "STOP!!  NEW/MALLOC FAILED ALLOCATION OF %i BYTES CONTACT ADAM EXT. 4125  PROGRAM WILL HALT!", size);
	MessageBox(gInterface->GetMAXHWnd(), strErr, "CRITICAL!  Memory Allocation Problem", MB_ICONSTOP|MB_OK);
	__asm int 3;

	return 0;
}

void exception_terminate()
{ FUNC_ENTER("exception_terminate"); 
	MessageBox(gInterface->GetMAXHWnd(), "NExt.gup MAX Application Exception Override", "NExt.gup Exception Handler", MB_ICONSTOP|MB_OK);
}

// Activate and Stay Resident
DWORD NExt::Start( ) 
{ FUNC_ENTER("NExt::Start"); 
	// Startup symbolic debug system
	//InitSymbols();


////// Memory test:  Check how many 50 meg blocks we can allocate until failure
// Plugin appears to have 800 MB available at startup

/*
int nAllocs = 0;
int nSmallAllocs = 0;

do
{
	if (!new char[1024*1024*100])
	{
		do
		{
			if (!new char[500 * 1024])
			{
				char buf[256];
				sprintf(buf, "Allocation failed after %i allocs of 50 megs (%i small allocs)", nAllocs, nSmallAllocs);
				MessageBox(gInterface->GetMAXHWnd(), buf, "Memory alloc test", MB_OK);
			}

			nSmallAllocs++;

		} while (1);
	}
	nAllocs++;
} while(1);
*/

//////////////////////////////////////////////////////////////////////////////////////

	SetDebugInit(true);

	VerifyMemory();

	// Suspicion of memory allocation failures, this should trap if a new fails
	_set_new_handler(new_exception_handler);

	// Mallocs will call the new exception handler on failure to allocate as well
	_set_new_mode(1);

	// TODO: Do plugin initialization here
	gInterface = Max();	

	set_terminate(exception_terminate);

	gpGUP = this;

	// Get triggerUI.ini settings
	CStr appDir = gInterface->GetDir(APP_PLUGCFG_DIR);
	appDir += "\\TriggerUI.ini";

	GetPrivateProfileString("Properties", "Class", "RailNode", gTrgDefClass, 255, (char*)appDir);
	GetPrivateProfileString("Properties", "Type", "Concrete", gTrgDefType, 255, (char*)appDir);

	appDir = gInterface->GetDir(APP_PLUGCFG_DIR);
	appDir += "\\NExt.ini";
	gBackgroundProcesses = GetPrivateProfileInt("NExt", "BackgroundProcesses", TRUE, appDir);
	gbDoMemChecks = GetPrivateProfileInt("NExt", "EnableMemChecks", FALSE, appDir);
	gbMemCheckFreq = GetPrivateProfileInt("NExt", "MemCheckFreq", 5000, appDir);
	gbInterMaxLink = GetPrivateProfileInt("NExt", "InterMaxLink", FALSE, appDir);
	
	if (gbInterMaxLink)
		StartInterLinkServices();

	// Right click menu system was changed in r4,  need to go through the menu manager
	// to make use of the new QuadMenu system   AML
	InstallNExtRCMenus();
	RegisterShortcuts();

	REGISTERCLASS(TrackUI, hInstance);

#ifndef DISABLE_ENGINE_PROCESSES
	if (gBackgroundProcesses)
		s_engine           = new Engine;
	else
		s_engine           = NULL;
#else
	s_engine           = NULL;
#endif

	pPropEdit          = new PropEditor(hInstance,gInterface);
	pPartPreviewDlg    = new PartPreviewDlg(hInstance, gInterface->GetMAXHWnd());
	gpCutsceneExporter = new CutsceneExportDlg(hInstance, gInterface->GetMAXHWnd());
	gpCutsceneExporter->Hide();

#ifndef DISABLE_WIBBLE_WATCHER
	if (gBackgroundProcesses)
		InstallPeriodicWibbleWatcher();
#endif

	VerifyMemory();

#ifndef DISABLE_NOTIFICATIONS
	RegisterNotification( next_post_open_handler, NULL, NOTIFY_FILE_POST_OPEN );
	RegisterNotification( next_pre_save_handler, NULL, NOTIFY_FILE_PRE_SAVE );

	RegisterNotification( next_title_handler, NULL, NOTIFY_FILE_POST_OPEN  );
	RegisterNotification( next_title_handler, NULL, NOTIFY_FILE_POST_SAVE  );
	RegisterNotification( next_title_handler, NULL, NOTIFY_FILE_POST_MERGE );
	RegisterNotification( next_title_handler, NULL, NOTIFY_SYSTEM_POST_NEW );
	RegisterNotification( next_title_handler, NULL, NOTIFY_SYSTEM_POST_RESET );

	// Register scene reflagger notification
	RegisterNotification( next_flag_reassign_patcher, NULL, NOTIFY_FILE_POST_OPEN);

	RegisterParticleNotifications();
#endif

	// Request root node change notification so we can figure out whenever anything changes
	// This way we can flag it as dirty, and no that it's output data needs regenerated
	/*
	INode* root = gInterface->GetRootNode();
	ReferenceTarget* scene = gInterface->GetScenePointer();

	if (MakeRefByID(FOREVER, 0, scene) != REF_SUCCEED)
	{
		MessageBox(gInterface->GetMAXHWnd(),"Failed to reference root node!", "Reference Tracking Failed", MB_ICONSTOP|MB_OK);
	}
	*/

	// Acquires the last time scripts.ini and the plugin were
	// modified for use in timestamping nodes for NodeCRC incremental script export
	InitNodeCRCFileTimes();

	BuildPlugWindowString();

	//gpViewportUI = new ViewportUI(gInterface);
	//gpViewportUI->HookViewports();

	VerifyMemory();

	// TODO: Return if you want remain loaded or not
	return GUPRESULT_KEEP;
}

void NExt::Stop( ) { FUNC_ENTER("NExt::Stop"); 

	// Unregister created right click menus
	//gInterface->GetRightClickMenuManager()->Unregister( NExt_props_menu );
	//\delete NExt_props_menu;
	//gpViewportUI->UnHookViewports();

	if (gbInterMaxLink)
		StopInterLinkServices();

	UnregisterParticleNotifications();
	UnregisterShortcuts();

	// Shutdown the property editor
	delete pPropEdit;
	delete pPartPreviewDlg;

	// TODO: Do plugin un-initialization here	
	delete s_engine;
}

DWORD NExt::Control( DWORD parameter ) { FUNC_ENTER("NExt::Control"); 
	return 0;
}

IOResult NExt::Save(ISave *isave)
{ FUNC_ENTER("NExt::Save"); 
	return IO_OK;
}

IOResult NExt::Load(ILoad *iload)
{ FUNC_ENTER("NExt::Load"); 
	return IO_OK;
}

void NExt::RegisterShortcuts()
{ FUNC_ENTER("NExt::RegisterShortcuts"); 
	RegTestActionAccelerators();
	RegGapActionAccelerators();
	RegMergeActionAccelerators();
	RegOverlapActionAccelerators();
}

void NExt::UnregisterShortcuts()
{ FUNC_ENTER("NExt::UnregisterShortcuts"); 
	UnRegTestActionAccelerators();
	UnRegGapActionAccelerators();
	UnRegMergeActionAccelerators();
	UnRegOverlapActionAccelerators();
}

void NExt::QuitMax( void )
{ FUNC_ENTER("NExt::QuitMax"); 
	ExecuteStringScript( "actionMan.executeAction 0 \"40013\"" );
}