#include "FuncEnter.h"

/*
	HelperFuncs.cpp
	MAX Helper Functions
	1-10-01
*/

#include "HelperFuncs.h"
#include "../Export/Skeleton.h"
#include "SkinMod.h"
#include "MaxUtil.h"

/*
Modifier* FindModifier(INode* nodePtr, Class_ID cid)
{ FUNC_ENTER("FindModifier");
	Object* ObjectPtr = nodePtr->GetObjectRef();

	if (!ObjectPtr ) return NULL;
	
	while (ObjectPtr->SuperClassID() == GEN_DERIVOB_CLASS_ID && ObjectPtr)
	{
			// Yes -> Cast.
			IDerivedObject* DerivedObjectPtr = (IDerivedObject *)(ObjectPtr);				
			
		// Iterate over all entries of the modifier stack.
		int ModStackIndex = 0;

		while (ModStackIndex < DerivedObjectPtr->NumModifiers())
		{
			// Get current modifier.
			Modifier* ModifierPtr = DerivedObjectPtr->GetModifier(ModStackIndex);

			// Is this Physique ?
			if (ModifierPtr->ClassID() == cid)
			{
				return ModifierPtr;
			}

			ModStackIndex++;
		}

		ObjectPtr = DerivedObjectPtr->GetObjRef();
	}

	// Not found.
	return NULL;
}
*/

Modifier* FindPhysiqueModifier (INode* nodePtr)
{ FUNC_ENTER("FindPhysiqueModifier"); 
	return FindModifier(nodePtr, Class_ID(PHYSIQUE_CLASS_ID_A, PHYSIQUE_CLASS_ID_B));
}

Modifier* FindSkinModifier (INode* nodePtr)
{ FUNC_ENTER("FindSkinModifier");
	return FindModifier(nodePtr, SKINMOD_CLASS_ID);
}

INode* FindBoneRootBySkin(INode* skinNode)
{ FUNC_ENTER("FindBoneRootBySkin"); 
	if (!skinNode)
		return NULL;

	// Attempt to locate the Physique modifier
	Modifier* mod = FindPhysiqueModifier(skinNode);

	if (!mod)
		return NULL;

	// Grab the physique interface
    IPhysiqueExport* pPhysiqueExport = (IPhysiqueExport*)mod->GetInterface(I_PHYINTERFACE);    
	assert( pPhysiqueExport );

	IPhyContextExport* pModContextExport = (IPhyContextExport*)pPhysiqueExport->GetContextInterface(skinNode);
	assert( pModContextExport );

    pModContextExport->ConvertToRigid( true );
    pModContextExport->AllowBlending( true );

    IPhyVertexExport* pVertexExport;
    pVertexExport = pModContextExport->GetVertexInterface( 0 );
	assert( pVertexExport );

	INode* modelNode;

	switch(pVertexExport->GetVertexType())
	{
	case RIGID_BLENDED_TYPE:
		{
			IPhyBlendedRigidVertex* pBlendedVertex = (IPhyBlendedRigidVertex*)pVertexExport;
			
			if (pBlendedVertex->GetNumberNodes() == 0)
				return NULL;

			modelNode = pBlendedVertex->GetNode(0);
		}
		break;

	case RIGID_TYPE:
		{
			IPhyRigidVertex* pRigidVertex = (IPhyRigidVertex*)pVertexExport;
			modelNode = pRigidVertex->GetNode();
		}
		break;

	default:
		return NULL;
	}

	CStr name = modelNode->GetName();

	CSkeletonData cskel = CSkeletonData(modelNode);
	return cskel.GetRootBone(modelNode);
	//return FindRoot(modelNode);
}
