#include "FuncEnter.h"

/*
	MergeRenameDlg.cpp
	aml 4-22-01
*/

#include "MergeRenameDlg.h"
#include "Resource.h"

MergeRenameDlg::MergeRenameDlg(HINSTANCE hInstance, HWND hwndParent,CStr name) :
	ModalDlgWindow(hInstance,MAKEINTRESOURCE(IDD_MERGENAME),hwndParent)
{ FUNC_ENTER("MergeRenameDlg::MergeRenameDlg"); 
	strName = name;
}

MergeRenameDlg::~MergeRenameDlg()
{ FUNC_ENTER("MergeRenameDlg::~MergeRenameDlg"); 
	ReleaseICustEdit(IEdit);
}

BOOL MergeRenameDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("MergeRenameDlg::DlgProc"); 
	switch(msg)
	{
	case WM_INITDIALOG:
		{
			ICustEdit* IEdit = GetICustEdit(GetDlgItem(hwnd,IDC_MERGENAME));
			IEdit->SetText(strName);
			ReleaseICustEdit(IEdit);
		}
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_OPDONE:
			{
				char buf[256];

				ICustEdit* IEdit = GetICustEdit(GetDlgItem(hwnd,IDC_MERGENAME));
				IEdit->GetText(buf,255);
				ReleaseICustEdit(IEdit);
				strName = buf;

				EndDialog(hwnd,0);
			}
			return TRUE;
		}
	}

	return FALSE;
}

CStr MergeRenameDlg::GetName()
{ FUNC_ENTER("MergeRenameDlg::GetName"); 
	return strName;
}

void MergeRenameDlg::SetName(CStr& name)
{ FUNC_ENTER("MergeRenameDlg::SetName"); 
	strName = name;
}
