#include "FuncEnter.h"

/*
	Merge.cpp
	A Utility plugin for performing better merges of materials and geom
*/

#include "../Trigger/Trigger.h"
#include "Merge.h"
#include "MergeDlg.h"
#include "MergeList.h"
#include "MatMergeList.h"
#include "../Link/LinkUI.h"
#include <Material/NExtMat.h>
#include <Material/NExtMultiMat.h>
#include "../PropEdit/ParseFuncs.h"
#include "Resource.h"
#include "../UI/ColorListBox.h"
#include "../UI/ScriptSelect.h"   // This is only a test  WILL REMOVE!
#include "../UI/SlideNum.h" 	  // This is only a test  WILL REMOVE!
#include "../misc/maxutil.h"
#include "../Link/LinkMan.h"
#include "IUtilityPanel.h"
#include "../MemDebug.h"

extern HINSTANCE  hInstance;
extern Interface* gInterface;
extern GUP*       gpGUP;

static MergeActionCB       mergeActionCB;
static MergeActionCB*      mergeAccel=NULL;
static MergeTool*	s_merge_tool = NULL;

// action table
static ActionDescription s_merge_actions[] = {

	ID_MERGE_OPEN,
	IDS_MERGETOOL_DESC,
    IDS_MERGETOOL_DESC,
    IDS_MERGETOOL_ACTIONS,
};

bool RegMergeActionAccelerators();
void UnRegMergeActionAccelerators();

const ActionTableId merge_actions           = vMERGETOOL_SHORTCUT_ID;
const ActionContextId merge_actions_context = vMERGETOOL_SHORTCUT_ID;

static MergeToolClassDesc theMergeToolDesc;
ClassDesc2* GetMergeToolDesc() { FUNC_ENTER("GetMergeToolDesc");  return &theMergeToolDesc; }

#define RENAME_PREFIX "!!@!!"

DWORD WINAPI ProgressFunc(LPVOID arg) 
{ FUNC_ENTER("ProgressFunc"); 
    return(0);
}

MergeTool::MergeTool()
{ FUNC_ENTER("MergeTool::MergeTool"); 
	dlg = new MergeDlg(hInstance,gInterface->GetMAXHWnd());
	
	nodeListDlg = NULL;
	matListDlg  = NULL;
	s_merge_tool = this;

	nodeTolerance = 0;
	objectTolerance = 0;

	bLockSceneRenamePost = false;
}

MergeTool::~MergeTool()
{ FUNC_ENTER("MergeTool::~MergeTool"); 
	delete dlg;
	
	if (nodeListDlg)
		delete nodeListDlg;

	if (matListDlg)
		delete matListDlg;

	s_merge_tool = NULL;
}

void MergeTool::BeginEditParams(Interface *ip,IUtil *iu)
{ FUNC_ENTER("MergeTool::BeginEditParams"); 
	this->ip=ip;
	this->iu=iu;

	hRollup = ip->AddRollupPage(hInstance, MAKEINTRESOURCE(IDD_MERGE), DlgProc, "NeverSoft Merge Tool",(LPARAM)this);

	CheckDlgButton(hRollup,IDC_USEDMTLSONLY,BST_CHECKED);
	CheckDlgButton(hRollup,IDC_MERGEGEOM,BST_CHECKED);
	CheckDlgButton(hRollup,IDC_AUTOTRIGRENAME, BST_CHECKED);
	
	ISpinnerControl *spinner;
	ICustEdit* edit;
	
	spinner = SetupFloatSpinner( hRollup, IDC_NODE_TOLERANCE_SPINNER, IDC_NODE_TOLERANCE, 0.0f, 1000.0f, 1.0f, 0.1f );
	spinner = SetupFloatSpinner( hRollup, IDC_OBJECT_TOLERANCE_SPINNER, IDC_OBJECT_TOLERANCE, 0.0f, 100.0f, 1.0f, 0.1f );

	char buf[256];	
	CStr appDir=ip->GetDir(APP_PLUGCFG_DIR);
	appDir+="\\NxPrefs.ini";	

	edit = GetICustEdit( GetDlgItem( hRollup, IDC_NODE_TOLERANCE ));
	GetPrivateProfileString("Overlap","NodeTolerance","10.0",buf,255,(char*)appDir);
	edit->SetText( buf );
	ReleaseICustEdit( edit );

	edit = GetICustEdit( GetDlgItem( hRollup, IDC_OBJECT_TOLERANCE ));
	GetPrivateProfileString("Overlap","ObjectTolerance","10.0",buf,255,(char*)appDir);
	edit->SetText( buf );
	ReleaseICustEdit( edit );
}

void MergeTool::EndEditParams(Interface *ip,IUtil *iu)
{ FUNC_ENTER("MergeTool::EndEditParams"); 
	ip->DeleteRollupPage(hRollup);
}

void MergeTool::SelectionSetChanged(Interface *ip,IUtil *iu)
{ FUNC_ENTER("MergeTool::SelectionSetChanged"); 

}

bool MergeTool::ChooseFile()
{ FUNC_ENTER("MergeTool::ChooseFile"); 
	OPENFILENAME ofn;
	char filename[256]="";
	char filetitle[128]="";

	ofn.lStructSize=sizeof(ofn);
	ofn.hwndOwner=hRollup;
	ofn.hInstance=hInstance;
	ofn.lpstrFilter="MAX Files (*.max)\0*.max\0\0";
	ofn.lpstrCustomFilter=NULL;
	ofn.nMaxCustFilter=0;
	ofn.nFilterIndex=0;
	ofn.lpstrFile=filename;
	ofn.nMaxFile=256;
	ofn.lpstrFileTitle=filetitle;
	ofn.nMaxFileTitle=128;
	ofn.lpstrInitialDir=NULL;
	ofn.lpstrTitle="Select MAX file to merge";
	ofn.Flags=OFN_LONGNAMES|OFN_ENABLESIZING;
	ofn.nFileOffset=0;
	ofn.nFileExtension=0;
	ofn.lpstrDefExt=TEXT(".q");
	ofn.lCustData=0;
	ofn.lpfnHook=NULL;
	ofn.lpTemplateName=NULL;

	GetOpenFileName(&ofn);

	CStr File=CStr(filename);
	CStr FileTitle=CStr(filetitle);

	SetDlgItemText(hRollup,IDC_FILENAME,(char*)File);

	if (File.Length()>0 &&
		(IsDlgButtonChecked(hRollup,IDC_MERGEMATS)==BST_CHECKED ||
		 IsDlgButtonChecked(hRollup,IDC_MERGEGEOM)==BST_CHECKED)
	   )
	{
		EnableWindow(GetDlgItem(hRollup,IDC_DOMERGE),TRUE);
		return true;
	}
	else
	{
		EnableWindow(GetDlgItem(hRollup,IDC_DOMERGE),FALSE);
		return false;
	}
}

int MergeTool::NodeSceneCount(INode* root)
{ FUNC_ENTER("MergeTool::NodeSceneCount"); 
	int    kids  = root->NumberOfChildren();
	int    count = 0;

	for(int i=0;i<kids;i++)
	{
		INode* node = root->GetChildNode(i);
		count += NodeSceneCount(node);
	}

	return count+1;
}

void MergeTool::SceneRenamePre(INode* root)
{ FUNC_ENTER("MergeTool::SceneRenamePre"); 
	int    kids = root->NumberOfChildren();

	for(int i=0;i<kids;i++)
	{
		INode* node = root->GetChildNode(i);
		SceneRenamePre(node);
	}

	// Rename the node
	static num = 0;
	char buf[256];
	sprintf(buf, "Pre Rename: %i\n",num++);
	OutputDebugString(buf);

	CStr name = root->GetName();
	root->SetName(CStr(RENAME_PREFIX)+name);

	// Add the node to the node database
	NodeEntry nentry;
	nentry.name  = name;
	nentry.node  = root;
	nentry.id    = root->GetHandle();
	nentry.flags = 0;
	
	nodeDB.AddToTail(&nentry);

	ip->ProgressUpdate( nodeProg++ * 100 / numNodes );
}

void MergeTool::SceneRenamePost(INode* root)
{ FUNC_ENTER("MergeTool::SceneRenamePost"); 
	int		kids = root->NumberOfChildren();

	for(int i=0;i<kids;i++)
	{
		INode* node = root->GetChildNode(i);
		SceneRenamePost(node);
	}

	// Rename the node
	CStr name = root->GetName();
	if (Instr(name,RENAME_PREFIX)==0)
	{
		name = Right(name, strlen(RENAME_PREFIX));
		root->SetName(name);
	}

	int per = nodeProg++ * 100 / numNodes;
	//ip->ProgressUpdate( per );
}

void MergeTool::MtlRenamePre()
{ FUNC_ENTER("MergeTool::MtlRenamePre"); 
	MtlBaseLib* mlib = ip->GetSceneMtls();

	ip->ProgressStart(_T("Preprocessing source materials"), TRUE, 
					  ProgressFunc, NULL );

	for(int i=0;i<mlib->Count();i++)
	{
		if (IsMtl((*mlib)[i]))
		{
			Mtl* mtl = (Mtl*)(*mlib)[i];

			CStr name = mtl->GetName();
			mtl->SetName(CStr(RENAME_PREFIX)+name);

			if (name == CStr(""))
				continue;

			OutputDebugString(name);
			OutputDebugString("Found a Mtl.\n");				

			MatEntry matentry;
			matentry.name  = name;
			matentry.mtl   = mtl;
			matentry.flags = 0;

			Link<MatEntry>* mainmtl = matDB.AddToTail(&matentry);

			// If this material is a multi/sub-object, we'll need to store the
			// sub materials as well so we can later do sub material level replacement
			if (mtl->ClassID()==Class_ID(MULTI_CLASS_ID,0) || 
				mtl->ClassID()==vNEXT_MULTI_MATERIAL_CLASS_ID)
			{
				int numSubs = mtl->NumSubMtls();

				for(int j=0;j<numSubs;j++)
				{
					Mtl* submtl = mtl->GetSubMtl(j);

					if (submtl)
					{
						MatEntry matentry;
						matentry.name   = submtl->GetName();
						matentry.mtl    = submtl;
						matentry.flags  = MATFLAG_MERGEMULTI;
						matentry.parent = &mainmtl->data;

						mainmtl->data.submtls.AddToTail(&matentry);
					}
				}
			}

			/*
			OutputDebugString(name);
			OutputDebugString("Found a Mtl.\n");				

			Class_ID cid;
			cid = (*mlib)[i]->ClassID();

			if ((*mlib)[i]->ClassID()==Class_ID(MULTI_CLASS_ID,0))
			{
				OutputDebugString("Found a std multi-material\n");
			}

			if ((*mlib)[i]->ClassID()==NEXT_MATERIAL_CLASS_ID)
			{
				OutputDebugString("Found NExt Material.\n");
			}
			*/
		}

		ip->ProgressUpdate( i * 100 / mlib->Count() );
	}

	ip->ProgressEnd();
}

void MergeTool::MtlRenamePost()
{ FUNC_ENTER("MergeTool::MtlRenamePost"); 
	MtlBaseLib* mlib = ip->GetSceneMtls();

	//ip->ProgressStart(_T("Postprocessing source materials"), TRUE, 
	//				  ProgressFunc, NULL );

	for(int i=0;i<mlib->Count();i++)
	{
		if (IsMtl((*mlib)[i]))
		{
			CStr name = (*mlib)[i]->GetName();

			if (Instr(name,RENAME_PREFIX)==0)
			{
				name = Right(name, strlen(RENAME_PREFIX));
				(*mlib)[i]->SetName(name);
			}
		}

		//ip->ProgressUpdate( i * 100 / mlib->Count() );
	}

	//ip->ProgressEnd();
}

void MergeTool::GetNodeEntryNodes(LinkList<NodeEntry>* list,INodeTab& nodes)
{ FUNC_ENTER("MergeTool::GetNodeEntryNodes"); 
	Link<NodeEntry>* curNode = list->GetHead();

	while(curNode)
	{
		if (NodeExists(curNode->data.node))
			nodes.Append(1, &curNode->data.node);

		curNode = curNode->next;
	}
}

bool MergeTool::MtlInScene(Mtl* mtl,INode* root)
{ FUNC_ENTER("MergeTool::MtlInScene"); 
	if (!root)
		root = ip->GetRootNode();

	int kids = root->NumberOfChildren();

	for(int i=0;i<kids;i++)
	{
		INode* child = root->GetChildNode(i);

		if (MtlInScene(mtl,child))
			return true;
	}

	if (root->GetMtl()==mtl)
		return true;

	return false;
}

Mtl* MergeTool::FindMtl(char* name, INode* root)
{ FUNC_ENTER("MergeTool::FindMtl"); 
	if (!root)
		root = ip->GetRootNode();

	int kids = root->NumberOfChildren();

	for(int i=0;i<kids;i++)
	{
		INode* child = root->GetChildNode(i);

		return FindMtl(name,child);
	}

	Mtl* mtl = root->GetMtl();

	if (mtl->GetName() == CStr(name))
		return mtl;

	return NULL;
}

void MergeTool::BuildMtlMergeDB(LinkList<NodeEntry>* list)
{ FUNC_ENTER("MergeTool::BuildMtlMergeDB"); 
	matDBmerge.Clear();
	
	Link<NodeEntry>* link = list->GetHead();

	//ip->ProgressStart(_T("Building material database"), TRUE, 
	//		          ProgressFunc, NULL );

	int i=-1;

	while(link)
	{
		Mtl* mtl = link->data.node->GetMtl();

		if (mtl)
		{
			CStr name = mtl->GetName();

			if (name == CStr(""))
				continue;

			// Skip the original materials within the library
			if (Instr(name,RENAME_PREFIX)==0)
				continue;

			MatEntry matentry;
			matentry.name  = name;
			matentry.mtl   = mtl;
			matentry.flags = 0;

			//Link<MatEntry>* mainmtl=matDBmerge.AddToTail(&matentry);
			Link<MatEntry>* mainmtl=matDBmerge.AddToTailFindUnique(&matentry);

			// If this material is a multi/sub-object, we'll need to store the
			// sub materials as well so we can later do sub material level replacement
			if (mtl->ClassID()==Class_ID(MULTI_CLASS_ID,0) || 
				mtl->ClassID()==vNEXT_MULTI_MATERIAL_CLASS_ID)
			{
				int numSubs = mtl->NumSubMtls();

				if (numSubs > 0)
					mainmtl->data.flags = MATFLAG_MERGEMULTIMASTER;

				for(int j=0;j<numSubs;j++)
				{
					Mtl* submtl = mtl->GetSubMtl(j);

					if (submtl)
					{
						MatEntry matentry;
						matentry.name   = submtl->GetName();
						matentry.mtl    = submtl;
						matentry.flags  = MATFLAG_MERGEMULTI;
						matentry.parent = &mainmtl->data;

						mainmtl->data.submtls.AddToTail(&matentry);
					}
				}
			}
		}

		//ip->ProgressUpdate( (++i) * 100 / list->GetSize() );

		link = link->next;
	}

	//ip->ProgressEnd();	
}

void MergeTool::BuildMtlMergeDB()
{ FUNC_ENTER("MergeTool::BuildMtlMergeDB"); 
	matDBmerge.Clear();
	
	MtlBaseLib* mlib = ip->GetSceneMtls();

	//ip->ProgressStart(_T("Building material database"), TRUE, 
	//		          ProgressFunc, NULL );

	for(int i=0;i<mlib->Count();i++)
	{
		char buf[256];
		sprintf(buf,"Material #: %i\n",i);
		OutputDebugString(buf);

		if (IsMtl((*mlib)[i]) &&
			MtlInScene((Mtl*)(*mlib)[i]))
		{
			Mtl* mtl = (Mtl*)(*mlib)[i];

			CStr name = mtl->GetName();

			if (name == CStr(""))
				continue;

			// Skip the original materials within the library
			if (Instr(name,RENAME_PREFIX)==0)
				continue;

			MatEntry matentry;
			matentry.name  = name;
			matentry.mtl   = mtl;
			matentry.flags = 0;

			//Link<MatEntry>* mainmtl=matDBmerge.AddToTail(&matentry);
			Link<MatEntry>* mainmtl=matDBmerge.AddToTailFindUnique(&matentry);

			// If this material is a multi/sub-object, we'll need to store the
			// sub materials as well so we can later do sub material level replacement
			if (mtl->ClassID()==Class_ID(MULTI_CLASS_ID,0) || 
				mtl->ClassID()==vNEXT_MULTI_MATERIAL_CLASS_ID)
			{
				int numSubs = mtl->NumSubMtls();

				if (numSubs > 0)
					mainmtl->data.flags = MATFLAG_MERGEMULTIMASTER;

				for(int j=0;j<numSubs;j++)
				{
					Mtl* submtl = mtl->GetSubMtl(j);

					if (submtl)
					{
						MatEntry matentry;
						matentry.name   = submtl->GetName();
						matentry.mtl    = submtl;
						matentry.flags  = MATFLAG_MERGEMULTI;
						matentry.parent = &mainmtl->data;

						mainmtl->data.submtls.AddToTail(&matentry);
					}
				}
			}
		}

		//ip->ProgressUpdate( i * 100 / mlib->Count() );
	}

	//ip->ProgressEnd();
}

void MergeTool::BuildSceneMergeDB()
{ FUNC_ENTER("MergeTool::BuildSceneMergeDB"); 
	nodeDBmerge.Clear();

	INode* root = ip->GetRootNode();

	INodeTab nodes;
	GetAllNodes(nodes,root);

	//ip->ProgressStart(_T("Building node database"), TRUE, 
	//		          ProgressFunc, NULL );

	char strBuf[256];
	sprintf(strBuf, "BuildingNodeDB: Count %i\n", nodes.Count());
	OutputDebugString(strBuf);

	for(int i=0;i<nodes.Count();i++)
	{
		CStr name = nodes[i]->GetName();

		sprintf(strBuf, "BuildingNodeDB: Processing '%s' #%i\n", (char*)name, i);
		OutputDebugString(strBuf);

		// Skip any of the original nodes within the scene
		if (Instr(name,RENAME_PREFIX)==0)
			continue;

		NodeEntry nentry;
		nentry.name  = name;
		nentry.node  = nodes[i];
		nentry.id    = nodes[i]->GetHandle();
		nentry.flags = 0;

		nodeDBmerge.AddToTail(&nentry);

		//ip->ProgressUpdate( i * 100 / nodes.Count() );
	}

	//ip->ProgressEnd();
}

void MergeTool::DeleteAllMergedNodes()
{ FUNC_ENTER("MergeTool::DeleteAllMergedNodes"); 
	Link<NodeEntry>* link=nodeDBmerge.GetHead();
	INodeTab nlist;

	while(link)
	{
		nlist.Append(1,&link->data.node);
		link=link->next;
	}

	int count = nlist.Count();

	ip->ClearNodeSelection();

	ip->SelectNodeTab(nlist,TRUE,FALSE);
	gpGUP->ExecuteStringScript("max delete\n");

	/*
	// First pass don't delete triggers
	while(link)
	{
		if (NodeExists(link->data.node) &&
			link->data.node->EvalWorldState(0).obj->ClassID() != vTRIGGER_CLASS_ID)
			ip->DeleteNode(link->data.node,FALSE,TRUE);

		link=link->next;
	}

	link=nodeDBmerge.GetHead();

	// Now, delete triggers
	while(link)
	{
		if (NodeExists(link->data.node) &&
			link->data.node->EvalWorldState(0).obj->ClassID() == vTRIGGER_CLASS_ID)
			ip->DeleteNode(link->data.node,FALSE,TRUE);

		link=link->next;
	}
	*/
}

void MergeTool::DeleteAllMergedMtls()
{ FUNC_ENTER("MergeTool::DeleteAllMergedMtls"); 
	// To delete the merged materials, we need to go through all the nodes
	// see if it uses the material to be deleted and reassign the node's material
	// to be NULL
	MtlBaseLib* mlib = ip->GetSceneMtls();

	Link<MatEntry>* link=matDBmerge.GetHead();

	while(link)
	{
		// We can't remove the materials directly from the material list
		// instead we'll go through the references to this material and set
		// the material on those nodes to NULL
		RefList& refList     = link->data.mtl->GetRefList();
		RefListItem* refItem = refList.FirstItem();
		RefListItem* refNext;

		while(refItem)
		{
			refNext = refItem->next;

			if (refItem->maker->ClassID()==Class_ID(BASENODE_CLASS_ID, 0))
			{
				INode* node = (INode*)refItem->maker;			
				
				// Instead of clearing out this material we'll now assign it a material with
				// the same name that exists within the original scene if one exists, if not
				// we'll assign it to NULL
				Mtl*  mtl = node->GetMtl();
		
				if (!mtl)
				{
					refItem = refNext;
					continue;
				}

				MatEntry mentry;
				mentry.name = mtl->GetName();

				Link<MatEntry>* link = matDB.Find(&mentry);
				
				if (link)
					node->SetMtl(link->data.mtl);
				else
					node->SetMtl(NULL);
			}

			refItem = refNext;
		}
		
		link=link->next;
	}
}

void MergeTool::DoMerge()
{ FUNC_ENTER("MergeTool::DoMerge"); 
	char mergeFile[1024];
	INode* root=ip->GetRootNode();

	if (IsDlgButtonChecked(hRollup,IDC_USEDMTLSONLY) == BST_UNCHECKED)
	{
		int rVal = MessageBox(hRollup,"WARNING!  Include used mtls is not checked.  Materials used in the file being merged will not be included.\nDo you wish to continue?","Include Used Mtls Unchecked",MB_ICONWARNING|MB_YESNO);

		if (rVal == IDNO)
			return;
	}

	GetDlgItemText(hRollup,IDC_FILENAME,mergeFile,1024);

	// Check if file is valid first
	FILE* fp = fopen(mergeFile,"r");
	
	if (!fp)
	{
		MessageBox(ip->GetMAXHWnd(),"Failed to load merge file.","Merge Failed",MB_OK|MB_ICONWARNING);
		return;
	}
	else
	{
		fclose(fp);
	}

	ICustEdit* edit;
	
	edit = GetICustEdit( GetDlgItem( hRollup, IDC_NODE_TOLERANCE ));
	nodeTolerance = edit->GetFloat();
	ReleaseICustEdit( edit );

	edit = GetICustEdit( GetDlgItem( hRollup, IDC_OBJECT_TOLERANCE ));
	objectTolerance = edit->GetFloat();
	ReleaseICustEdit( edit );

	char buf[256];
	CStr appDir=ip->GetDir(APP_PLUGCFG_DIR);
	appDir+="\\NxPrefs.ini";

	sprintf(buf, "%f", nodeTolerance);
	WritePrivateProfileString("Overlap","NodeTolerance",buf,appDir);

	sprintf(buf, "%f", objectTolerance);
	WritePrivateProfileString("Overlap","ObjectTolerance",buf,appDir);

	nodeTolerance *= 12.0f;	// Convert ft to inches
	objectTolerance /= 100.0f;	// Convert to pct

	// Clear out any old DB info
	matDB.Clear();
	matDBmerge.Clear();
	nodeDB.Clear();
	nodeDBmerge.Clear();	

	// No scene redrawing until the merge is completed
	ip->DisableSceneRedraw();

	// Lock the link selection change handler as it causes problems when
	// the merge tool manipulates the scene
	GetLinkMan()->SetLock(true);

	// Rename everything in the scene to avoid conflicts
	MtlRenamePre();

	numNodes = NodeSceneCount(root);
	nodeProg = 0;

	ip->ProgressStart(_T("Preprocessing source nodes"), TRUE, 
			          ProgressFunc, NULL );

	SceneRenamePre(root);

	ip->ProgressEnd();

	// If we're merging geometry we should create the selection set for the old geom now
	if (IsDlgButtonChecked(hRollup,IDC_MERGEGEOM)==BST_CHECKED)
	{
		// Create selection set of all nodes prior to merge
		INodeTab allNodes;
		GetAllNodes(allNodes);

		ip->RemoveNamedSelSet(CStr("MERGE - OLD"));
		ip->AddNewNamedSelSet(allNodes,CStr("MERGE - OLD"));
	}


	// Perform the standard MAX merge
	if (!ip->MergeFromFile(mergeFile,
						   TRUE,					// All items are merged
						   TRUE,					// The merged set is selected
						   FALSE,					// Don't refresh
						   MERGE_DUPS_PROMPT		// Prompts user for merge action (This shouldn't occur though
													// Since the names of everything should be unique now)
				    	  ))
	{
		MessageBox(ip->GetMAXHWnd(),"Failed to load merge file.","Merge Failed",MB_OK|MB_ICONWARNING);
		MtlRenamePost();
		SceneRenamePost(ip->GetRootNode());
		ip->EnableSceneRedraw();
		ip->ForceCompleteRedraw();

		// UnLock the link selection change handler
		GetLinkMan()->SetLock(false);
		return;
	}

	// Store all the newly added materials and nodes if we're processing all scene materials
	if (IsDlgButtonChecked(hRollup,IDC_USEDMTLSONLY)!=BST_CHECKED ||
		IsWindowEnabled(GetDlgItem(hRollup,IDC_USEDMTLSONLY))==FALSE)
	{
		BuildMtlMergeDB();
		MtlRenamePost();
	}
	
	ip->ProgressEnd();

	//BuildMtlMergeDB();
	BuildSceneMergeDB();

	// Restore names now that we have references to everything
	//MtlRenamePost();

	numNodes = NodeSceneCount(ip->GetRootNode());
	nodeProg = 0;

	//ip->ProgressEnd();
	//ip->ProgressStart(_T("Postprocessing source nodes"), TRUE, 
	//			      ProgressFunc, NULL );

	SceneRenamePost(root);

	//ip->ProgressEnd();

	bool bDelAllMergedNodes = false;

	// If we're merging in new geometry we can create the new merge set now
	// or delete all of it if we only wanted materials
	if (IsDlgButtonChecked(hRollup,IDC_MERGEGEOM)==BST_CHECKED &&
		IsWindowEnabled(GetDlgItem(hRollup,IDC_USEDMTLSONLY)))
	{
		// Bring up geometry merge list (so the user can select what we WON'T delete)
		if (nodeListDlg)
			delete nodeListDlg;

		nodeListDlg = new NodeMergeList(hInstance,hRollup,
			                            &nodeDB,&nodeDBmerge,ip);

		if (IsDlgButtonChecked(hRollup, IDC_AUTOTRIGRENAME) == BST_CHECKED)
		{
			nodeListDlg->EnableTriggerRename();
			nodeListDlg->IncludeTriggers(true);
		}
		else
		{
			nodeListDlg->DisableTriggerRename();
			nodeListDlg->IncludeTriggers(false);
		}

		// Check if aborted
		if (nodeListDlg->Show()==-1)
		{
			DeleteAllMergedNodes();
			GetLinkMan()->CleanAbandonedLinks();

			// If the material DB wasn't created yet we need to restore material names
			if (IsDlgButtonChecked(hRollup,IDC_USEDMTLSONLY)==BST_CHECKED)
				MtlRenamePost();

			ip->EnableSceneRedraw();
			ip->ForceCompleteRedraw();		

			// UnLock the link selection change handler
			GetLinkMan()->SetLock(false);

			return;
		}
		else
		{
			// Create selection set for all merged nodes
			INodeTab mergeNodes;
			GetNodeEntryNodes(nodeListDlg->GetFinalList(),mergeNodes);
			ip->RemoveNamedSelSet(CStr("MERGE - NEW"));
			ip->AddNewNamedSelSet(mergeNodes,CStr("MERGE - NEW"));

			CheckForOverlappingNodes( objectTolerance, nodeTolerance );
		}
	}
	else
	{
		bDelAllMergedNodes = true;
	}

	// Merge materials
	if (IsDlgButtonChecked(hRollup,IDC_MERGEMATS)==BST_CHECKED)
	{
		// Build material merge database for post-geometry merge processing (if appropriate)
		if (IsDlgButtonChecked(hRollup,IDC_USEDMTLSONLY)==BST_CHECKED &&
			IsWindowEnabled(GetDlgItem(hRollup,IDC_USEDMTLSONLY)))
		{
			BuildMtlMergeDB(nodeListDlg->GetFinalList());
			MtlRenamePost();
		}

		if (matListDlg)
			delete matListDlg;

		// Bring up material merge list (so the user can select what we WON'T delete)
		matListDlg = new MatMergeList(hInstance,hRollup,
			                          &matDB,&matDBmerge,ip);

		// Check if aborted
		if (matListDlg->Show()==-1)
		{
			DeleteAllMergedNodes();
			GetLinkMan()->CleanAbandonedLinks();

			ip->EnableSceneRedraw();
			ip->ForceCompleteRedraw();		

			// UnLock the link selection change handler
			GetLinkMan()->SetLock(false);

			return;
		}
	}
	else
	{
		if (IsDlgButtonChecked(hRollup,IDC_USEDMTLSONLY)==BST_CHECKED &&
			IsWindowEnabled(GetDlgItem(hRollup,IDC_USEDMTLSONLY)))
		{
			if (IsDlgButtonChecked(hRollup,IDC_USEDMTLSONLY)==BST_CHECKED)
				BuildMtlMergeDB(nodeListDlg->GetFinalList());
			else
				BuildMtlMergeDB();

			MtlRenamePost();

			if (matListDlg)
				delete matListDlg;

			// Bring up material merge list (so the user can select what we WON'T delete)
			matListDlg = new MatMergeList(hInstance,hRollup,
										  &matDB,&matDBmerge,ip);

			// Jason still wants the list to come up in this situation
			//matListDlg->SetAutoMerge(true);

			// Check if aborted
			if (matListDlg->Show()==-1)
			{
				DeleteAllMergedNodes();
				GetLinkMan()->CleanAbandonedLinks();

				ip->EnableSceneRedraw();
				ip->ForceCompleteRedraw();		

				// UnLock the link selection change handler
				GetLinkMan()->SetLock(false);

				return;
			}
		}
		else
			DeleteAllMergedMtls();
	}

	// Don't perform nodelist deletion until after materials are reassigned
	// (if done before hand the materials can be freed by MAX)
	if (bDelAllMergedNodes)
		DeleteAllMergedNodes();
	else
	{
		if (nodeListDlg)
			nodeListDlg->ProcDelLists();
	}

	GetLinkMan()->CleanAbandonedLinks();

	ip->EnableSceneRedraw();
	ip->ForceCompleteRedraw();

//////////////////////////////
	//dlg->Show();	

	// UnLock the link selection change handler
	GetLinkMan()->SetLock(false);
}

int MergeTool::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ FUNC_ENTER("MergeTool::DlgProc"); 
	static MergeTool* pthis = NULL;

	switch(msg)
	{
	case WM_INITDIALOG:
		pthis = (MergeTool*)lParam;
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_CHOOSEFILE:
			pthis->ChooseFile();
			return TRUE;

		case IDC_MERGEMATS:
			if (IsDlgButtonChecked(hwnd,IDC_MERGEMATS)==BST_CHECKED)
			{
				if (GetWindowTextLength(GetDlgItem(hwnd,IDC_FILENAME))>0)
					EnableWindow(GetDlgItem(hwnd,IDC_DOMERGE),TRUE);
			}
			else
			{
				if (IsDlgButtonChecked(hwnd,IDC_MERGEGEOM)==BST_UNCHECKED)
					EnableWindow(GetDlgItem(hwnd,IDC_DOMERGE),FALSE);
			}
			return TRUE;

		case IDC_MERGEGEOM:
			if (IsDlgButtonChecked(hwnd,IDC_MERGEGEOM)==BST_CHECKED)
			{
				if (GetWindowTextLength(GetDlgItem(hwnd,IDC_FILENAME))>0)
					EnableWindow(GetDlgItem(hwnd,IDC_DOMERGE),TRUE);

				EnableWindow(GetDlgItem(hwnd,IDC_USEDMTLSONLY),TRUE);
			}
			else
			{
				if (IsDlgButtonChecked(hwnd,IDC_MERGEMATS)==BST_UNCHECKED)
					EnableWindow(GetDlgItem(hwnd,IDC_DOMERGE),FALSE);

				EnableWindow(GetDlgItem(hwnd,IDC_USEDMTLSONLY),FALSE);
			}
			return TRUE;

		case IDC_DOMERGE:
			pthis->DoMerge();
			return TRUE;
		}
	}

	return FALSE;
}

BOOL CALLBACK testDlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("testDlgProc"); 
	switch(msg)
	{
	case WM_INITDIALOG:
		return TRUE;

	case WM_CLOSE:
		EndDialog(hwnd,0);
		return TRUE;
	}

	return FALSE;
}


bool MergeTool::NodeExists(INode* node,INode* root)
{ FUNC_ENTER("MergeTool::NodeExists"); 
	if (!root)
		root = ip->GetRootNode();

	int kids = root->NumberOfChildren();

	for(int i=0; i<kids; i++)
	{
		INode* child = root->GetChildNode(i);
		
		if (NodeExists(node,child))
			return true;
	}

	if (node == root)
		return true;

	return false;
}

BOOL MergeActionCB::ExecuteAction(int id)
{ FUNC_ENTER("MergeActionCB::ExecuteAction"); 
	IUtilityPanel* iutil = (IUtilityPanel*)GetCOREInterface(IUTIL_FO_INTERFACE);
	
	assert(iutil);
	iutil->OpenUtility(&theMergeToolDesc);	

	if( s_merge_tool )
	{
		if( s_merge_tool->ChooseFile())
		{
			s_merge_tool->DoMerge();
		}
	}

	return TRUE;
}

ActionTable* GetMergeActions( void )
{ FUNC_ENTER("GetMergeActions"); 
    TSTR name = _T("Neversoft Merge Tool");
    HACCEL hAccel = LoadAccelerators(hInstance,
                                     MAKEINTRESOURCE(IDR_MERGE_ACCELERATOR));
    int numOps = sizeof(s_merge_actions) / sizeof(s_merge_actions[0]);
    ActionTable* pTab;
    pTab = new ActionTable( merge_actions, merge_actions_context, name, hAccel, numOps,
                             s_merge_actions, hInstance);
    GetCOREInterface()->GetActionManager()->RegisterActionContext( merge_actions_context, name.data());

    return pTab;
}

bool RegMergeActionAccelerators()
{ FUNC_ENTER("RegMergeActionAccelerators"); 
	mergeAccel=new MergeActionCB;

	if (!GetCOREInterface()->GetActionManager()->ActivateActionTable(mergeAccel, merge_actions))
	{
		MessageBox(NULL,"ActionTable Failed to instantiate","Merge Tool",MB_OK);
		return false;
	}

	return true;
}

void UnRegMergeActionAccelerators()
{ FUNC_ENTER("UnRegMergeActionAccelerators"); 
	delete mergeAccel;
	mergeAccel=NULL;
}
