#ifndef __MULTI_H__
#define __MULTI_H__

#include "NextMultiMat.h"
#include "MAXHash.h"
#include "stdmat.h"
#include "iparamm2.h"

// JBW: IDs for ParamBlock2 blocks and parameters
// Parameter and ParamBlock IDs

enum { multi_params, };  		// pblock ID

enum							// multi_params param IDs
{ 
	multi_mtls,
	multi_ons,
	multi_names,
	multi_ids,
};

class Multi : public MultiMtl, public IReshading
{
	friend class MultiDlg;
	friend class SetNumMtlsRestore;
	friend class DelSubRestore;
	friend class AddMtlsRestore;
	friend class SetSubRestore;

	// Animatable parameters
	Interval 	ivalid;
	ReshadeRequirements mReshadeRQ; // mjm - 06.02.00
	MultiDlg 	*paramDlg;
	int 		offset;
	int 		selected;

public:

	NameTab 	subNames;
	Tab<Mtl *>	subMtl;

#if USE_HASHING
	// allow fast conversions for sub-material id --> actual submaterial slot #
	// (use int for the key, instead of short int, since -1 is reserved in the table)
	MyHashTable< int, int >  hashTab;
	int			hashTabDirty;
#endif

//	Tab<BOOL>	mapOn;

	BOOL 		Param1;
	BOOL 		ignoreNotify;
	IParamBlock2 *pblock;   // ref #0		
	int 		maxMtlId;	// current max material id used in the list...needs to be updated when anything changes

	BOOL 		loadingOld;
	void 		AddMtl();
	void 		DeleteSelMtl();
	void        DeleteSubMtl(int sel);		// aml - Neversoft
	bool        DeleteSubMtl(Mtl* mtl);		// aml - Neversoft
	bool        DeleteSubMtl(TSTR name);	// aml - Neversoft
	int         GetMtlID(Mtl* mtl);			// aml - Neversoft (retrieves mtl ID from mtl, warning: linear search)
	void 		SortMtls( CompareFnc cmp );
	void 		SortMtlsByName();
	void 		SortMtlsByID();
	void 		SortMtlsBySlotName();
	BOOL 		AnyDupIDs();
//	BOOL 		IsIDDup( int k );
	void 		SetNumSubMtls( int n );
//	void 		SetNSubMtls( int num );
	void 		GetSubMtlName( int mtlid, TSTR &s );
	void 		SetSubMtlAndName( int mtlid, Mtl *m, TSTR &subMtlName );
	void 		ClampOffset();
	Sampler*	GetPixelSampler(int mtlNum, BOOL backFace );

	void 		SetAmbient(   Color c, TimeValue t )  {}		
	void 		SetDiffuse(   Color c, TimeValue t )  {}		
	void 		SetSpecular(  Color c, TimeValue t )  {}
	void 		SetShininess( float v, TimeValue t )  {}		
	void 		SetThresh(    float v, TimeValue t);
	void 		SetWidth(     float v, TimeValue t);

	Mtl *		UseMtl();
	Color 		GetAmbient(   int mtlNum = 0, BOOL backFace = FALSE );
    Color 		GetDiffuse(   int mtlNum = 0, BOOL backFace = FALSE );
	Color 		GetSpecular(  int mtlNum = 0, BOOL backFace = FALSE );
	float 		GetXParency(  int mtlNum = 0, BOOL backFace = FALSE );
	float 		GetShininess( int mtlNum = 0, BOOL backFace = FALSE );		
	float 		GetShinStr(   int mtlNum = 0, BOOL backFace = FALSE );
	float 		WireSize(     int mtlNum = 0, BOOL backFace = FALSE );

	            Multi( BOOL loading, BOOL createDefaultSubMtls = TRUE ); // mjm - 10.11.99 - added createDefaultSubMtls parameter
	void 		SetParamDlg( MultiDlg *pd ) 	{ paramDlg = pd; }
	ParamDlg * 	CreateParamDlg( HWND hwMtlEdit, IMtlParams *imp );
	void 		Shade( ShadeContext &sc );
	float 		EvalDisplacement( ShadeContext &sc ); 
	Interval 	DisplacementValidity( TimeValue t ); 
	void 		Update( TimeValue t, Interval &valid );
	void 		Init();
	void 		Reset();
	Interval 	Validity( TimeValue t );
	void 		NotifyChanged();

	//Class_ID 	ClassID() 					{ return multiClassID; }
	Class_ID    ClassID();
	SClass_ID 	SuperClassID() 				{ return MATERIAL_CLASS_ID; }
	void 		GetClassName( TSTR &s ) 	{ s = GetString(IDS_RB_MULTISUBOBJECT); }  

	void 		DeleteThis() 				{ delete this; }	


	// Methods to access sub-materials of meta-materials

#if USE_HASHING
	void		UpdateHashTable()
		        {
					int 	count;								// # of sub-materials to search
					int 	id;									// id of the sub material
					Interval iv;								// and interval
					int		i;									// loop var

					// wipe values in the table
					hashTab.Clean();

					// search through all our slots for the MAXIMUM id #
					maxMtlId = -1;						// start with max set to -1
					count = subMtl.Count();
					for ( i = 0;  i < count;  i++ ) 
					{
						// grab the id value from the param block (slow)
						pblock->GetValue( multi_ids, 0, id, iv, i ); 
						if ( id > maxMtlId ) 
							maxMtlId = id;

						// add to hash map
						hashTab.AddAssociation( id, i );
					}

					// hash table not dirty anymore
					hashTabDirty = 0;
				}
#endif

   	int 		MaxSubMtlID() 
				{ 
#if USE_HASHING
					if ( hashTabDirty )
						UpdateHashTable();

					return maxMtlId ;
#else
					int 	mx;									// max id # found
					int 	count;								// # of sub-materials to search
					int 	id;									// id of the sub material
					Interval iv;								// and interval
					int		i;									// loop var

					// search through all our slots for the MAXIMUM id #
					mx = -1;						// start with max set to -1
					count = subMtl.Count();
					for ( i = 0;  i < count;  i++ ) 
					{
						// grab the id value from the param block (slow)
						pblock->GetValue( multi_ids, 0, id, iv, i ); 
						if ( id > mx ) 
							mx = id;
					}

					// return maximum id# found
					return mx; 
#endif
				}

	int 		NumSubMtls() 
				{
#if USE_HASHING
					if ( hashTabDirty )
						UpdateHashTable();

					return maxMtlId + 1;   // why does this return the max id and not count?????
#else
					return MaxSubMtlID() + 1;   // was - return subMtl.Count(); 
#endif
				}

	int  		FindSubMtl( int i ) 
				{
#if USE_HASHING
					// rebuild hash table if dirty
					if ( hashTabDirty )
						UpdateHashTable();

					// use hash table to find the index find the value associated with the material id key
					int idx = hashTab.GetIndex( i );
					if ( idx == -1 )
						return -1;
					else
						return hashTab[idx];					// value
#else
					int 	j;									// loop var
					int 	id;									// id of sub material in loop
					Interval iv;								// and interval

					// find a specific sub-material 'i'
					// this should be in a table instead!
					for ( j = 0;  j < subMtl.Count();  j++ ) 
					{
						pblock->GetValue( multi_ids, 0, id, iv, j ); 
						if ( id == i )
							return j;
					}
					return -1;
#endif
				}

	int 		FindSubMtlMod( int mtlid ) 
				{
#if USE_HASHING
					// rebuild hash table if dirty
					if ( hashTabDirty )
						UpdateHashTable();

					// bail out if no materials
					if ( maxMtlId == -1 )
						return -1;

					// take care of wraparound.
					// note: we need the UpdateHashTable() above to recalculate maxMtlId
					if ( mtlid > maxMtlId ) 		
						mtlid = mtlid % ( maxMtlId + 1 );

					// use hash table to find the index find the value associated with the material id key
					int idx = hashTab.GetIndex( mtlid );
					if ( idx == -1 )
						return -1;
					else
						return hashTab[idx];					// value
#else
					if ( maxMtlId == -1 )
						return -1;
					if ( mtlid > maxMtlId ) 		
						mtlid = mtlid % ( maxMtlId + 1 );
					return FindSubMtl( mtlid );  // IS THIS GOING TO SLOW THINGS DOWN?
#endif
				}

	Mtl * 		GetSubMtl( int i ) 
				{ 
#if USE_HASHING
					// rebuild hash table if dirty
					if ( hashTabDirty )
						UpdateHashTable();

					// get the submaterial ptr
					int idx = hashTab.GetIndex( i );
					return ( idx == -1 ) ? NULL : subMtl[ hashTab[idx] ]; // 4/13/01 4:44pm --MQM-- from subMtl[idx] to subMtl[ hashTab[idx] ]
#else
					int j = FindSubMtl( i );
					return ( j >= 0 ) ? subMtl[j] : NULL;
#endif
				}


	void 		SetSubMtl( int i, Mtl *m );
	TSTR 		GetSubMtlSlotName( int i );
	BOOL 		IsMultiMtl() 		{ return TRUE; }

	int 		NumSubs() 			{ return subMtl.Count(); }  
	Animatable *  SubAnim( int i );
	TSTR 		SubAnimName( int i );
	int 		SubNumToRefNum( int subNum )  { return subNum+1; }

	// From ref
	int 		NumRefs()  { return loadingOld ? subMtl.Count()+1 : subMtl.Count()+1;  }
	RefTargetHandle  GetReference( int i );
	void 		SetReference( int i, RefTargetHandle rtarg );
	int 		RemapRefOnLoad( int iref ) ;

	RefTargetHandle  Clone( RemapDir &remap = NoRemap() );
	RefResult 	NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, PartID &partID, RefMessage message );

	// IO
	IOResult 	Save( ISave *isave );
	IOResult 	Load( ILoad *iload );

	// JBW: direct ParamBlock access is added
	int			NumParamBlocks()  					{ return 1; }					// return number of ParamBlocks in this instance
	IParamBlock2 *  GetParamBlock( int i ) 			{ return pblock; } 				// return i'th ParamBlock
	IParamBlock2 *  GetParamBlockByID( BlockID id ) { return ( pblock->ID() == id ) ? pblock : NULL; } // return id'd ParamBlock

	// begin - ke/mjm - 03.16.00 - merge reshading code
	BOOL 		SupportsRenderElements()			{ return TRUE; }
//		BOOL SupportsReShading(ShadeContext& sc);
	ReshadeRequirements  GetReshadeRequirements() 	{ return mReshadeRQ; }			// mjm - 06.02.00
	void 		PreShade(  ShadeContext &sc, IReshadeFragment *pFrag);
	void 		PostShade( ShadeContext &sc, IReshadeFragment *pFrag, int &nextTexIndex, IllumParams *ip );
	// end - ke/mjm - 03.16.00 - merge reshading code

	// From Mtl
	bool 		IsOutputConst(       ShadeContext &sc, int stdID );
	bool 		EvalColorStdChannel( ShadeContext &sc, int stdID, Color &outClr );
	bool 		EvalMonoStdChannel(  ShadeContext &sc, int stdID, float &outVal );

	void * 		GetInterface( ULONG id );
};

#endif
